/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequestExt;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Diagnostics;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.AdjustableSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCmdDistributor {
    private static final int MAX_RETRIES_ON_FORWARD = 15;
    public static Logger log = LoggerFactory.getLogger(SolrCmdDistributor.class);
    static AdjustableSemaphore semaphore = new AdjustableSemaphore(8);
    CompletionService<Request> completionService;
    Set<Future<Request>> pending;
    int maxBufferedAddsPerServer = 10;
    int maxBufferedDeletesPerServer = 10;
    private Response response = new Response();
    private final Map<Node, List<AddRequest>> adds = new HashMap<Node, List<AddRequest>>();
    private final Map<Node, List<DeleteRequest>> deletes = new HashMap<Node, List<DeleteRequest>>();
    private UpdateShardHandler updateShardHandler;
    public static Diagnostics.Callable testing_errorHook;

    public SolrCmdDistributor(int numHosts, UpdateShardHandler updateShardHandler) {
        int maxPermits = Math.max(16, numHosts * 16);
        if (maxPermits != semaphore.getMaxPermits()) {
            semaphore.setMaxPermits(maxPermits);
        }
        this.updateShardHandler = updateShardHandler;
        this.completionService = new ExecutorCompletionService<Request>(updateShardHandler.getCmdDistribExecutor());
        this.pending = new HashSet<Future<Request>>();
    }

    public void finish() {
        this.flushAdds(1);
        this.flushDeletes(1);
        this.checkResponses(true);
    }

    public void distribDelete(DeleteUpdateCommand cmd, List<Node> urls, ModifiableSolrParams params) throws IOException {
        this.checkResponses(false);
        if (cmd.isDeleteById()) {
            this.doDelete(cmd, urls, params);
        } else {
            this.doDelete(cmd, urls, params);
        }
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.checkResponses(false);
        this.flushDeletes(1);
        AddUpdateCommand clone = new AddUpdateCommand(null);
        clone.solrDoc = cmd.solrDoc;
        clone.commitWithin = cmd.commitWithin;
        clone.overwrite = cmd.overwrite;
        clone.setVersion(cmd.getVersion());
        AddRequest addRequest = new AddRequest();
        addRequest.cmd = clone;
        addRequest.params = params;
        for (Node node : nodes) {
            List<AddRequest> alist = this.adds.get(node);
            if (alist == null) {
                alist = new ArrayList<AddRequest>(2);
                this.adds.put(node, alist);
            }
            alist.add(addRequest);
        }
        this.flushAdds(this.maxBufferedAddsPerServer);
    }

    public void distribCommit(CommitUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.flushAdds(1);
        this.flushDeletes(1);
        this.checkResponses(true);
        UpdateRequestExt ureq = new UpdateRequestExt();
        ureq.setParams(params);
        this.addCommit(ureq, cmd);
        log.info("Distrib commit to:" + nodes + " params:" + params);
        for (Node node : nodes) {
            this.submit(ureq, node);
        }
        if (cmd.waitSearcher) {
            this.checkResponses(true);
        }
    }

    private void doDelete(DeleteUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) {
        this.flushAdds(1);
        DeleteUpdateCommand clonedCmd = this.clone(cmd);
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.cmd = clonedCmd;
        deleteRequest.params = params;
        for (Node node : nodes) {
            List<DeleteRequest> dlist = this.deletes.get(node);
            if (dlist == null) {
                dlist = new ArrayList<DeleteRequest>(2);
                this.deletes.put(node, dlist);
            }
            dlist.add(deleteRequest);
        }
        this.flushDeletes(this.maxBufferedDeletesPerServer);
    }

    void addCommit(UpdateRequestExt ureq, CommitUpdateCommand cmd) {
        if (cmd == null) {
            return;
        }
        ureq.setAction(cmd.optimize ? AbstractUpdateRequest.ACTION.OPTIMIZE : AbstractUpdateRequest.ACTION.COMMIT, false, cmd.waitSearcher, cmd.maxOptimizeSegments, cmd.softCommit, cmd.expungeDeletes);
    }

    boolean flushAdds(int limit) {
        HashSet<Node> removeNodes = new HashSet<Node>();
        Set<Node> nodes = this.adds.keySet();
        for (Node node : nodes) {
            List<AddRequest> alist = this.adds.get(node);
            if (alist == null || alist.size() < limit) continue;
            UpdateRequestExt ureq = new UpdateRequestExt();
            ModifiableSolrParams combinedParams = new ModifiableSolrParams();
            for (AddRequest aReq : alist) {
                AddUpdateCommand cmd = aReq.cmd;
                combinedParams.add((SolrParams)aReq.params);
                ureq.add(cmd.solrDoc, cmd.commitWithin, cmd.overwrite);
            }
            if (ureq.getParams() == null) {
                ureq.setParams(new ModifiableSolrParams());
            }
            ureq.getParams().add((SolrParams)combinedParams);
            removeNodes.add(node);
            this.submit(ureq, node);
        }
        for (Node node : removeNodes) {
            this.adds.remove(node);
        }
        return true;
    }

    boolean flushDeletes(int limit) {
        HashSet<Node> removeNodes = new HashSet<Node>();
        Set<Node> nodes = this.deletes.keySet();
        for (Node node : nodes) {
            List<DeleteRequest> dlist = this.deletes.get(node);
            if (dlist == null || dlist.size() < limit) continue;
            UpdateRequestExt ureq = new UpdateRequestExt();
            ModifiableSolrParams combinedParams = new ModifiableSolrParams();
            for (DeleteRequest dReq : dlist) {
                DeleteUpdateCommand cmd = dReq.cmd;
                combinedParams.add((SolrParams)dReq.params);
                if (cmd.isDeleteById()) {
                    ureq.deleteById(cmd.getId(), Long.valueOf(cmd.getVersion()));
                } else {
                    ureq.deleteByQuery(cmd.query);
                }
                if (ureq.getParams() == null) {
                    ureq.setParams(new ModifiableSolrParams());
                }
                ureq.getParams().add((SolrParams)combinedParams);
            }
            removeNodes.add(node);
            this.submit(ureq, node);
        }
        for (Node node : removeNodes) {
            this.deletes.remove(node);
        }
        return true;
    }

    private DeleteUpdateCommand clone(DeleteUpdateCommand cmd) {
        DeleteUpdateCommand c = (DeleteUpdateCommand)cmd.clone();
        c.setFlags(cmd.getFlags());
        c.setVersion(cmd.getVersion());
        return c;
    }

    void submit(UpdateRequestExt ureq, Node node) {
        Request sreq = new Request();
        sreq.node = node;
        sreq.ureq = ureq;
        this.submit(sreq);
    }

    public void submit(final Request sreq) {
        final String url = sreq.node.getUrl();
        Callable<Request> task = new Callable<Request>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Request call() throws Exception {
                Request clonedRequest = null;
                try {
                    clonedRequest = new Request();
                    clonedRequest.node = sreq.node;
                    clonedRequest.ureq = sreq.ureq;
                    clonedRequest.retries = sreq.retries;
                    String fullUrl = !url.startsWith("http://") && !url.startsWith("https://") ? "http://" + url : url;
                    HttpSolrServer server = new HttpSolrServer(fullUrl, SolrCmdDistributor.this.updateShardHandler.getHttpClient());
                    if (Thread.currentThread().isInterrupted()) {
                        clonedRequest.rspCode = 503;
                        clonedRequest.exception = new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Shutting down.");
                        Request request = clonedRequest;
                        return request;
                    }
                    clonedRequest.ursp = server.request((SolrRequest)clonedRequest.ureq);
                }
                catch (Exception e) {
                    clonedRequest.exception = e;
                    clonedRequest.rspCode = e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1;
                }
                finally {
                    semaphore.release();
                }
                return clonedRequest;
            }
        };
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Update thread interrupted", (Throwable)e);
        }
        try {
            this.pending.add(this.completionService.submit(task));
        }
        catch (RejectedExecutionException e) {
            semaphore.release();
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Shutting down", (Throwable)e);
        }
    }

    void checkResponses(boolean block) {
        while (this.pending != null && this.pending.size() > 0) {
            try {
                Future<Request> future;
                Future<Request> future2 = future = block ? this.completionService.take() : this.completionService.poll();
                if (future == null) {
                    return;
                }
                this.pending.remove(future);
                try {
                    Request sreq = future.get();
                    if (sreq.rspCode == 0) continue;
                    if (testing_errorHook != null) {
                        Diagnostics.call(testing_errorHook, this, sreq);
                    }
                    boolean isRetry = sreq.node.checkRetry();
                    boolean doRetry = false;
                    int rspCode = sreq.rspCode;
                    if (isRetry) {
                        if (rspCode == 404 || rspCode == 403 || rspCode == 503 || rspCode == 500) {
                            doRetry = true;
                        }
                        if (sreq.exception instanceof IOException) {
                            doRetry = true;
                        } else if (sreq.exception instanceof SolrServerException && ((SolrServerException)((Object)sreq.exception)).getRootCause() instanceof IOException) {
                            doRetry = true;
                        }
                    }
                    if (isRetry && sreq.retries < 15 && doRetry) {
                        ++sreq.retries;
                        sreq.rspCode = 0;
                        sreq.exception = null;
                        SolrException.log((Logger)log, (String)("forwarding update to " + sreq.node.getUrl() + " failed - retrying ... "));
                        Thread.sleep(500L);
                        this.submit(sreq);
                        continue;
                    }
                    Exception e = sreq.exception;
                    Error error = new Error();
                    error.e = e;
                    error.node = sreq.node;
                    this.response.errors.add(error);
                    this.response.sreq = sreq;
                    SolrException.log((Logger)log, (String)("shard update error " + sreq.node), (Throwable)sreq.exception);
                }
                catch (ExecutionException e) {
                    SolrException.log((Logger)SolrCore.log, (String)"error sending update request to shard", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "interrupted waiting for shard update response", (Throwable)e);
            }
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public static class StdNode
    extends Node {
        protected ZkCoreNodeProps nodeProps;

        public StdNode(ZkCoreNodeProps nodeProps) {
            this.nodeProps = nodeProps;
        }

        @Override
        public String getUrl() {
            return this.nodeProps.getCoreUrl();
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.nodeProps.getCoreUrl();
        }

        @Override
        public boolean checkRetry() {
            return false;
        }

        @Override
        public String getBaseUrl() {
            return this.nodeProps.getBaseUrl();
        }

        @Override
        public String getCoreName() {
            return this.nodeProps.getCoreName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            String baseUrl = this.nodeProps.getBaseUrl();
            String coreName = this.nodeProps.getCoreName();
            String url = this.nodeProps.getCoreUrl();
            result = 31 * result + (baseUrl == null ? 0 : baseUrl.hashCode());
            result = 31 * result + (coreName == null ? 0 : coreName.hashCode());
            result = 31 * result + (url == null ? 0 : url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StdNode other = (StdNode)obj;
            String baseUrl = this.nodeProps.getBaseUrl();
            String coreName = this.nodeProps.getCoreName();
            String url = this.nodeProps.getCoreUrl();
            if (baseUrl == null ? other.nodeProps.getBaseUrl() != null : !baseUrl.equals(other.nodeProps.getBaseUrl())) {
                return false;
            }
            if (coreName == null ? other.nodeProps.getCoreName() != null : !coreName.equals(other.nodeProps.getCoreName())) {
                return false;
            }
            return !(url == null ? other.nodeProps.getCoreUrl() != null : !url.equals(other.nodeProps.getCoreUrl()));
        }

        @Override
        public ZkCoreNodeProps getNodeProps() {
            return this.nodeProps;
        }
    }

    public static abstract class Node {
        public abstract String getUrl();

        public abstract boolean checkRetry();

        public abstract String getCoreName();

        public abstract String getBaseUrl();

        public abstract ZkCoreNodeProps getNodeProps();
    }

    public static class Error {
        public Node node;
        public Exception e;
    }

    public static class Response {
        public Request sreq;
        public List<Error> errors = new ArrayList<Error>();
    }

    public static class Request {
        public Node node;
        UpdateRequestExt ureq;
        NamedList<Object> ursp;
        int rspCode;
        public Exception exception;
        int retries;
    }

    public static interface AbortCheck {
        public boolean abortCheck();
    }

    class DeleteRequest {
        DeleteUpdateCommand cmd;
        ModifiableSolrParams params;

        DeleteRequest() {
        }
    }

    class AddRequest {
        AddUpdateCommand cmd;
        ModifiableSolrParams params;

        AddRequest() {
        }
    }
}

