/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocTermOrdsRangeFilter;
import org.apache.lucene.search.DocTermOrdsRewriteMethod;
import org.apache.lucene.search.FieldCacheRangeFilter;
import org.apache.lucene.search.FieldCacheRewriteMethod;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldProperties;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.Sorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldType
extends FieldProperties {
    public static final Logger log = LoggerFactory.getLogger(FieldType.class);
    public static final String POLY_FIELD_SEPARATOR = "___";
    protected String typeName;
    protected Map<String, String> args;
    protected int trueProperties;
    protected int falseProperties;
    protected int properties;
    private boolean isExplicitQueryAnalyzer;
    private boolean isExplicitAnalyzer;
    protected Analyzer analyzer;
    protected Analyzer queryAnalyzer;
    protected SimilarityFactory similarityFactory;
    protected Similarity similarity;
    protected String postingsFormat;
    protected String docValuesFormat;
    public static final String TYPE = "type";
    public static final String TYPE_NAME = "name";
    public static final String CLASS_NAME = "class";
    public static final String ANALYZER = "analyzer";
    public static final String INDEX = "index";
    public static final String INDEX_ANALYZER = "indexAnalyzer";
    public static final String QUERY = "query";
    public static final String QUERY_ANALYZER = "queryAnalyzer";
    public static final String MULTI_TERM = "multiterm";
    public static final String MULTI_TERM_ANALYZER = "multiTermAnalyzer";
    public static final String SIMILARITY = "similarity";
    public static final String CHAR_FILTER = "charFilter";
    public static final String CHAR_FILTERS = "charFilters";
    public static final String TOKENIZER = "tokenizer";
    public static final String FILTER = "filter";
    public static final String FILTERS = "filters";
    private static final String POSTINGS_FORMAT = "postingsFormat";
    private static final String DOC_VALUES_FORMAT = "docValuesFormat";
    private static final String AUTO_GENERATE_PHRASE_QUERIES = "autoGeneratePhraseQueries";
    private static final String ARGS = "args";
    private static final String POSITION_INCREMENT_GAP = "positionIncrementGap";

    public FieldType() {
        this.queryAnalyzer = this.analyzer = new DefaultAnalyzer(256);
    }

    public boolean isTokenized() {
        return (this.properties & 2) != 0;
    }

    public boolean isMultiValued() {
        return (this.properties & 0x200) != 0;
    }

    protected boolean hasProperty(int p) {
        return (this.properties & p) != 0;
    }

    public boolean isPolyField() {
        return false;
    }

    public boolean multiValuedFieldCache() {
        return this.isTokenized();
    }

    protected void init(IndexSchema schema, Map<String, String> args) {
    }

    protected void setArgs(IndexSchema schema, Map<String, String> args) {
        this.properties = 5;
        float schemaVersion = schema.getVersion();
        if (schemaVersion < 1.1f) {
            this.properties |= 0x200;
        }
        if (schemaVersion > 1.1f) {
            this.properties |= 0x20;
        }
        if ((double)schemaVersion < 1.3) {
            args.remove("compressThreshold");
        }
        this.args = Collections.unmodifiableMap(args);
        HashMap<String, String> initArgs = new HashMap<String, String>(args);
        initArgs.remove(CLASS_NAME);
        this.trueProperties = FieldProperties.parseProperties(initArgs, true, false);
        this.falseProperties = FieldProperties.parseProperties(initArgs, false, false);
        this.properties &= ~this.falseProperties;
        this.properties |= this.trueProperties;
        for (String prop : FieldProperties.propertyNames) {
            initArgs.remove(prop);
        }
        this.init(schema, initArgs);
        String positionInc = (String)initArgs.get(POSITION_INCREMENT_GAP);
        if (positionInc != null) {
            Analyzer analyzer = this.getAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            analyzer = this.getQueryAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            initArgs.remove(POSITION_INCREMENT_GAP);
        }
        this.postingsFormat = (String)initArgs.remove(POSTINGS_FORMAT);
        this.docValuesFormat = (String)initArgs.remove(DOC_VALUES_FORMAT);
        if (initArgs.size() > 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ")" + " invalid arguments:" + initArgs);
        }
    }

    protected void restrictProps(int props) {
        if ((this.properties & props) != 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ")" + " invalid properties:" + FieldType.propertiesToString(this.properties & props));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return this.typeName + "{class=" + this.getClass().getName() + (this.analyzer != null ? ",analyzer=" + this.analyzer.getClass().getName() : "") + ",args=" + this.args + "}";
    }

    public IndexableField createField(SchemaField field, Object value, float boost) {
        String val;
        if (!field.indexed() && !field.stored()) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        try {
            val = this.toInternal(value.toString());
        }
        catch (RuntimeException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while creating field '" + field + "' from value '" + value + "'", (Throwable)e);
        }
        if (val == null) {
            return null;
        }
        org.apache.lucene.document.FieldType newType = new org.apache.lucene.document.FieldType();
        newType.setIndexed(field.indexed());
        newType.setTokenized(field.isTokenized());
        newType.setStored(field.stored());
        newType.setOmitNorms(field.omitNorms());
        newType.setIndexOptions(this.getIndexOptions(field, val));
        newType.setStoreTermVectors(field.storeTermVector());
        newType.setStoreTermVectorOffsets(field.storeTermOffsets());
        newType.setStoreTermVectorPositions(field.storeTermPositions());
        return this.createField(field.getName(), val, newType, boost);
    }

    protected IndexableField createField(String name, String val, org.apache.lucene.document.FieldType type, float boost) {
        Field f = new Field(name, val, type);
        f.setBoost(boost);
        return f;
    }

    public List<IndexableField> createFields(SchemaField field, Object value, float boost) {
        IndexableField f = this.createField(field, value, boost);
        if (field.hasDocValues() && f.fieldType().docValueType() == null) {
            throw new UnsupportedOperationException("This field type does not support doc values: " + this);
        }
        return f == null ? Collections.emptyList() : Collections.singletonList(f);
    }

    protected FieldInfo.IndexOptions getIndexOptions(SchemaField field, String internalVal) {
        FieldInfo.IndexOptions options = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        if (field.omitTermFreqAndPositions()) {
            options = FieldInfo.IndexOptions.DOCS_ONLY;
        } else if (field.omitPositions()) {
            options = FieldInfo.IndexOptions.DOCS_AND_FREQS;
        } else if (field.storeOffsetsWithPositions()) {
            options = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        return options;
    }

    public String toInternal(String val) {
        return val;
    }

    public String toExternal(IndexableField f) {
        return f.stringValue();
    }

    public Object toObject(IndexableField f) {
        return this.toExternal(f);
    }

    public Object toObject(SchemaField sf, BytesRef term) {
        CharsRef ref = new CharsRef(term.length);
        this.indexedToReadable(term, ref);
        IndexableField f = this.createField(sf, ref.toString(), 1.0f);
        return this.toObject(f);
    }

    public String indexedToReadable(String indexedForm) {
        return indexedForm;
    }

    public CharsRef indexedToReadable(BytesRef input, CharsRef output) {
        UnicodeUtil.UTF8toUTF16((BytesRef)input, (CharsRef)output);
        return output;
    }

    public String storedToReadable(IndexableField f) {
        return this.toExternal(f);
    }

    public String storedToIndexed(IndexableField f) {
        return f.stringValue();
    }

    public String readableToIndexed(String val) {
        return this.toInternal(val);
    }

    public void readableToIndexed(CharSequence val, BytesRef result) {
        String internal = this.readableToIndexed(((Object)val).toString());
        UnicodeUtil.UTF16toUTF8((CharSequence)internal, (int)0, (int)internal.length(), (BytesRef)result);
    }

    public void setIsExplicitQueryAnalyzer(boolean isExplicitQueryAnalyzer) {
        this.isExplicitQueryAnalyzer = isExplicitQueryAnalyzer;
    }

    public boolean isExplicitQueryAnalyzer() {
        return this.isExplicitQueryAnalyzer;
    }

    public void setIsExplicitAnalyzer(boolean explicitAnalyzer) {
        this.isExplicitAnalyzer = explicitAnalyzer;
    }

    public boolean isExplicitAnalyzer() {
        return this.isExplicitAnalyzer;
    }

    public String getClassArg() {
        String className;
        if (null != this.args && null != (className = this.args.get(CLASS_NAME))) {
            return className;
        }
        return this.getClass().getName();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FieldType: " + this.getClass().getSimpleName() + " (" + this.typeName + ") does not support specifying an analyzer");
    }

    public void setQueryAnalyzer(Analyzer analyzer) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FieldType: " + this.getClass().getSimpleName() + " (" + this.typeName + ") does not support specifying an analyzer");
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public SimilarityFactory getSimilarityFactory() {
        return this.similarityFactory;
    }

    public FieldType.NumericType getNumericType() {
        return null;
    }

    public void setSimilarity(SimilarityFactory similarityFactory) {
        this.similarityFactory = similarityFactory;
        this.similarity = similarityFactory.getSimilarity();
    }

    public String getPostingsFormat() {
        return this.postingsFormat;
    }

    public final String getDocValuesFormat() {
        return this.docValuesFormat;
    }

    public abstract void write(TextResponseWriter var1, String var2, IndexableField var3) throws IOException;

    public abstract SortField getSortField(SchemaField var1, boolean var2);

    protected SortField getStringSort(SchemaField field, boolean reverse) {
        field.checkSortability();
        return Sorting.getStringSortField(field.name, reverse, field.sortMissingLast(), field.sortMissingFirst());
    }

    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new StrFieldSource(field.name);
    }

    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        if (field.hasDocValues() && !field.indexed()) {
            if (field.multiValued()) {
                return new ConstantScoreQuery((Filter)DocTermOrdsRangeFilter.newBytesRefRange((String)field.getName(), (BytesRef)(part1 == null ? null : new BytesRef((CharSequence)this.toInternal(part1))), (BytesRef)(part2 == null ? null : new BytesRef((CharSequence)this.toInternal(part2))), (boolean)minInclusive, (boolean)maxInclusive));
            }
            return new ConstantScoreQuery((Filter)FieldCacheRangeFilter.newStringRange((String)field.getName(), (String)(part1 == null ? null : this.toInternal(part1)), (String)(part2 == null ? null : this.toInternal(part2)), (boolean)minInclusive, (boolean)maxInclusive));
        }
        TermRangeQuery rangeQuery = TermRangeQuery.newStringRange((String)field.getName(), (String)(part1 == null ? null : this.toInternal(part1)), (String)(part2 == null ? null : this.toInternal(part2)), (boolean)minInclusive, (boolean)maxInclusive);
        rangeQuery.setRewriteMethod(this.getRewriteMethod(parser, field));
        return rangeQuery;
    }

    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        BytesRef br = new BytesRef();
        this.readableToIndexed(externalVal, br);
        if (field.hasDocValues() && !field.indexed()) {
            return this.getRangeQuery(parser, field, externalVal, externalVal, true, true);
        }
        return new TermQuery(new Term(field.getName(), br));
    }

    public MultiTermQuery.RewriteMethod getRewriteMethod(QParser parser, SchemaField field) {
        if (!field.indexed() && field.hasDocValues()) {
            return field.multiValued() ? new DocTermOrdsRewriteMethod() : new FieldCacheRewriteMethod();
        }
        return MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
    }

    public void checkSchemaField(SchemaField field) {
        if (field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field type " + this + " does not support doc values");
        }
    }

    public SimpleOrderedMap<Object> getNamedPropertyValues(boolean showDefaults) {
        String analyzerProperty;
        SimpleOrderedMap namedPropertyValues = new SimpleOrderedMap();
        namedPropertyValues.add(TYPE_NAME, (Object)this.getTypeName());
        namedPropertyValues.add(CLASS_NAME, (Object)this.getClassArg());
        if (showDefaults) {
            Map<String, String> fieldTypeArgs = this.getNonFieldPropertyArgs();
            if (null != fieldTypeArgs) {
                for (String key : fieldTypeArgs.keySet()) {
                    if (CLASS_NAME.equals(key) || TYPE_NAME.equals(key)) continue;
                    namedPropertyValues.add(key, (Object)fieldTypeArgs.get(key));
                }
            }
            if (this instanceof TextField) {
                namedPropertyValues.add(AUTO_GENERATE_PHRASE_QUERIES, (Object)((TextField)this).getAutoGeneratePhraseQueries());
            }
            namedPropertyValues.add(FieldType.getPropertyName(1), (Object)this.hasProperty(1));
            namedPropertyValues.add(FieldType.getPropertyName(4), (Object)this.hasProperty(4));
            namedPropertyValues.add(FieldType.getPropertyName(32768), (Object)this.hasProperty(32768));
            namedPropertyValues.add(FieldType.getPropertyName(64), (Object)this.hasProperty(64));
            namedPropertyValues.add(FieldType.getPropertyName(128), (Object)this.hasProperty(128));
            namedPropertyValues.add(FieldType.getPropertyName(256), (Object)this.hasProperty(256));
            namedPropertyValues.add(FieldType.getPropertyName(16), (Object)this.hasProperty(16));
            namedPropertyValues.add(FieldType.getPropertyName(32), (Object)this.hasProperty(32));
            namedPropertyValues.add(FieldType.getPropertyName(8192), (Object)this.hasProperty(8192));
            namedPropertyValues.add(FieldType.getPropertyName(16384), (Object)this.hasProperty(16384));
            namedPropertyValues.add(FieldType.getPropertyName(512), (Object)this.hasProperty(512));
            if (this.hasProperty(1024)) {
                namedPropertyValues.add(FieldType.getPropertyName(1024), (Object)true);
            } else if (this.hasProperty(2048)) {
                namedPropertyValues.add(FieldType.getPropertyName(2048), (Object)true);
            }
            namedPropertyValues.add(FieldType.getPropertyName(2), (Object)this.isTokenized());
        } else {
            HashSet<String> fieldProperties = new HashSet<String>();
            for (String propertyName : FieldProperties.propertyNames) {
                fieldProperties.add(propertyName);
            }
            for (String key : this.args.keySet()) {
                if (fieldProperties.contains(key)) {
                    namedPropertyValues.add(key, (Object)StrUtils.parseBool((String)this.args.get(key)));
                    continue;
                }
                if (CLASS_NAME.equals(key) || TYPE_NAME.equals(key)) continue;
                namedPropertyValues.add(key, (Object)this.args.get(key));
            }
        }
        if (this.isExplicitAnalyzer()) {
            analyzerProperty = this.isExplicitQueryAnalyzer() ? INDEX_ANALYZER : ANALYZER;
            namedPropertyValues.add(analyzerProperty, FieldType.getAnalyzerProperties(this.getAnalyzer()));
        }
        if (this.isExplicitQueryAnalyzer()) {
            analyzerProperty = this.isExplicitAnalyzer() ? QUERY_ANALYZER : ANALYZER;
            namedPropertyValues.add(analyzerProperty, FieldType.getAnalyzerProperties(this.getQueryAnalyzer()));
        }
        if (this instanceof TextField && ((TextField)this).isExplicitMultiTermAnalyzer()) {
            namedPropertyValues.add(MULTI_TERM_ANALYZER, FieldType.getAnalyzerProperties(((TextField)this).getMultiTermAnalyzer()));
        }
        if (null != this.getSimilarityFactory()) {
            namedPropertyValues.add(SIMILARITY, this.getSimilarityFactory().getNamedPropertyValues());
        }
        if (null != this.getPostingsFormat()) {
            namedPropertyValues.add(POSTINGS_FORMAT, (Object)this.getPostingsFormat());
        }
        if (null != this.getDocValuesFormat()) {
            namedPropertyValues.add(DOC_VALUES_FORMAT, (Object)this.getDocValuesFormat());
        }
        return namedPropertyValues;
    }

    protected Map<String, String> getNonFieldPropertyArgs() {
        HashMap<String, String> initArgs = new HashMap<String, String>(this.args);
        for (String prop : FieldProperties.propertyNames) {
            initArgs.remove(prop);
        }
        return initArgs;
    }

    protected static SimpleOrderedMap<Object> getAnalyzerProperties(Analyzer analyzer) {
        SimpleOrderedMap analyzerProps = new SimpleOrderedMap();
        if (analyzer instanceof TokenizerChain) {
            Map factoryArgs;
            TokenizerChain tokenizerChain = (TokenizerChain)analyzer;
            CharFilterFactory[] charFilterFactories = tokenizerChain.getCharFilterFactories();
            if (null != charFilterFactories && charFilterFactories.length > 0) {
                ArrayList<SimpleOrderedMap> charFilterProps = new ArrayList<SimpleOrderedMap>();
                for (CharFilterFactory charFilterFactory : charFilterFactories) {
                    SimpleOrderedMap props = new SimpleOrderedMap();
                    props.add(CLASS_NAME, (Object)charFilterFactory.getClassArg());
                    factoryArgs = charFilterFactory.getOriginalArgs();
                    if (null != factoryArgs) {
                        for (String key : factoryArgs.keySet()) {
                            if (CLASS_NAME.equals(key)) continue;
                            if ("luceneMatchVersion".equals(key)) {
                                if (!charFilterFactory.isExplicitLuceneMatchVersion()) continue;
                                props.add(key, factoryArgs.get(key));
                                continue;
                            }
                            props.add(key, factoryArgs.get(key));
                        }
                    }
                    charFilterProps.add(props);
                }
                analyzerProps.add(CHAR_FILTERS, charFilterProps);
            }
            SimpleOrderedMap tokenizerProps = new SimpleOrderedMap();
            TokenizerFactory tokenizerFactory = tokenizerChain.getTokenizerFactory();
            tokenizerProps.add(CLASS_NAME, (Object)tokenizerFactory.getClassArg());
            factoryArgs = tokenizerFactory.getOriginalArgs();
            if (null != factoryArgs) {
                for (String key : factoryArgs.keySet()) {
                    if (CLASS_NAME.equals(key)) continue;
                    if ("luceneMatchVersion".equals(key)) {
                        if (!tokenizerFactory.isExplicitLuceneMatchVersion()) continue;
                        tokenizerProps.add(key, factoryArgs.get(key));
                        continue;
                    }
                    tokenizerProps.add(key, factoryArgs.get(key));
                }
            }
            analyzerProps.add(TOKENIZER, (Object)tokenizerProps);
            TokenFilterFactory[] filterFactories = tokenizerChain.getTokenFilterFactories();
            if (null != filterFactories && filterFactories.length > 0) {
                ArrayList<SimpleOrderedMap> filterProps = new ArrayList<SimpleOrderedMap>();
                for (TokenFilterFactory filterFactory : filterFactories) {
                    SimpleOrderedMap props = new SimpleOrderedMap();
                    props.add(CLASS_NAME, (Object)filterFactory.getClassArg());
                    factoryArgs = filterFactory.getOriginalArgs();
                    if (null != factoryArgs) {
                        for (String key : factoryArgs.keySet()) {
                            if (CLASS_NAME.equals(key)) continue;
                            if ("luceneMatchVersion".equals(key)) {
                                if (!filterFactory.isExplicitLuceneMatchVersion()) continue;
                                props.add(key, factoryArgs.get(key));
                                continue;
                            }
                            props.add(key, factoryArgs.get(key));
                        }
                    }
                    filterProps.add(props);
                }
                analyzerProps.add(FILTERS, filterProps);
            }
        } else {
            analyzerProps.add(CLASS_NAME, (Object)analyzer.getClass().getName());
        }
        return analyzerProps;
    }

    protected final class DefaultAnalyzer
    extends SolrAnalyzer {
        final int maxChars;

        DefaultAnalyzer(int maxChars) {
            this.maxChars = maxChars;
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            Tokenizer ts = new Tokenizer(reader){
                final char[] cbuf;
                final CharTermAttribute termAtt;
                final OffsetAttribute offsetAtt;
                {
                    this.cbuf = new char[DefaultAnalyzer.this.maxChars];
                    this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                    this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
                }

                public boolean incrementToken() throws IOException {
                    this.clearAttributes();
                    int n = this.input.read(this.cbuf, 0, DefaultAnalyzer.this.maxChars);
                    if (n <= 0) {
                        return false;
                    }
                    String s = FieldType.this.toInternal(new String(this.cbuf, 0, n));
                    this.termAtt.setEmpty().append(s);
                    this.offsetAtt.setOffset(this.correctOffset(0), this.correctOffset(n));
                    return true;
                }
            };
            return new Analyzer.TokenStreamComponents(ts);
        }
    }
}

