/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.rest.schema.BaseSchemaResource;
import org.apache.solr.schema.SchemaField;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldCollectionResource
extends BaseFieldResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(FieldCollectionResource.class);
    private boolean includeDynamic;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.includeDynamic = this.getSolrRequest().getParams().getBool("includeDynamic", false);
        }
    }

    @Override
    public Representation get() {
        try {
            ArrayList<SimpleOrderedMap<Object>> props = new ArrayList<SimpleOrderedMap<Object>>();
            if (null == this.getRequestedFields()) {
                TreeSet<String> fieldNames = new TreeSet<String>(this.getSchema().getFields().keySet());
                for (String fieldName : fieldNames) {
                    props.add(this.getFieldProperties(this.getSchema().getFields().get(fieldName)));
                }
            } else {
                if (0 == this.getRequestedFields().size()) {
                    String message = "Empty fl parameter value";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                for (String fieldName : this.getRequestedFields()) {
                    SchemaField field = this.includeDynamic ? this.getSchema().getFieldOrNull(fieldName) : this.getSchema().getFields().get(fieldName);
                    if (null == field) {
                        log.info("Requested field '" + fieldName + "' not found.");
                        continue;
                    }
                    props.add(this.getFieldProperties(field));
                }
            }
            this.getSolrResponse().add("fields", props);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSchemaResource.SolrOutputRepresentation();
    }
}

