/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.stats;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.util.stats.Clock;
import org.apache.solr.util.stats.EWMA;

public class Meter {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final AtomicLong count = new AtomicLong();
    private final long startTime;
    private final AtomicLong lastTick;
    private final TimeUnit rateUnit;
    private final String eventType;
    private final Clock clock;

    Meter(String eventType, TimeUnit rateUnit, Clock clock) {
        this.rateUnit = rateUnit;
        this.eventType = eventType;
        this.clock = clock;
        this.startTime = this.clock.getTick();
        this.lastTick = new AtomicLong(this.startTime);
    }

    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    public String getEventType() {
        return this.eventType;
    }

    void tick() {
        this.m1Rate.tick();
        this.m5Rate.tick();
        this.m15Rate.tick();
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.tickIfNecessary();
        this.count.addAndGet(n);
        this.m1Rate.update(n);
        this.m5Rate.update(n);
        this.m15Rate.update(n);
    }

    private void tickIfNecessary() {
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newTick)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.tick();
            }
        }
    }

    public long getCount() {
        return this.count.get();
    }

    public double getFifteenMinuteRate() {
        this.tickIfNecessary();
        return this.m15Rate.getRate(this.rateUnit);
    }

    public double getFiveMinuteRate() {
        this.tickIfNecessary();
        return this.m5Rate.getRate(this.rateUnit);
    }

    public double getMeanRate() {
        if (this.getCount() == 0L) {
            return 0.0;
        }
        long elapsed = this.clock.getTick() - this.startTime;
        return this.convertNsRate((double)this.getCount() / (double)elapsed);
    }

    public double getOneMinuteRate() {
        this.tickIfNecessary();
        return this.m1Rate.getRate(this.rateUnit);
    }

    private double convertNsRate(double ratePerNs) {
        return ratePerNs * (double)this.rateUnit.toNanos(1L);
    }
}

