/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.net.URL;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.FieldCacheSanityChecker;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;

public class SolrFieldCacheMBean
implements SolrInfoMBean {
    protected FieldCacheSanityChecker checker = new FieldCacheSanityChecker();

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "Provides introspection of the Lucene FieldCache, this is **NOT** a cache that is managed by Solr.";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CACHE;
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_2/solr/core/src/java/org/apache/solr/search/SolrFieldCacheMBean.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap stats = new SimpleOrderedMap();
        FieldCache.CacheEntry[] entries = FieldCache.DEFAULT.getCacheEntries();
        stats.add("entries_count", (Object)entries.length);
        for (int i = 0; i < entries.length; ++i) {
            FieldCache.CacheEntry e = entries[i];
            stats.add("entry#" + i, (Object)e.toString());
        }
        FieldCacheSanityChecker.Insanity[] insanity = this.checker.check(entries);
        stats.add("insanity_count", (Object)insanity.length);
        for (int i = 0; i < insanity.length; ++i) {
            stats.add("insanity#" + i, (Object)insanity[i].toString());
        }
        return stats;
    }
}

