/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseFieldResource;
import org.apache.solr.rest.BaseSchemaResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.IndexSchema;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFieldCollectionResource
extends BaseFieldResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(CopyFieldCollectionResource.class);
    private static final String SOURCE = "source";
    private static final String DESTINATION = "dest";
    private static final String SOURCE_FIELD_LIST = "source.fl";
    private static final String DESTINATION_FIELD_LIST = "dest.fl";
    private static final String MAX_CHARS = "maxChars";
    private static final String SOURCE_DYNAMIC_BASE = "sourceDynamicBase";
    private static final String DESTINATION_DYNAMIC_BASE = "destDynamicBase";
    private static final String SOURCE_EXPLICIT_FIELDS = "sourceExplicitFields";
    private Set<String> requestedSourceFields;
    private Set<String> requestedDestinationFields;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            String[] fields;
            String destinationFieldListParam;
            String[] fields2;
            String sourceFieldListParam = this.getSolrRequest().getParams().get(SOURCE_FIELD_LIST);
            if (null != sourceFieldListParam && (fields2 = sourceFieldListParam.trim().split("[,\\s]+")).length > 0) {
                this.requestedSourceFields = new HashSet<String>(Arrays.asList(fields2));
                this.requestedSourceFields.remove("");
            }
            if (null != (destinationFieldListParam = this.getSolrRequest().getParams().get(DESTINATION_FIELD_LIST)) && (fields = destinationFieldListParam.trim().split("[,\\s]+")).length > 0) {
                this.requestedDestinationFields = new HashSet<String>(Arrays.asList(fields));
                this.requestedDestinationFields.remove("");
            }
        }
    }

    @Override
    public Representation get() {
        try {
            String destination;
            String source;
            ArrayList<SimpleOrderedMap> props = new ArrayList<SimpleOrderedMap>();
            TreeMap<String, List<CopyField>> sortedCopyFields = new TreeMap<String, List<CopyField>>(this.getSchema().getCopyFieldsMap());
            for (List copyFields : sortedCopyFields.values()) {
                Collections.sort(copyFields, new Comparator<CopyField>(){

                    @Override
                    public int compare(CopyField cf1, CopyField cf2) {
                        return cf1.getDestination().getName().compareTo(cf2.getDestination().getName());
                    }
                });
                for (CopyField copyField : copyFields) {
                    source = copyField.getSource().getName();
                    destination = copyField.getDestination().getName();
                    if (null != this.requestedSourceFields && !this.requestedSourceFields.contains(source) || null != this.requestedDestinationFields && !this.requestedDestinationFields.contains(destination)) continue;
                    SimpleOrderedMap copyFieldProps = new SimpleOrderedMap();
                    copyFieldProps.add(SOURCE, (Object)source);
                    copyFieldProps.add(DESTINATION, (Object)destination);
                    if (0 != copyField.getMaxChars()) {
                        copyFieldProps.add(MAX_CHARS, (Object)copyField.getMaxChars());
                    }
                    props.add(copyFieldProps);
                }
            }
            for (IndexSchema.DynamicCopy dynamicCopy : this.getSchema().getDynamicCopyFields()) {
                source = dynamicCopy.getRegex();
                destination = dynamicCopy.getDestFieldName();
                if (null != this.requestedSourceFields && !this.requestedSourceFields.contains(source) || null != this.requestedDestinationFields && !this.requestedDestinationFields.contains(destination)) continue;
                SimpleOrderedMap dynamicCopyProps = new SimpleOrderedMap();
                dynamicCopyProps.add(SOURCE, (Object)dynamicCopy.getRegex());
                IndexSchema.DynamicField sourceDynamicBase = dynamicCopy.getSourceDynamicBase();
                if (null != sourceDynamicBase) {
                    dynamicCopyProps.add(SOURCE_DYNAMIC_BASE, (Object)sourceDynamicBase.getRegex());
                } else if (source.contains("*")) {
                    ArrayList<String> sourceExplicitFields = new ArrayList<String>();
                    Pattern pattern = Pattern.compile(source.replace("*", ".*"));
                    for (String field : this.getSchema().getFields().keySet()) {
                        if (!pattern.matcher(field).matches()) continue;
                        sourceExplicitFields.add(field);
                    }
                    if (sourceExplicitFields.size() > 0) {
                        Collections.sort(sourceExplicitFields);
                        dynamicCopyProps.add(SOURCE_EXPLICIT_FIELDS, sourceExplicitFields);
                    }
                }
                dynamicCopyProps.add(DESTINATION, (Object)dynamicCopy.getDestFieldName());
                IndexSchema.DynamicField destDynamicBase = dynamicCopy.getDestDynamicBase();
                if (null != destDynamicBase) {
                    dynamicCopyProps.add(DESTINATION_DYNAMIC_BASE, (Object)destDynamicBase.getRegex());
                }
                if (0 != dynamicCopy.getMaxChars()) {
                    dynamicCopyProps.add(MAX_CHARS, (Object)dynamicCopy.getMaxChars());
                }
                props.add(dynamicCopyProps);
            }
            this.getSolrResponse().add("copyfields", props);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSchemaResource.SolrOutputRepresentation();
    }
}

