/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryFactory
implements NamedListInitializedPlugin,
Closeable {
    public static final IOContext IOCONTEXT_NO_CACHE = new IOContext(new FlushInfo(10000000, 100000000000L));
    private static final Logger log = LoggerFactory.getLogger((String)DirectoryFactory.class.getName());

    public abstract void doneWithDirectory(Directory var1) throws IOException;

    public abstract void addCloseListener(Directory var1, CachingDirectoryFactory.CloseListener var2);

    @Override
    public abstract void close() throws IOException;

    protected abstract Directory create(String var1, DirContext var2) throws IOException;

    public abstract boolean exists(String var1) throws IOException;

    public abstract void remove(Directory var1) throws IOException;

    public abstract void remove(Directory var1, boolean var2) throws IOException;

    public abstract void remove(String var1, boolean var2) throws IOException;

    public abstract void remove(String var1) throws IOException;

    public void move(Directory fromDir, Directory toDir, String fileName, IOContext ioContext) throws IOException {
        fromDir.copy(toDir, fileName, fileName, ioContext);
        fromDir.deleteFile(fileName);
    }

    public abstract Directory get(String var1, DirContext var2, String var3) throws IOException;

    public abstract Directory get(String var1, DirContext var2, String var3, boolean var4) throws IOException;

    public abstract void incRef(Directory var1);

    public abstract boolean isPersistent();

    public abstract void release(Directory var1) throws IOException;

    public String normalize(String path) throws IOException {
        return path;
    }

    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    public static long sizeOfDirectory(Directory directory) throws IOException {
        String[] files = directory.listAll();
        long size = 0L;
        for (String file : files) {
            if ((size += DirectoryFactory.sizeOf(directory, file)) < 0L) break;
        }
        return size;
    }

    public static long sizeOf(Directory directory, String file) throws IOException {
        if (!directory.fileExists(file)) {
            return 0L;
        }
        return directory.fileLength(file);
    }

    public static boolean empty(Directory dir) {
        boolean isSuccess = true;
        try {
            String[] contents = dir.listAll();
            if (contents != null) {
                for (String file : contents) {
                    dir.deleteFile(file);
                }
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)"Error deleting files from Directory", (Throwable)e);
            isSuccess = false;
        }
        return isSuccess;
    }

    public static enum DirContext {
        DEFAULT,
        META_DATA;

    }
}

