/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.WrappedQuery;

public abstract class QParser {
    protected String qstr;
    protected SolrParams params;
    protected SolrParams localParams;
    protected SolrQueryRequest req;
    protected int recurseCount;
    protected Query query;
    protected String stringIncludingLocalParams;
    protected boolean valFollowedParams;
    protected int localParamsEnd;

    public QParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        String tagStr;
        this.qstr = qstr;
        this.localParams = localParams;
        if (localParams != null && (tagStr = localParams.get("tag")) != null) {
            Map<Object, Object> context = req.getContext();
            HashMap<Object, Collection<Object>> tagMap = (HashMap<Object, Collection<Object>>)req.getContext().get("tags");
            if (tagMap == null) {
                tagMap = new HashMap<Object, Collection<Object>>();
                context.put("tags", tagMap);
            }
            if (tagStr.indexOf(44) >= 0) {
                List tags = StrUtils.splitSmart((String)tagStr, (char)',');
                for (String tag : tags) {
                    QParser.addTag(tagMap, tag, this);
                }
            } else {
                QParser.addTag(tagMap, tagStr, this);
            }
        }
        this.params = params;
        this.req = req;
    }

    private static void addTag(Map<Object, Collection<Object>> tagMap, Object key, Object val) {
        Collection<Object> lst = tagMap.get(key);
        if (lst == null) {
            lst = new ArrayList<Object>(2);
            tagMap.put(key, lst);
        }
        lst.add(val);
    }

    public abstract Query parse() throws SyntaxError;

    public SolrParams getLocalParams() {
        return this.localParams;
    }

    public void setLocalParams(SolrParams localParams) {
        this.localParams = localParams;
    }

    public SolrParams getParams() {
        return this.params;
    }

    public void setParams(SolrParams params) {
        this.params = params;
    }

    public SolrQueryRequest getReq() {
        return this.req;
    }

    public void setReq(SolrQueryRequest req) {
        this.req = req;
    }

    public String getString() {
        return this.qstr;
    }

    public void setString(String s) {
        this.qstr = s;
    }

    public Query getQuery() throws SyntaxError {
        if (this.query == null) {
            this.query = this.parse();
            if (this.localParams != null) {
                int cost;
                String cacheStr = this.localParams.get("cache");
                if (cacheStr != null) {
                    if (CommonParams.FALSE.equals(cacheStr)) {
                        this.extendedQuery().setCache(false);
                    } else if (CommonParams.TRUE.equals(cacheStr)) {
                        this.extendedQuery().setCache(true);
                    } else if ("sep".equals(cacheStr)) {
                        this.extendedQuery().setCacheSep(true);
                    }
                }
                if ((cost = this.localParams.getInt("cost", Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                    this.extendedQuery().setCost(cost);
                }
            }
        }
        return this.query;
    }

    private ExtendedQuery extendedQuery() {
        if (this.query instanceof ExtendedQuery) {
            return (ExtendedQuery)this.query;
        }
        WrappedQuery wq = new WrappedQuery(this.query);
        this.query = wq;
        return wq;
    }

    private void checkRecurse() throws SyntaxError {
        if (this.recurseCount++ >= 100) {
            throw new SyntaxError("Infinite Recursion detected parsing query '" + this.qstr + "'");
        }
    }

    public String getParam(String name) {
        String val;
        if (this.localParams != null && (val = this.localParams.get(name)) != null) {
            return val;
        }
        return this.params.get(name);
    }

    public QParser subQuery(String q, String defaultType) throws SyntaxError {
        this.checkRecurse();
        if (defaultType == null && this.localParams != null) {
            defaultType = this.localParams.get("defType");
        }
        QParser nestedParser = QParser.getParser(q, defaultType, this.getReq());
        nestedParser.recurseCount = this.recurseCount--;
        return nestedParser;
    }

    public ScoreDoc getPaging() throws SyntaxError {
        return null;
    }

    public SortSpec getSort(boolean useGlobalParams) throws SyntaxError {
        this.getQuery();
        String sortStr = null;
        String startS = null;
        String rowsS = null;
        if (this.localParams != null) {
            sortStr = this.localParams.get("sort");
            startS = this.localParams.get("start");
            rowsS = this.localParams.get("rows");
            if (sortStr != null || startS != null || rowsS != null) {
                useGlobalParams = false;
            }
        }
        if (useGlobalParams) {
            if (sortStr == null) {
                sortStr = this.params.get("sort");
            }
            if (startS == null) {
                startS = this.params.get("start");
            }
            if (rowsS == null) {
                rowsS = this.params.get("rows");
            }
        }
        int start = startS != null ? Integer.parseInt(startS) : 0;
        int rows = rowsS != null ? Integer.parseInt(rowsS) : 10;
        Sort sort = null;
        if (sortStr != null) {
            sort = QueryParsing.parseSort(sortStr, this.req);
        }
        return new SortSpec(sort, start, rows);
    }

    public String[] getDefaultHighlightFields() {
        return new String[0];
    }

    public Query getHighlightQuery() throws SyntaxError {
        Query query = this.getQuery();
        return query instanceof WrappedQuery ? ((WrappedQuery)query).getWrappedQuery() : query;
    }

    public void addDebugInfo(NamedList<Object> debugInfo) {
        debugInfo.add("QParser", (Object)this.getClass().getSimpleName());
    }

    public static QParser getParser(String qstr, String defaultParser, SolrQueryRequest req) throws SyntaxError {
        String parserName;
        String stringIncludingLocalParams = qstr;
        MapSolrParams localParams = null;
        SolrParams globalParams = req.getParams();
        boolean valFollowedParams = true;
        int localParamsEnd = -1;
        if (qstr != null && qstr.startsWith("{!")) {
            HashMap<String, String> localMap = new HashMap<String, String>();
            localParamsEnd = QueryParsing.parseLocalParams(qstr, 0, localMap, globalParams);
            String val = (String)localMap.get("v");
            if (val != null) {
                valFollowedParams = false;
            } else {
                valFollowedParams = true;
                val = qstr.substring(localParamsEnd);
                localMap.put("v", val);
            }
            localParams = new MapSolrParams(localMap);
        }
        if (localParams == null) {
            parserName = defaultParser;
        } else {
            parserName = localParams.get("type", defaultParser);
            qstr = localParams.get("v");
        }
        parserName = parserName == null ? QParserPlugin.DEFAULT_QTYPE : parserName;
        QParserPlugin qplug = req.getCore().getQueryPlugin(parserName);
        QParser parser = qplug.createParser(qstr, (SolrParams)localParams, req.getParams(), req);
        parser.stringIncludingLocalParams = stringIncludingLocalParams;
        parser.valFollowedParams = valFollowedParams;
        parser.localParamsEnd = localParamsEnd;
        return parser;
    }
}

