/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.collation.CollationKeyAnalyzer;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public class CollationField
extends FieldType {
    private Analyzer analyzer;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.properties |= 2;
        this.setup(schema.getResourceLoader(), args);
        super.init(schema, args);
    }

    private void setup(ResourceLoader loader, Map<String, String> args) {
        String custom = args.remove("custom");
        String language = args.remove("language");
        String country = args.remove("country");
        String variant = args.remove("variant");
        String strength = args.remove("strength");
        String decomposition = args.remove("decomposition");
        if (custom == null && language == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Either custom or language is required.");
        }
        if (custom != null && (language != null || country != null || variant != null)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot specify both language and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        Collator collator = language != null ? this.createFromLocale(language, country, variant) : this.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("identical")) {
                collator.setStrength(3);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                collator.setDecomposition(0);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                collator.setDecomposition(1);
            } else if (decomposition.equalsIgnoreCase("full")) {
                collator.setDecomposition(2);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid decomposition: " + decomposition);
            }
        }
        this.analyzer = new CollationKeyAnalyzer(Version.LUCENE_40, collator);
    }

    private Collator createFromLocale(String language, String country, String variant) {
        if (language != null && country == null && variant != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "To specify variant, country is required");
        }
        Locale locale = language != null && country != null && variant != null ? new Locale(language, country, variant) : (language != null && country != null ? new Locale(language, country) : new Locale(language));
        return Collator.getInstance(locale);
    }

    private Collator createFromRules(String fileName, ResourceLoader loader) {
        InputStream input = null;
        try {
            input = loader.openResource(fileName);
            String rules = IOUtils.toString((InputStream)input, (String)"UTF-8");
            RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(rules);
            return ruleBasedCollator;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return this.analyzer;
    }

    private BytesRef analyzeRangePart(String field, String part) {
        TokenStream source;
        try {
            source = this.analyzer.tokenStream(field, (Reader)new StringReader(part));
            source.reset();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize TokenStream to analyze range part: " + part, e);
        }
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
        BytesRef bytes = termAtt.getBytesRef();
        try {
            if (!source.incrementToken()) {
                throw new IllegalArgumentException("analyzer returned no terms for range part: " + part);
            }
            termAtt.fillBytesRef();
            assert (!source.incrementToken());
        }
        catch (IOException e) {
            throw new RuntimeException("error analyzing range part: " + part, e);
        }
        try {
            source.end();
            source.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to end & close TokenStream after analyzing range part: " + part, e);
        }
        return BytesRef.deepCopyOf((BytesRef)bytes);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        String f = field.getName();
        BytesRef low = part1 == null ? null : this.analyzeRangePart(f, part1);
        BytesRef high = part2 == null ? null : this.analyzeRangePart(f, part2);
        return new TermRangeQuery(field.getName(), low, high, minInclusive, maxInclusive);
    }
}

