/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseFieldResource;
import org.apache.solr.rest.BaseSchemaResource;
import org.apache.solr.rest.GETable;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldCollectionResource
extends BaseFieldResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(FieldCollectionResource.class);

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
    }

    @Override
    public Representation get() {
        try {
            HashSet<String> fieldNames = new HashSet<String>(this.getSchema().getFields().keySet());
            ArrayList<Object> fieldCollectionProperties = new ArrayList<Object>(fieldNames.size());
            if (null == this.getRequestedFields()) {
                for (String string : fieldNames) {
                    fieldCollectionProperties.add(this.getFieldProperties(this.getSchema().getFieldOrNull(string)));
                }
            } else {
                if (0 == this.getRequestedFields().size()) {
                    String message = "Empty fl parameter value";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                for (String string : fieldNames) {
                    if (!this.getRequestedFields().containsKey(string)) continue;
                    this.getRequestedFields().put(string, this.getFieldProperties(this.getSchema().getFieldOrNull(string)));
                }
                for (SimpleOrderedMap simpleOrderedMap : this.getRequestedFields().values()) {
                    if (null == simpleOrderedMap) continue;
                    fieldCollectionProperties.add(simpleOrderedMap);
                }
            }
            this.getSolrResponse().add("fields", fieldCollectionProperties);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSchemaResource.SolrOutputRepresentation();
    }
}

