/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.util.ArrayList;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseFieldResource;
import org.apache.solr.rest.BaseSchemaResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.schema.SchemaField;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFieldCollectionResource
extends BaseFieldResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(DynamicFieldCollectionResource.class);
    private static final String INTERNAL_POLY_FIELD_PREFIX = "*___";

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
    }

    @Override
    public Representation get() {
        try {
            SchemaField[] dynamicFields = this.getSchema().getDynamicFieldPrototypes();
            ArrayList<SimpleOrderedMap<Object>> props = new ArrayList<SimpleOrderedMap<Object>>(dynamicFields.length);
            if (null != this.getRequestedFields()) {
                if (0 == this.getRequestedFields().size()) {
                    String message = "Empty fl parameter value";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                for (SchemaField prototype : dynamicFields) {
                    if (!this.getRequestedFields().containsKey(prototype.getName())) continue;
                    this.getRequestedFields().put(prototype.getName(), this.getFieldProperties(prototype));
                }
                for (Map.Entry<String, SimpleOrderedMap<Object>> requestedField : this.getRequestedFields().entrySet()) {
                    SimpleOrderedMap<Object> fieldProperties = requestedField.getValue();
                    if (null == fieldProperties) continue;
                    props.add(fieldProperties);
                }
            } else {
                for (SchemaField prototype : dynamicFields) {
                    if (prototype.getName().startsWith(INTERNAL_POLY_FIELD_PREFIX)) continue;
                    props.add(this.getFieldProperties(prototype));
                }
            }
            this.getSolrResponse().add("dynamicfields", props);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSchemaResource.SolrOutputRepresentation();
    }
}

