/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.util.List;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseSchemaResource;
import org.apache.solr.schema.FieldType;
import org.restlet.resource.ResourceException;

abstract class BaseFieldTypeResource
extends BaseSchemaResource {
    private static final String FIELDS = "fields";
    private static final String DYNAMIC_FIELDS = "dynamicFields";
    private boolean showDefaults;

    protected BaseFieldTypeResource() {
    }

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        this.showDefaults = this.getSolrRequest().getParams().getBool("showDefaults", false);
    }

    protected SimpleOrderedMap<Object> getFieldTypeProperties(FieldType fieldType) {
        SimpleOrderedMap<Object> properties = fieldType.getNamedPropertyValues(this.showDefaults);
        properties.add(FIELDS, this.getFieldsWithFieldType(fieldType));
        properties.add(DYNAMIC_FIELDS, this.getDynamicFieldsWithFieldType(fieldType));
        return properties;
    }

    protected abstract List<String> getFieldsWithFieldType(FieldType var1);

    protected abstract List<String> getDynamicFieldsWithFieldType(FieldType var1);
}

