/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;
import org.apache.solr.util.NumberUtils;

@Deprecated
class SortableIntFieldSource
extends FieldCacheSource {
    protected int defVal;
    private static int hcode = SortableIntFieldSource.class.hashCode();

    public SortableIntFieldSource(String field) {
        this(field, 0);
    }

    public SortableIntFieldSource(String field, int defVal) {
        super(field);
        this.defVal = defVal;
    }

    public String description() {
        return "sint(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final int def = this.defVal;
        return new DocTermsIndexDocValues((ValueSource)this, readerContext, this.field){

            protected String toTerm(String readableValue) {
                return NumberUtils.int2sortableStr(readableValue);
            }

            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            public boolean exists(int doc) {
                return this.termsIndex.getOrd(doc) >= 0;
            }

            public int intVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                if (ord == -1) {
                    return def;
                }
                BytesRef spare = this.termsIndex.lookupOrd(ord);
                return NumberUtils.SortableStr2int(spare, 0, 3);
            }

            public long longVal(int doc) {
                return this.intVal(doc);
            }

            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            public String strVal(int doc) {
                return Integer.toString(this.intVal(doc));
            }

            public String toString(int doc) {
                return SortableIntFieldSource.this.description() + '=' + this.intVal(doc);
            }

            public Object objectVal(int doc) {
                return this.exists(doc) ? Integer.valueOf(this.intVal(doc)) : null;
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        int ord = termsIndex.getOrd(doc);
                        if (ord == -1) {
                            this.mval.value = def;
                            this.mval.exists = false;
                        } else {
                            BytesRef spare = termsIndex.lookupOrd(ord);
                            this.mval.value = NumberUtils.SortableStr2int(spare, 0, 3);
                            this.mval.exists = true;
                        }
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof SortableIntFieldSource && super.equals(o) && this.defVal == ((SortableIntFieldSource)((Object)o)).defVal;
    }

    public int hashCode() {
        return hcode + super.hashCode() + this.defVal;
    }
}

