/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.cloud.CurrentCoreDescriptorProvider;
import org.apache.solr.cloud.SolrZkServer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkContainer {
    protected static Logger log = LoggerFactory.getLogger(ZkContainer.class);
    public static final String DEFAULT_HOST_CONTEXT = "solr";
    public static final String DEFAULT_HOST_PORT = "8983";
    protected ZkController zkController;
    private SolrZkServer zkServer;
    private ExecutorService coreZkRegister = Executors.newFixedThreadPool(Integer.MAX_VALUE, new DefaultSolrThreadFactory("coreZkRegister"));

    public void initZooKeeper(CoreContainer cc, String solrHome, ConfigSolr config) {
        if (config.getCoreLoadThreadCount() <= 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCloud requires a value of at least 2 in solr.xml for coreLoadThreads");
        }
        this.initZooKeeper(cc, solrHome, config.getZkHost(), config.getZkClientTimeout(), config.getZkHostPort(), config.getZkHostContext(), config.getHost(), config.getLeaderVoteWait(), config.getLeaderConflictResolveWait(), config.getGenericCoreNodeNames());
    }

    public static boolean isZkMode() {
        String test = System.getProperty("zkHost");
        if (StringUtils.isBlank((String)test)) {
            test = System.getProperty("zkRun");
        }
        return StringUtils.isNotBlank((String)test);
    }

    public void initZooKeeper(final CoreContainer cc, String solrHome, String zkHost, int zkClientTimeout, String hostPort, String hostContext, String host, int leaderVoteWait, int leaderConflictResolveWait, boolean genericCoreNodeNames) {
        ZkController zkController = null;
        String zookeeperHost = zkHost == null ? System.getProperty("zkHost") : zkHost;
        String zkRun = System.getProperty("zkRun");
        if (zkRun == null && zookeeperHost == null) {
            return;
        }
        if (null == hostPort) {
            log.warn("Solr 'hostPort' has not be explicitly configured, using hardcoded default of 8983.  This default has been deprecated and will be removed in future versions of Solr, please configure this value explicitly");
            hostPort = DEFAULT_HOST_PORT;
        }
        if (null == hostContext) {
            log.warn("Solr 'hostContext' has not be explicitly configured, using hardcoded default of solr.  This default has been deprecated and will be removed in future versions of Solr, please configure this value explicitly");
            hostContext = DEFAULT_HOST_CONTEXT;
        }
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        if (zkRun != null) {
            String zkDataHome = System.getProperty("zkServerDataDir", solrHome + "zoo_data");
            String zkConfHome = System.getProperty("zkServerConfDir", solrHome);
            this.zkServer = new SolrZkServer(zkRun, zookeeperHost, zkDataHome, zkConfHome, hostPort);
            this.zkServer.parseConfig();
            this.zkServer.start();
            if (zookeeperHost == null) {
                zookeeperHost = this.zkServer.getClientString();
            }
        }
        int zkClientConnectTimeout = 30000;
        if (zookeeperHost != null) {
            try {
                if (zkRun != null && this.zkServer.getServers().size() > 1) {
                    zkClientConnectTimeout = 86400000;
                    log.info("Zookeeper client=" + zookeeperHost + "  Waiting for a quorum.");
                } else {
                    log.info("Zookeeper client=" + zookeeperHost);
                }
                String confDir = System.getProperty("bootstrap_confdir");
                boolean boostrapConf = Boolean.getBoolean("bootstrap_conf");
                if (!ZkController.checkChrootPath(zookeeperHost, confDir != null || boostrapConf)) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A chroot was specified in ZkHost but the znode doesn't exist. ");
                }
                zkController = new ZkController(cc, zookeeperHost, zkClientTimeout, zkClientConnectTimeout, host, hostPort, hostContext, leaderVoteWait, leaderConflictResolveWait, genericCoreNodeNames, new CurrentCoreDescriptorProvider(){

                    @Override
                    public List<CoreDescriptor> getCurrentDescriptors() {
                        ArrayList<CoreDescriptor> descriptors = new ArrayList<CoreDescriptor>(cc.getCoreNames().size());
                        Collection<SolrCore> cores = cc.getCores();
                        for (SolrCore core : cores) {
                            descriptors.add(core.getCoreDescriptor());
                        }
                        return descriptors;
                    }
                });
                if (zkRun != null && this.zkServer.getServers().size() > 1 && confDir == null && !boostrapConf) {
                    Thread.sleep(10000L);
                }
                if (confDir != null) {
                    File dir = new File(confDir);
                    if (!dir.isDirectory()) {
                        throw new IllegalArgumentException("bootstrap_confdir must be a directory of configuration files");
                    }
                    String confName = System.getProperty("collection.configName", "configuration1");
                    zkController.uploadConfigDir(dir, confName);
                }
                if (boostrapConf) {
                    ZkController.bootstrapConf(zkController.getZkClient(), cc, solrHome);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.error("Could not connect to ZooKeeper", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (KeeperException e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
        this.zkController = zkController;
    }

    public void registerInZk(final SolrCore core, boolean background) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ZkContainer.this.zkController.register(core.getName(), core.getCoreDescriptor());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
                catch (Exception e) {
                    try {
                        ZkContainer.this.zkController.publish(core.getCoreDescriptor(), "down");
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        log.error("", (Throwable)e1);
                    }
                    catch (Exception e1) {
                        log.error("", (Throwable)e1);
                    }
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
            }
        };
        if (this.zkController != null) {
            if (background) {
                this.coreZkRegister.execute(thread);
            } else {
                thread.run();
            }
        }
    }

    public ZkController getZkController() {
        return this.zkController;
    }

    public void publishCoresAsDown(List<SolrCore> cores) {
        for (SolrCore core : cores) {
            try {
                this.zkController.publish(core.getCoreDescriptor(), "down");
            }
            catch (KeeperException e) {
                CoreContainer.log.error("", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                CoreContainer.log.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.zkController != null) {
                this.zkController.close();
            }
        }
        finally {
            try {
                if (this.zkServer != null) {
                    this.zkServer.stop();
                }
            }
            finally {
                ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)this.coreZkRegister);
            }
        }
    }
}

