/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorePropertiesLocator
implements CoresLocator {
    public static final String PROPERTIES_FILENAME = "core.properties";
    private static final Logger logger = LoggerFactory.getLogger(CoresLocator.class);
    private final File rootDirectory;

    public CorePropertiesLocator(String coreDiscoveryRoot) {
        this.rootDirectory = new File(coreDiscoveryRoot);
        logger.info("Config-defined core root directory: {}", (Object)this.rootDirectory.getAbsolutePath());
    }

    @Override
    public void create(CoreContainer cc, CoreDescriptor ... coreDescriptors) {
        for (CoreDescriptor cd : coreDescriptors) {
            File propFile = new File(new File(cd.getInstanceDir()), PROPERTIES_FILENAME);
            if (propFile.exists()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not create a new core in " + cd.getInstanceDir() + "as another core is already defined there");
            }
            this.writePropertiesFile(cd, propFile);
        }
    }

    @Override
    public void persist(CoreContainer cc, CoreDescriptor ... coreDescriptors) {
        for (CoreDescriptor cd : coreDescriptors) {
            File propFile = new File(new File(cd.getInstanceDir()), PROPERTIES_FILENAME);
            this.writePropertiesFile(cd, propFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesFile(CoreDescriptor cd, File propfile) {
        Properties p = this.buildCoreProperties(cd);
        OutputStreamWriter os = null;
        try {
            propfile.getParentFile().mkdirs();
            os = new OutputStreamWriter((OutputStream)new FileOutputStream(propfile), StandardCharsets.UTF_8);
            p.store(os, "Written by CorePropertiesLocator");
            IOUtils.closeQuietly(os);
        }
        catch (IOException e) {
            logger.error("Couldn't persist core properties to {}: {}", (Object)propfile.getAbsolutePath(), (Object)e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    @Override
    public void delete(CoreContainer cc, CoreDescriptor ... coreDescriptors) {
        if (coreDescriptors == null) {
            return;
        }
        for (CoreDescriptor cd : coreDescriptors) {
            if (cd == null) continue;
            File instanceDir = new File(cd.getInstanceDir());
            File propertiesFile = new File(instanceDir, PROPERTIES_FILENAME);
            propertiesFile.renameTo(new File(instanceDir, "core.properties.unloaded"));
        }
    }

    @Override
    public void rename(CoreContainer cc, CoreDescriptor oldCD, CoreDescriptor newCD) {
        this.persist(cc, newCD);
    }

    @Override
    public void swap(CoreContainer cc, CoreDescriptor cd1, CoreDescriptor cd2) {
        this.persist(cc, cd1, cd2);
    }

    @Override
    public List<CoreDescriptor> discover(CoreContainer cc) {
        logger.info("Looking for core definitions underneath {}", (Object)this.rootDirectory.getAbsolutePath());
        ArrayList cds = Lists.newArrayList();
        this.discoverUnder(this.rootDirectory, cds, cc);
        logger.info("Found {} core definitions", (Object)cds.size());
        return cds;
    }

    private void discoverUnder(File root, List<CoreDescriptor> cds, CoreContainer cc) {
        if (!root.exists()) {
            return;
        }
        for (File child : root.listFiles()) {
            File propertiesFile = new File(child, PROPERTIES_FILENAME);
            if (propertiesFile.exists()) {
                CoreDescriptor cd = this.buildCoreDescriptor(propertiesFile, cc);
                logger.info("Found core {} in {}", (Object)cd.getName(), (Object)cd.getInstanceDir());
                cds.add(cd);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.discoverUnder(child, cds, cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor buildCoreDescriptor(File propertiesFile, CoreContainer cc) {
        CoreDescriptor coreDescriptor;
        FileInputStream fis = null;
        try {
            File instanceDir = propertiesFile.getParentFile();
            Properties coreProperties = new Properties();
            fis = new FileInputStream(propertiesFile);
            coreProperties.load(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            String name = CorePropertiesLocator.createName(coreProperties, instanceDir);
            coreDescriptor = new CoreDescriptor(cc, name, instanceDir.getAbsolutePath(), coreProperties);
        }
        catch (IOException e) {
            CoreDescriptor coreDescriptor2;
            try {
                logger.error("Couldn't load core descriptor from {}:{}", (Object)propertiesFile.getAbsolutePath(), (Object)e.toString());
                coreDescriptor2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
            return coreDescriptor2;
        }
        IOUtils.closeQuietly(fis);
        return coreDescriptor;
    }

    protected static String createName(Properties p, File instanceDir) {
        return p.getProperty("name", instanceDir.getName());
    }

    protected Properties buildCoreProperties(CoreDescriptor cd) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)cd.getPersistableStandardProperties());
        p.putAll((Map<?, ?>)cd.getPersistableUserProperties());
        p.remove("instanceDir");
        return p;
    }
}

