/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.handler.SnapPuller;
import org.apache.solr.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapShooter {
    private static final Logger LOG = LoggerFactory.getLogger((String)SnapShooter.class.getName());
    private String snapDir = null;
    private SolrCore solrCore;
    private SimpleFSLockFactory lockFactory;
    public static final String SNAP_DIR = "snapDir";
    public static final String DATE_FMT = "yyyyMMddHHmmssSSS";

    public SnapShooter(SolrCore core, String location) {
        this.solrCore = core;
        if (location == null) {
            this.snapDir = core.getDataDir();
        } else {
            File base = new File(core.getCoreDescriptor().getRawInstanceDir());
            this.snapDir = FileUtils.resolvePath(base, location).getAbsolutePath();
            File dir = new File(this.snapDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        this.lockFactory = new SimpleFSLockFactory(this.snapDir);
    }

    void createSnapAsync(IndexCommit indexCommit, ReplicationHandler replicationHandler) {
        this.createSnapAsync(indexCommit, Integer.MAX_VALUE, replicationHandler);
    }

    void createSnapAsync(final IndexCommit indexCommit, final int numberToKeep, final ReplicationHandler replicationHandler) {
        replicationHandler.core.getDeletionPolicy().saveCommitPoint(indexCommit.getGeneration());
        new Thread(){

            @Override
            public void run() {
                SnapShooter.this.createSnapshot(indexCommit, numberToKeep, replicationHandler);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSnapshot(IndexCommit indexCommit, int numberToKeep, ReplicationHandler replicationHandler) {
        LOG.info("Creating backup snapshot...");
        NamedList details = new NamedList();
        details.add("startTime", (Object)new Date().toString());
        File snapShotDir = null;
        String directoryName = null;
        Lock lock = null;
        try {
            if (numberToKeep < Integer.MAX_VALUE) {
                this.deleteOldBackups(numberToKeep);
            }
            SimpleDateFormat fmt = new SimpleDateFormat(DATE_FMT, Locale.ROOT);
            directoryName = "snapshot." + fmt.format(new Date());
            lock = this.lockFactory.makeLock(directoryName + ".lock");
            if (lock.isLocked()) {
                return;
            }
            snapShotDir = new File(this.snapDir, directoryName);
            if (!snapShotDir.mkdir()) {
                LOG.warn("Unable to create snapshot directory: " + snapShotDir.getAbsolutePath());
                return;
            }
            Collection files = indexCommit.getFileNames();
            FileCopier fileCopier = new FileCopier();
            Directory dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getNewIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.solrCore.getSolrConfig().indexConfig.lockType);
            try {
                fileCopier.copyFiles(dir, files, snapShotDir);
            }
            finally {
                this.solrCore.getDirectoryFactory().release(dir);
            }
            details.add("fileCount", (Object)files.size());
            details.add("status", (Object)"success");
            details.add("snapshotCompletedAt", (Object)new Date().toString());
        }
        catch (Exception e) {
            SnapPuller.delTree(snapShotDir);
            LOG.error("Exception while creating snapshot", (Throwable)e);
            details.add("snapShootException", (Object)e.getMessage());
        }
        finally {
            replicationHandler.core.getDeletionPolicy().releaseCommitPoint(indexCommit.getGeneration());
            replicationHandler.snapShootDetails = details;
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    LOG.error("Unable to release snapshoot lock: " + directoryName + ".lock");
                }
            }
        }
    }

    private void deleteOldBackups(int numberToKeep) {
        File[] files = new File(this.snapDir).listFiles();
        ArrayList<OldBackupDirectory> dirs = new ArrayList<OldBackupDirectory>();
        for (File f : files) {
            OldBackupDirectory obd = new OldBackupDirectory(f);
            if (obd.dir == null) continue;
            dirs.add(obd);
        }
        Collections.sort(dirs);
        int i = 1;
        for (OldBackupDirectory dir : dirs) {
            if (i++ <= numberToKeep - 1) continue;
            SnapPuller.delTree(dir.dir);
        }
    }

    private class FileCopier {
        private FileCopier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyFiles(Directory sourceDir, Collection<String> files, File destDir) throws IOException {
            if (destDir != null && !destDir.exists()) {
                destDir.mkdirs();
            }
            FSDirectory dir = FSDirectory.open((File)destDir);
            try {
                for (String indexFile : files) {
                    this.copyFile(sourceDir, indexFile, new File(destDir, indexFile), (Directory)dir);
                }
            }
            finally {
                dir.close();
            }
        }

        public void copyFile(Directory sourceDir, String indexFile, File destination, Directory destDir) throws IOException {
            if (destination.exists() && !destination.canWrite()) {
                String message = "Unable to open file " + destination + " for writing.";
                throw new IOException(message);
            }
            sourceDir.copy(destDir, indexFile, indexFile, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }
    }

    private class OldBackupDirectory
    implements Comparable<OldBackupDirectory> {
        File dir;
        Date timestamp;
        final Pattern dirNamePattern = Pattern.compile("^snapshot[.](.*)$");

        OldBackupDirectory(File dir) {
            Matcher m;
            if (dir.isDirectory() && (m = this.dirNamePattern.matcher(dir.getName())).find()) {
                try {
                    this.dir = dir;
                    this.timestamp = new SimpleDateFormat(SnapShooter.DATE_FMT, Locale.ROOT).parse(m.group(1));
                }
                catch (Exception e) {
                    this.dir = null;
                    this.timestamp = null;
                }
            }
        }

        @Override
        public int compareTo(OldBackupDirectory that) {
            return that.timestamp.compareTo(this.timestamp);
        }
    }
}

