/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;

public class ZkSolrResourceLoader
extends SolrResourceLoader {
    private final String collectionZkPath;
    private ZkController zkController;

    public ZkSolrResourceLoader(String instanceDir, String collection, ZkController zooKeeperController) {
        super(instanceDir);
        this.zkController = zooKeeperController;
        this.collectionZkPath = "/configs/" + collection;
    }

    public ZkSolrResourceLoader(String instanceDir, String collection, ClassLoader parent, Properties coreProperties, ZkController zooKeeperController) {
        super(instanceDir, parent, coreProperties);
        this.zkController = zooKeeperController;
        this.collectionZkPath = "/configs/" + collection;
    }

    @Override
    public InputStream openResource(String resource) throws IOException {
        InputStream is = null;
        String file = this.collectionZkPath + "/" + resource;
        try {
            if (this.zkController.pathExists(file)) {
                byte[] bytes = this.zkController.getZkClient().getData(this.collectionZkPath + "/" + resource, null, null, true);
                return new ByteArrayInputStream(bytes);
            }
        }
        catch (Exception e) {
            throw new IOException("Error opening " + file, e);
        }
        try {
            is = this.classLoader.getResourceAsStream(resource);
        }
        catch (Exception e) {
            throw new IOException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new IOException("Can't find resource '" + resource + "' in classpath or '" + this.collectionZkPath + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    @Override
    public String getConfigDir() {
        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "ZkSolrResourceLoader does not support getConfigDir() - likely, what you are trying to do is not supported in ZooKeeper mode");
    }

    @Override
    public String[] listConfigDir() {
        List list;
        try {
            list = this.zkController.getZkClient().getChildren(this.collectionZkPath, null, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return list.toArray(new String[0]);
    }

    public String getCollectionZkPath() {
        return this.collectionZkPath;
    }
}

