/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionProcessor
implements Runnable,
ClosableThread {
    public static final String NUM_SLICES = "numShards";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String DELETECOLLECTION = "deletecollection";
    public static final String CREATECOLLECTION = "createcollection";
    public static final String RELOADCOLLECTION = "reloadcollection";
    private static final String QUEUE_OPERATION = "operation";
    private static Logger log = LoggerFactory.getLogger(OverseerCollectionProcessor.class);
    private DistributedQueue workQueue;
    private String myId;
    private ShardHandler shardHandler;
    private String adminPath;
    private ZkStateReader zkStateReader;
    private boolean isClosed;

    public OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath) {
        this(zkStateReader, myId, shardHandler, adminPath, Overseer.getCollectionQueue(zkStateReader.getZkClient()));
    }

    protected OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath, DistributedQueue workQueue) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
        this.workQueue = workQueue;
    }

    @Override
    public void run() {
        log.info("Process current queue of collection messages");
        while (this.amILeader() && !this.isClosed) {
            try {
                byte[] head = this.workQueue.peek(true);
                ZkNodeProps message = ZkNodeProps.load((byte[])head);
                String operation = message.getStr(QUEUE_OPERATION);
                try {
                    boolean success = this.processMessage(message, operation);
                    if (!success) {
                        SolrException.log((Logger)log, (String)("Collection " + operation + " of " + message.getStr("name") + " failed"));
                    }
                }
                catch (Throwable t) {
                    SolrException.log((Logger)log, (String)("Collection " + operation + " of " + message.getStr("name") + " failed"), (Throwable)t);
                }
                this.workQueue.poll();
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.warn("Overseer cannot talk to ZK");
                    return;
                }
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public void close() {
        this.isClosed = true;
    }

    protected boolean amILeader() {
        try {
            ZkNodeProps props = ZkNodeProps.load((byte[])this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            if (this.myId.equals(props.getStr("id"))) {
                return true;
            }
        }
        catch (KeeperException e) {
            log.warn("", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
        return false;
    }

    protected boolean processMessage(ZkNodeProps message, String operation) {
        if (CREATECOLLECTION.equals(operation)) {
            return this.createCollection(this.zkStateReader.getClusterState(), message);
        }
        if (DELETECOLLECTION.equals(operation)) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteInstanceDir", true);
            return this.collectionCmd(this.zkStateReader.getClusterState(), message, params);
        }
        if (RELOADCOLLECTION.equals(operation)) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
            return this.collectionCmd(this.zkStateReader.getClusterState(), message, params);
        }
        return true;
    }

    private boolean createCollection(ClusterState clusterState, ZkNodeProps message) {
        String collectionName = message.getStr("name");
        if (clusterState.getCollections().contains(collectionName)) {
            SolrException.log((Logger)log, (String)("collection already exists: " + collectionName));
            return false;
        }
        try {
            ShardResponse srsp;
            int requestedShardsToCreate;
            int maxShardsAllowedToCreate;
            List createNodeList;
            int repFactor = this.msgStrToInt(message, REPLICATION_FACTOR, 1);
            int numSlices = this.msgStrToInt(message, NUM_SLICES, 0);
            int maxShardsPerNode = this.msgStrToInt(message, MAX_SHARDS_PER_NODE, 1);
            String createNodeSetStr = message.getStr(CREATE_NODE_SET);
            List list = createNodeList = createNodeSetStr == null ? null : StrUtils.splitSmart((String)createNodeSetStr, (String)",", (boolean)true);
            if (repFactor <= 0) {
                SolrException.log((Logger)log, (String)"replicationFactor must be > 0");
                return false;
            }
            if (numSlices < 0) {
                SolrException.log((Logger)log, (String)"numShards must be > 0");
                return false;
            }
            String configName = message.getStr("collection.configName");
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            if (createNodeList != null) {
                nodeList.retainAll(createNodeList);
            }
            Collections.shuffle(nodeList);
            if (nodeList.size() <= 0) {
                log.error("Cannot create collection " + collectionName + ". No live Solr-instaces" + (createNodeList != null ? " among Solr-instances specified in createNodeSet" : ""));
                return false;
            }
            if (repFactor > nodeList.size()) {
                log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live (" + nodeList.size() + "). Its unusual to run two replica of the same slice on the same Solr-instance.");
            }
            if ((maxShardsAllowedToCreate = maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * repFactor)) {
                log.error("Cannot create collection " + collectionName + ". Value of " + MAX_SHARDS_PER_NODE + " is " + maxShardsPerNode + ", and the number of live nodes is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + NUM_SLICES + " is " + numSlices + " and value of " + REPLICATION_FACTOR + " is " + repFactor + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
                return false;
            }
            for (int i = 1; i <= numSlices; ++i) {
                for (int j = 1; j <= repFactor; ++j) {
                    String nodeName = (String)nodeList.get((i - 1 + (j - 1)) % nodeList.size());
                    String sliceName = "shard" + i;
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                    params.set("name", new String[]{shardName});
                    params.set("collection.configName", new String[]{configName});
                    params.set("collection", new String[]{collectionName});
                    params.set("shard", new String[]{sliceName});
                    params.set(NUM_SLICES, numSlices);
                    ShardRequest sreq = new ShardRequest();
                    params.set("qt", new String[]{this.adminPath});
                    sreq.purpose = 1;
                    String replica = this.zkStateReader.getZkClient().getBaseUrlForNodeName(nodeName);
                    if (replica.startsWith("http://")) {
                        replica = replica.substring(7);
                    }
                    sreq.shards = new String[]{replica};
                    sreq.actualShards = sreq.shards;
                    sreq.params = params;
                    this.shardHandler.submit(sreq, replica, sreq.params);
                }
            }
            int failed = 0;
            do {
                Throwable e;
                if ((srsp = this.shardHandler.takeCompletedOrError()) == null || (e = srsp.getException()) == null) continue;
                ++failed;
                log.error("Error talking to shard: " + srsp.getShard(), e);
            } while (srsp != null);
            if (failed > 0) {
                return false;
            }
            log.info("Successfully created all shards for collection " + collectionName);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean collectionCmd(ClusterState clusterState, ZkNodeProps message, ModifiableSolrParams params) {
        ShardResponse srsp;
        log.info("Executing Collection Cmd : " + params);
        String collectionName = message.getStr("name");
        DocCollection coll = clusterState.getCollection(collectionName);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection:" + collectionName);
        }
        for (Map.Entry entry : coll.getSlicesMap().entrySet()) {
            Slice slice = (Slice)entry.getValue();
            Map shards = slice.getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                ZkNodeProps node = (ZkNodeProps)shardEntry.getValue();
                if (!clusterState.liveNodesContain(node.getStr("node_name"))) continue;
                ModifiableSolrParams cloneParams = new ModifiableSolrParams();
                cloneParams.add((SolrParams)params);
                cloneParams.set("core", new String[]{node.getStr("core")});
                String replica = node.getStr("base_url");
                ShardRequest sreq = new ShardRequest();
                cloneParams.set("qt", new String[]{this.adminPath});
                sreq.purpose = 1;
                if (replica.startsWith("http://")) {
                    replica = replica.substring(7);
                }
                sreq.shards = new String[]{replica};
                sreq.actualShards = sreq.shards;
                sreq.params = cloneParams;
                log.info("Collection Admin sending CoreAdmin cmd to " + replica + " params:" + sreq.params);
                this.shardHandler.submit(sreq, replica, sreq.params);
            }
        }
        int failed = 0;
        do {
            Throwable e;
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null || (e = srsp.getException()) == null) continue;
            ++failed;
            log.error("Error talking to shard: " + srsp.getShard(), e);
        } while (srsp != null);
        return failed <= 0;
    }

    private int msgStrToInt(ZkNodeProps message, String key, Integer def) throws Exception {
        String str = message.getStr(key);
        try {
            return str == null ? def : Integer.parseInt(str);
        }
        catch (Exception ex) {
            SolrException.log((Logger)log, (String)("Could not parse " + key), (Throwable)ex);
            throw ex;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

