/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.FieldParams;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrQueryParser;

public class SolrPluginUtils {
    private static final Pattern splitList = Pattern.compile(",| ");
    private static final Pattern whitespacePattern = Pattern.compile("\\s+");
    private static final Pattern caratPattern = Pattern.compile("\\^");
    private static final Pattern tildePattern = Pattern.compile("[~]");
    private static Pattern spaceAroundLessThanPattern = Pattern.compile("(\\s+<\\s*)|(\\s*<\\s+)");
    private static Pattern spacePattern = Pattern.compile(" ");
    private static Pattern lessThanPattern = Pattern.compile("<");
    private static final Pattern DANGLING_OP_PATTERN = Pattern.compile("\\s+[-+\\s]+$");
    private static final Pattern CONSECUTIVE_OP_PATTERN = Pattern.compile("\\s+[+-](?:\\s*[+-]+)+");

    public static void setDefaults(SolrQueryRequest req, SolrParams defaults, SolrParams appends, SolrParams invariants) {
        SolrParams p = req.getParams();
        p = SolrParams.wrapDefaults((SolrParams)p, (SolrParams)defaults);
        p = SolrParams.wrapAppended((SolrParams)p, (SolrParams)appends);
        p = SolrParams.wrapDefaults((SolrParams)invariants, (SolrParams)p);
        req.setParams(p);
    }

    public static int numDocs(SolrIndexSearcher s, Query q, Query f) throws IOException {
        return null == f ? s.getDocSet(q).size() : s.numDocs(q, f);
    }

    public static String[] split(String value) {
        return splitList.split(value.trim(), 0);
    }

    public static void optimizePreFetchDocs(ResponseBuilder rb, DocList docs, Query query, SolrQueryRequest req, SolrQueryResponse res) throws IOException {
        SolrIndexSearcher searcher = req.getSearcher();
        if (!searcher.enableLazyFieldLoading) {
            return;
        }
        ReturnFields returnFields = res.getReturnFields();
        if (returnFields.getLuceneFieldNames() != null) {
            Set<String> fieldFilter = returnFields.getLuceneFieldNames();
            if (rb.doHighlights) {
                fieldFilter = new HashSet<String>(fieldFilter);
                SolrHighlighter highlighter = HighlightComponent.getHighlighter(req.getCore());
                for (String field : highlighter.getHighlightFields(query, req, null)) {
                    fieldFilter.add(field);
                }
                SchemaField keyField = req.getSearcher().getSchema().getUniqueKeyField();
                if (null != keyField) {
                    fieldFilter.add(keyField.getName());
                }
            }
            DocIterator iter = docs.iterator();
            for (int i = 0; i < docs.size(); ++i) {
                searcher.doc(iter.nextDoc(), fieldFilter);
            }
        }
    }

    public static Set<String> getDebugInterests(String[] params, ResponseBuilder rb) {
        HashSet<String> debugInterests = new HashSet<String>();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i].equalsIgnoreCase("all") || params[i].equalsIgnoreCase("true")) {
                    rb.setDebug(true);
                    break;
                }
                if (params[i].equals("timing")) {
                    rb.setDebugTimings(true);
                    continue;
                }
                if (params[i].equals("query")) {
                    rb.setDebugQuery(true);
                    continue;
                }
                if (!params[i].equals("results")) continue;
                rb.setDebugResults(true);
            }
        }
        return debugInterests;
    }

    public static NamedList doStandardDebug(SolrQueryRequest req, String userQuery, Query query, DocList results, boolean dbgQuery, boolean dbgResults) throws IOException {
        SimpleOrderedMap dbg = new SimpleOrderedMap();
        SolrPluginUtils.doStandardQueryDebug(req, userQuery, query, dbgQuery, (NamedList)dbg);
        SolrPluginUtils.doStandardResultsDebug(req, query, results, dbgResults, (NamedList)dbg);
        return dbg;
    }

    public static void doStandardQueryDebug(SolrQueryRequest req, String userQuery, Query query, boolean dbgQuery, NamedList dbg) {
        if (dbgQuery) {
            dbg.add("rawquerystring", (Object)req.getParams().get("q"));
            dbg.add("querystring", (Object)userQuery);
            dbg.add("parsedquery", (Object)QueryParsing.toString(query, req.getSchema()));
            dbg.add("parsedquery_toString", (Object)query.toString());
        }
    }

    public static void doStandardResultsDebug(SolrQueryRequest req, Query query, DocList results, boolean dbgResults, NamedList dbg) throws IOException {
        if (dbgResults) {
            SolrIndexSearcher searcher = req.getSearcher();
            IndexSchema schema = req.getSchema();
            boolean explainStruct = req.getParams().getBool("debug.explain.structured", false);
            NamedList<Explanation> explain = SolrPluginUtils.getExplanations(query, results, searcher, schema);
            dbg.add("explain", explainStruct ? SolrPluginUtils.explanationsToNamedLists(explain) : SolrPluginUtils.explanationsToStrings(explain));
            String otherQueryS = req.getParams().get("explainOther");
            if (otherQueryS != null && otherQueryS.length() > 0) {
                DocList otherResults = SolrPluginUtils.doSimpleQuery(otherQueryS, req, 0, 10);
                dbg.add("otherQuery", (Object)otherQueryS);
                NamedList<Explanation> explainO = SolrPluginUtils.getExplanations(query, otherResults, searcher, schema);
                dbg.add("explainOther", explainStruct ? SolrPluginUtils.explanationsToNamedLists(explainO) : SolrPluginUtils.explanationsToStrings(explainO));
            }
        }
    }

    public static NamedList<Object> explanationToNamedList(Explanation e) {
        SimpleOrderedMap out = new SimpleOrderedMap();
        out.add("match", (Object)e.isMatch());
        out.add("value", (Object)Float.valueOf(e.getValue()));
        out.add("description", (Object)e.getDescription());
        Explanation[] details = e.getDetails();
        if (null == details || 0 == details.length) {
            return out;
        }
        ArrayList<NamedList<Object>> kids = new ArrayList<NamedList<Object>>(details.length);
        for (Explanation d : details) {
            kids.add(SolrPluginUtils.explanationToNamedList(d));
        }
        out.add("details", kids);
        return out;
    }

    public static NamedList<NamedList<Object>> explanationsToNamedLists(NamedList<Explanation> explanations) {
        SimpleOrderedMap out = new SimpleOrderedMap();
        for (Map.Entry entry : explanations) {
            out.add((String)entry.getKey(), SolrPluginUtils.explanationToNamedList((Explanation)entry.getValue()));
        }
        return out;
    }

    public static NamedList<Explanation> getExplanations(Query query, DocList docs, SolrIndexSearcher searcher, IndexSchema schema) throws IOException {
        SimpleOrderedMap explainList = new SimpleOrderedMap();
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            int id = iterator.nextDoc();
            Document doc = searcher.doc(id);
            String strid = schema.printableUniqueKey(doc);
            explainList.add(strid, (Object)searcher.explain(query, id));
        }
        return explainList;
    }

    private static NamedList<String> explanationsToStrings(NamedList<Explanation> explanations) {
        SimpleOrderedMap out = new SimpleOrderedMap();
        for (Map.Entry entry : explanations) {
            out.add((String)entry.getKey(), (Object)("\n" + ((Explanation)entry.getValue()).toString()));
        }
        return out;
    }

    public static DocList doSimpleQuery(String sreq, SolrQueryRequest req, int start, int limit) throws IOException {
        List commands = StrUtils.splitSmart((String)sreq, (char)';');
        String qs = commands.size() >= 1 ? (String)commands.get(0) : "";
        try {
            Query query = QParser.getParser(qs, null, req).getQuery();
            Sort sort = null;
            if (commands.size() >= 2) {
                sort = QueryParsing.parseSort((String)commands.get(1), req);
            }
            DocList results = req.getSearcher().getDocList(query, (DocSet)null, sort, start, limit);
            return results;
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing query: " + qs);
        }
    }

    public static Map<String, Float> parseFieldBoosts(String in) {
        return SolrPluginUtils.parseFieldBoosts(new String[]{in});
    }

    public static Map<String, Float> parseFieldBoosts(String[] fieldLists) {
        if (null == fieldLists || 0 == fieldLists.length) {
            return new HashMap<String, Float>();
        }
        HashMap<String, Float> out = new HashMap<String, Float>(7);
        for (String in : fieldLists) {
            String[] bb;
            if (null == in || (in = in.trim()).length() == 0) continue;
            for (String s : bb = whitespacePattern.split(in)) {
                String[] bbb = caratPattern.split(s);
                out.put(bbb[0], 1 == bbb.length ? null : Float.valueOf(bbb[1]));
            }
        }
        return out;
    }

    public static List<FieldParams> parseFieldBoostsAndSlop(String[] fieldLists, int wordGrams, int defaultSlop) {
        if (null == fieldLists || 0 == fieldLists.length) {
            return new ArrayList<FieldParams>();
        }
        ArrayList<FieldParams> out = new ArrayList<FieldParams>();
        for (String in : fieldLists) {
            String[] fieldConfigs;
            if (null == in || (in = in.trim()).length() == 0) continue;
            for (String s : fieldConfigs = whitespacePattern.split(in)) {
                String[] fieldAndSlopVsBoost = caratPattern.split(s);
                String[] fieldVsSlop = tildePattern.split(fieldAndSlopVsBoost[0]);
                String field = fieldVsSlop[0];
                int slop = 2 == fieldVsSlop.length ? Integer.valueOf(fieldVsSlop[1]) : defaultSlop;
                Float boost = Float.valueOf(1 == fieldAndSlopVsBoost.length ? 1.0f : Float.valueOf(fieldAndSlopVsBoost[1]).floatValue());
                FieldParams fp = new FieldParams(field, wordGrams, slop, boost.floatValue());
                out.add(fp);
            }
        }
        return out;
    }

    public static void setMinShouldMatch(BooleanQuery q, String spec) {
        int optionalClauses = 0;
        for (BooleanClause c : q.clauses()) {
            if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
            ++optionalClauses;
        }
        int msm = SolrPluginUtils.calculateMinShouldMatch(optionalClauses, spec);
        if (0 < msm) {
            q.setMinimumNumberShouldMatch(msm);
        }
    }

    static int calculateMinShouldMatch(int optionalClauseCount, String spec) {
        int result = optionalClauseCount;
        if (-1 < (spec = spec.trim()).indexOf("<")) {
            spec = spaceAroundLessThanPattern.matcher(spec).replaceAll("<");
            for (String s : spacePattern.split(spec)) {
                String[] parts = lessThanPattern.split(s, 0);
                int upperBound = Integer.parseInt(parts[0]);
                if (optionalClauseCount <= upperBound) {
                    return result;
                }
                result = SolrPluginUtils.calculateMinShouldMatch(optionalClauseCount, parts[1]);
            }
            return result;
        }
        if (-1 < spec.indexOf(37)) {
            int percent = Integer.parseInt(spec = spec.substring(0, spec.length() - 1));
            float calc = (float)(result * percent) * 0.01f;
            result = calc < 0.0f ? result + (int)calc : (int)calc;
        } else {
            int calc = Integer.parseInt(spec);
            int n = result = calc < 0 ? result + calc : calc;
        }
        return optionalClauseCount < result ? optionalClauseCount : (result < 0 ? 0 : result);
    }

    public static void flattenBooleanQuery(BooleanQuery to, BooleanQuery from) {
        for (BooleanClause clause : from.clauses()) {
            Query cq = clause.getQuery();
            cq.setBoost(cq.getBoost() * from.getBoost());
            if (cq instanceof BooleanQuery && !clause.isRequired() && !clause.isProhibited()) {
                SolrPluginUtils.flattenBooleanQuery(to, (BooleanQuery)cq);
                continue;
            }
            to.add(clause);
        }
    }

    public static CharSequence partialEscape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '/' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb;
    }

    public static CharSequence stripIllegalOperators(CharSequence s) {
        String temp = CONSECUTIVE_OP_PATTERN.matcher(s).replaceAll(" ");
        return DANGLING_OP_PATTERN.matcher(temp).replaceAll("");
    }

    public static CharSequence stripUnbalancedQuotes(CharSequence s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\"') continue;
            ++count;
        }
        if (!(count & true)) {
            return s;
        }
        return ((Object)s).toString().replace("\"", "");
    }

    public static NamedList removeNulls(NamedList nl) {
        for (int i = 0; i < nl.size(); ++i) {
            if (nl.getName(i) != null) continue;
            SimpleOrderedMap newList = nl instanceof SimpleOrderedMap ? new SimpleOrderedMap() : new NamedList();
            for (int j = 0; j < nl.size(); ++j) {
                String n = nl.getName(j);
                if (n == null) continue;
                newList.add(n, nl.getVal(j));
            }
            return newList;
        }
        return nl;
    }

    public static Sort getSort(SolrQueryRequest req) {
        String sort = req.getParams().get("sort");
        if (null == sort || sort.equals("")) {
            return null;
        }
        SolrException sortE = null;
        Sort ss = null;
        try {
            ss = QueryParsing.parseSort(sort, req);
        }
        catch (SolrException e) {
            sortE = e;
        }
        if (null == ss || null != sortE) {
            SolrCore.log.warn("Invalid sort \"" + sort + "\" was specified, ignoring", (Throwable)sortE);
            return null;
        }
        return ss;
    }

    public static List<Query> parseQueryStrings(SolrQueryRequest req, String[] queries) throws ParseException {
        if (null == queries || 0 == queries.length) {
            return null;
        }
        ArrayList<Query> out = new ArrayList<Query>(queries.length);
        for (String q : queries) {
            if (null == q || 0 == q.trim().length()) continue;
            out.add(QParser.getParser(q, null, req).getQuery());
        }
        return out;
    }

    public static SolrDocumentList docListToSolrDocumentList(DocList docs, SolrIndexSearcher searcher, Set<String> fields, Map<SolrDocument, Integer> ids) throws IOException {
        IndexSchema schema = searcher.getSchema();
        SolrDocumentList list = new SolrDocumentList();
        list.setNumFound((long)docs.matches());
        list.setMaxScore(Float.valueOf(docs.maxScore()));
        list.setStart((long)docs.offset());
        DocIterator dit = docs.iterator();
        while (dit.hasNext()) {
            int docid = dit.nextDoc();
            Document luceneDoc = searcher.doc(docid, fields);
            SolrDocument doc = new SolrDocument();
            for (IndexableField field : luceneDoc) {
                if (null != fields && !fields.contains(field.name())) continue;
                SchemaField sf = schema.getField(field.name());
                doc.addField(field.name(), sf.getType().toObject(field));
            }
            if (docs.hasScores() && (null == fields || fields.contains("score"))) {
                doc.addField("score", (Object)Float.valueOf(dit.score()));
            }
            list.add((Object)doc);
            if (ids == null) continue;
            ids.put(doc, new Integer(docid));
        }
        return list;
    }

    public static void invokeSetters(Object bean, NamedList initArgs) {
        if (initArgs == null) {
            return;
        }
        Class<?> clazz = bean.getClass();
        Method[] methods = clazz.getMethods();
        for (Map.Entry entry : initArgs) {
            String key = (String)entry.getKey();
            String setterName = "set" + String.valueOf(Character.toUpperCase(key.charAt(0))) + key.substring(1);
            Method method = null;
            try {
                for (Method m : methods) {
                    if (!m.getName().equals(setterName) || m.getParameterTypes().length != 1) continue;
                    method = m;
                    break;
                }
                if (method == null) {
                    throw new RuntimeException("no setter corrresponding to '" + key + "' in " + clazz.getName());
                }
                Class<?> pClazz = method.getParameterTypes()[0];
                Object val = entry.getValue();
                method.invoke(bean, val);
            }
            catch (InvocationTargetException e1) {
                throw new RuntimeException("Error invoking setter " + setterName + " on class : " + clazz.getName(), e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException("Error invoking setter " + setterName + " on class : " + clazz.getName(), e1);
            }
        }
    }

    public static class IdentityRegenerator
    implements CacheRegenerator {
        @Override
        public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
            newCache.put(oldKey, oldVal);
            return true;
        }
    }

    public static class DisjunctionMaxQueryParser
    extends SolrQueryParser {
        protected Map<String, Alias> aliases = new HashMap<String, Alias>(3);

        public DisjunctionMaxQueryParser(QParser qp, String defaultField) {
            super(qp, defaultField);
            this.setDefaultOperator(QueryParser.Operator.OR);
        }

        public void addAlias(String field, float tiebreaker, Map<String, Float> fieldBoosts) {
            Alias a = new Alias();
            a.tie = tiebreaker;
            a.fields = fieldBoosts;
            this.aliases.put(field, a);
        }

        @Override
        protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
            if (this.aliases.containsKey(field)) {
                Alias a = this.aliases.get(field);
                DisjunctionMaxQuery q = new DisjunctionMaxQuery(a.tie);
                boolean ok = false;
                for (String f : a.fields.keySet()) {
                    Query sub = this.getFieldQuery(f, queryText, quoted);
                    if (null == sub) continue;
                    if (null != a.fields.get(f)) {
                        sub.setBoost(a.fields.get(f).floatValue());
                    }
                    q.add(sub);
                    ok = true;
                }
                return ok ? q : null;
            }
            try {
                return super.getFieldQuery(field, queryText, quoted);
            }
            catch (Exception e) {
                return null;
            }
        }

        protected static class Alias {
            public float tie;
            public Map<String, Float> fields;

            protected Alias() {
            }
        }
    }
}

