/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedUpdateProcessor
extends UpdateRequestProcessor {
    public static final Logger log = LoggerFactory.getLogger(DistributedUpdateProcessor.class);
    public static final String COMMIT_END_POINT = "commit_end_point";
    public static final String LOG_REPLAY = "log_replay";
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final UpdateRequestProcessor next;
    public static final String VERSION_FIELD = "_version_";
    private final UpdateHandler updateHandler;
    private final UpdateLog ulog;
    private final VersionInfo vinfo;
    private final boolean versionsStored;
    private boolean returnVersions = true;
    private NamedList addsResponse = null;
    private NamedList deleteResponse = null;
    private NamedList deleteByQueryResponse = null;
    private CharsRef scratch;
    private final SchemaField idField;
    private SolrCmdDistributor cmdDistrib;
    private boolean zkEnabled = false;
    private CloudDescriptor cloudDesc;
    private String collection;
    private ZkController zkController;
    private boolean isLeader = true;
    private boolean forwardToLeader = false;
    private List<SolrCmdDistributor.Node> nodes;
    private int numNodes;

    public DistributedUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(next);
        this.rsp = rsp;
        this.next = next;
        this.idField = req.getSchema().getUniqueKeyField();
        this.updateHandler = req.getCore().getUpdateHandler();
        this.ulog = this.updateHandler.getUpdateLog();
        this.vinfo = this.ulog == null ? null : this.ulog.getVersionInfo();
        this.versionsStored = this.vinfo != null && this.vinfo.getVersionField() != null;
        this.returnVersions = req.getParams().getBool("versions", false);
        SolrRequestInfo reqInfo = this.returnVersions ? SolrRequestInfo.getRequestInfo() : null;
        this.req = req;
        CoreDescriptor coreDesc = req.getCore().getCoreDescriptor();
        this.zkEnabled = coreDesc.getCoreContainer().isZooKeeperAware();
        this.zkController = req.getCore().getCoreDescriptor().getCoreContainer().getZkController();
        if (this.zkEnabled) {
            this.numNodes = this.zkController.getZkStateReader().getClusterState().getLiveNodes().size();
            this.cmdDistrib = new SolrCmdDistributor(this.numNodes, coreDesc.getCoreContainer().getZkController().getCmdDistribExecutor());
        }
        this.cloudDesc = coreDesc.getCloudDescriptor();
        if (this.cloudDesc != null) {
            this.collection = this.cloudDesc.getCollectionName();
        }
    }

    private List<SolrCmdDistributor.Node> setupRequest(int hash) {
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        if (this.zkEnabled) {
            this.numNodes = this.zkController.getClusterState().getLiveNodes().size();
            String shardId = this.getShard(hash, this.collection, this.zkController.getClusterState());
            try {
                ZkCoreNodeProps leaderProps = new ZkCoreNodeProps(this.zkController.getZkStateReader().getLeaderProps(this.collection, shardId));
                String leaderNodeName = leaderProps.getCoreNodeName();
                String coreName = this.req.getCore().getName();
                String coreNodeName = this.zkController.getNodeName() + "_" + coreName;
                this.isLeader = coreNodeName.equals(leaderNodeName);
                DistribPhase phase = DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
                this.doDefensiveChecks(shardId, phase);
                if (DistribPhase.FROMLEADER == phase) {
                    this.forwardToLeader = false;
                } else if (this.isLeader) {
                    this.forwardToLeader = false;
                    List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, this.zkController.getNodeName(), coreName, null, "down");
                    if (replicaProps != null) {
                        nodes = new ArrayList(replicaProps.size());
                        String[] skipList = this.req.getParams().getParams("test.distrib.skip.servers");
                        HashSet<String> skipListSet = null;
                        if (skipList != null) {
                            skipListSet = new HashSet<String>(skipList.length);
                            skipListSet.addAll(Arrays.asList(skipList));
                        }
                        for (ZkCoreNodeProps props : replicaProps) {
                            if (skipList != null) {
                                if (skipListSet.contains(props.getCoreUrl())) continue;
                                nodes.add(new SolrCmdDistributor.StdNode(props));
                                continue;
                            }
                            nodes.add(new SolrCmdDistributor.StdNode(props));
                        }
                    }
                } else {
                    nodes = new ArrayList<SolrCmdDistributor.StdNode>(1);
                    nodes.add(new RetryNode(leaderProps, this.zkController.getZkStateReader(), this.collection, shardId));
                    this.forwardToLeader = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
        return nodes;
    }

    private void doDefensiveChecks(String shardId, DistribPhase phase) {
        String from = this.req.getParams().get("distrib.from");
        boolean logReplay = this.req.getParams().getBool(LOG_REPLAY, false);
        boolean localIsLeader = this.req.getCore().getCoreDescriptor().getCloudDescriptor().isLeader();
        if (!logReplay && DistribPhase.FROMLEADER == phase && localIsLeader && from != null) {
            log.error("Request says it is coming from leader, but we are the leader: " + this.req.getParamString());
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from leader, but we are the leader");
        }
        if (this.isLeader && !localIsLeader) {
            log.error("ClusterState says we are the leader, but locally we don't think so");
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "ClusterState says we are the leader, but locally we don't think so");
        }
    }

    private String getShard(int hash, String collection, ClusterState clusterState) {
        return clusterState.getShard(hash, collection);
    }

    private List<SolrCmdDistributor.Node> setupRequest() {
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        String shardId = this.cloudDesc.getShardId();
        try {
            ZkCoreNodeProps leaderProps = new ZkCoreNodeProps(this.zkController.getZkStateReader().getLeaderProps(this.collection, shardId));
            String leaderNodeName = leaderProps.getCoreNodeName();
            String coreName = this.req.getCore().getName();
            String coreNodeName = this.zkController.getNodeName() + "_" + coreName;
            this.isLeader = coreNodeName.equals(leaderNodeName);
            this.forwardToLeader = false;
            List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, this.zkController.getNodeName(), coreName);
            if (replicaProps != null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>(replicaProps.size());
                for (ZkCoreNodeProps props : replicaProps) {
                    nodes.add(new SolrCmdDistributor.StdNode(props));
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return nodes;
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        int hash = 0;
        if (this.zkEnabled) {
            this.zkCheck();
            hash = this.hash(cmd);
            this.nodes = this.setupRequest(hash);
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionAdd(cmd);
        }
        if (dropCmd) {
            return;
        }
        ModifiableSolrParams params = null;
        if (this.nodes != null) {
            params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader ? DistribPhase.FROMLEADER.toString() : DistribPhase.TOLEADER.toString()});
            if (this.isLeader) {
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            }
            params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            this.cmdDistrib.distribAdd(cmd, this.nodes, params);
        }
        if (this.returnVersions && this.rsp != null && this.idField != null) {
            if (this.addsResponse == null) {
                this.addsResponse = new NamedList();
                this.rsp.add("adds", this.addsResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRef();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.addsResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    private void doFinish() {
        this.cmdDistrib.finish();
        SolrCmdDistributor.Response response = this.cmdDistrib.getResponse();
        if (response.errors.size() > 0 && response.errors.get((int)0).node instanceof RetryNode) {
            this.rsp.setException(response.errors.get((int)0).e);
        }
        for (SolrCmdDistributor.Error error : response.errors) {
            if (error.node instanceof RetryNode || error.e instanceof SolrException) continue;
            String recoveryUrl = error.node.getBaseUrl();
            log.info("try and ask " + recoveryUrl + " to recover");
            try {
                HttpSolrServer server = new HttpSolrServer(recoveryUrl);
                server.setSoTimeout(5000);
                server.setConnectionTimeout(5000);
                CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
                recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
                recoverRequestCmd.setCoreName(error.node.getCoreName());
                server.request((SolrRequest)recoverRequestCmd);
            }
            catch (Exception e) {
                log.info("Could not tell a replica to recover", (Throwable)e);
            }
        }
    }

    private void doLocalAdd(AddUpdateCommand cmd) throws IOException {
        super.processAdd(cmd);
    }

    private void doLocalDelete(DeleteUpdateCommand cmd) throws IOException {
        super.processDelete(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean versionAdd(AddUpdateCommand cmd) throws IOException {
        idBytes = cmd.getIndexedId();
        if (this.vinfo == null || idBytes == null) {
            super.processAdd(cmd);
            return false;
        }
        bucketHash = Hash.murmurhash3_x86_32((byte[])idBytes.bytes, (int)idBytes.offset, (int)idBytes.length, (int)0);
        versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            versionField = cmd.getSolrInputDocument().getField("_version_");
            versionOnUpdate = versionField != null ? ((o = versionField.getValue()) instanceof Number != false ? ((Number)o).longValue() : Long.parseLong(o.toString())) : ((versionOnUpdateS = this.req.getParams().get("_version_")) == null ? 0L : Long.parseLong(versionOnUpdateS));
        }
        isReplay = (cmd.getFlags() & UpdateCommand.REPLAY) != 0;
        leaderLogic = this.isLeader != false && isReplay == false;
        bucket = this.vinfo.bucket(bucketHash);
        this.vinfo.lockForUpdate();
        var9_10 = bucket;
        synchronized (var9_10) {
            checkDeleteByQueries = false;
            if (!this.versionsStored) break block17;
            bucketVersion = bucket.highest;
            if (leaderLogic) {
                updated = this.getUpdatedDocument(cmd, versionOnUpdate);
                if (versionOnUpdate != 0L) {
                    lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                    v0 = foundVersion = lastVersion == null ? -1L : lastVersion;
                    if (versionOnUpdate != foundVersion && (versionOnUpdate >= 0L || foundVersion >= 0L)) {
                        if (versionOnUpdate != 1L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getPrintableId() + " expected=" + versionOnUpdate + " actual=" + foundVersion);
                        if (foundVersion <= 0L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getPrintableId() + " expected=" + versionOnUpdate + " actual=" + foundVersion);
                    }
                }
                version = this.vinfo.getNewClock();
                cmd.setVersion(version);
                cmd.getSolrInputDocument().setField("_version_", (Object)version);
                bucket.updateHighest(version);
                break block17;
            }
            cmd.setVersion(versionOnUpdate);
            if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                this.ulog.add(cmd);
                updated = true;
                // MONITOREXIT @DISABLED, blocks:[0, 5, 10] lbl38 : MonitorExitStatement: MONITOREXIT : var9_10
                this.vinfo.unlockForUpdate();
                return updated;
            }
            if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                bucket.updateHighest(versionOnUpdate);
                break block17;
            }
            lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
            if (lastVersion == null) break block18;
        }
        {
            block17: {
                block18: {
                    if (Math.abs(lastVersion) >= versionOnUpdate) {
                        var14_19 = true;
                        // MONITOREXIT @DISABLED, blocks:[5, 9] lbl51 : MonitorExitStatement: MONITOREXIT : var9_10
                        this.vinfo.unlockForUpdate();
                        return var14_19;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [6 : 539->622)] { 
lbl56:
                // 1 sources

                checkDeleteByQueries = true;
            }
            willDistrib = this.isLeader != false && this.nodes != null && this.nodes.size() > 0;
            clonedDoc = null;
            if (willDistrib) {
                clonedDoc = cmd.solrDoc.deepCopy();
            }
            this.doLocalAdd(cmd);
            if (willDistrib == false) return false;
            cmd.solrDoc = clonedDoc;
            return false;
lbl66:
            // 1 sources

            finally {
                this.vinfo.unlockForUpdate();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean getUpdatedDocument(AddUpdateCommand cmd, long versionOnUpdate) throws IOException {
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        boolean update = false;
        for (SolrInputField sif : sdoc.values()) {
            if (!(sif.getValue() instanceof Map)) continue;
            update = true;
            break;
        }
        if (!update) {
            return false;
        }
        BytesRef id = cmd.getIndexedId();
        SolrInputDocument oldDoc = RealTimeGetComponent.getInputDocument(cmd.getReq().getCore(), id);
        if (oldDoc == null) {
            if (versionOnUpdate > 0L) throw new SolrException(SolrException.ErrorCode.CONFLICT, "Document not found for update.  id=" + cmd.getPrintableId());
            oldDoc = new SolrInputDocument();
        } else {
            oldDoc.remove((Object)VERSION_FIELD);
        }
        for (SolrInputField sif : sdoc.values()) {
            Object val = sif.getValue();
            if (val instanceof Map) {
                for (Map.Entry entry : ((Map)val).entrySet()) {
                    void var21_20;
                    String key = (String)entry.getKey();
                    Object fieldVal = entry.getValue();
                    if ("add".equals(key)) {
                        oldDoc.addField(sif.getName(), fieldVal, sif.getBoost());
                        continue;
                    }
                    if ("set".equals(key)) {
                        oldDoc.setField(sif.getName(), fieldVal, sif.getBoost());
                        continue;
                    }
                    if (!"inc".equals(key)) continue;
                    SolrInputField numericField = oldDoc.get((Object)sif.getName());
                    if (numericField == null) {
                        oldDoc.setField(sif.getName(), fieldVal, sif.getBoost());
                        continue;
                    }
                    String oldValS = numericField.getFirstValue().toString();
                    SchemaField sf = cmd.getReq().getSchema().getField(sif.getName());
                    BytesRef term = new BytesRef();
                    sf.getType().readableToIndexed(oldValS, term);
                    Object oldVal = sf.getType().toObject(sf, term);
                    String fieldValS = fieldVal.toString();
                    if (oldVal instanceof Long) {
                        Long l = (Long)oldVal + Long.parseLong(fieldValS);
                    } else if (oldVal instanceof Float) {
                        Float f = Float.valueOf(((Float)oldVal).floatValue() + Float.parseFloat(fieldValS));
                    } else if (oldVal instanceof Double) {
                        Double d = (Double)oldVal + Double.parseDouble(fieldValS);
                    } else {
                        Integer n = (Integer)oldVal + Integer.parseInt(fieldValS);
                    }
                    oldDoc.setField(sif.getName(), (Object)var21_20, sif.getBoost());
                }
                continue;
            }
            oldDoc.put(sif.getName(), sif);
        }
        cmd.solrDoc = oldDoc;
        return true;
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (!cmd.isDeleteById()) {
            this.doDeleteByQuery(cmd);
            return;
        }
        int hash = 0;
        if (this.zkEnabled) {
            this.zkCheck();
            hash = this.hash(cmd);
            this.nodes = this.setupRequest(hash);
        } else {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        }
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionDelete(cmd);
        }
        if (dropCmd) {
            return;
        }
        ModifiableSolrParams params = null;
        if (this.nodes != null) {
            params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader ? DistribPhase.FROMLEADER.toString() : DistribPhase.TOLEADER.toString()});
            if (this.isLeader) {
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            }
            this.cmdDistrib.distribDelete(cmd, this.nodes, params);
        }
        if (this.returnVersions && this.rsp != null && cmd.getIndexedId() != null && this.idField != null) {
            if (this.deleteResponse == null) {
                this.deleteResponse = new NamedList();
                this.rsp.add("deletes", this.deleteResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRef();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.deleteResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    private ModifiableSolrParams filterParams(SolrParams params) {
        ModifiableSolrParams fparams = new ModifiableSolrParams();
        this.passParam(params, fparams, "update.chain");
        return fparams;
    }

    private void passParam(SolrParams params, ModifiableSolrParams fparams, String param) {
        String value = params.get(param);
        if (value != null) {
            fparams.add(param, new String[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        boolean leaderLogic;
        if (!this.zkEnabled) {
            this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
        } else {
            this.zkCheck();
        }
        DistribPhase phase = DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
        if (this.zkEnabled && DistribPhase.NONE == phase) {
            boolean leaderForAnyShard = false;
            Map slices = this.zkController.getClusterState().getSlices(this.collection);
            if (slices == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot find collection:" + this.collection + " in " + this.zkController.getClusterState().getCollections());
            }
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{DistribPhase.TOLEADER.toString()});
            ArrayList<SolrCmdDistributor.Node> leaders = new ArrayList<SolrCmdDistributor.Node>(slices.size());
            for (Map.Entry sliceEntry : slices.entrySet()) {
                ZkNodeProps leaderProps;
                String sliceName = (String)sliceEntry.getKey();
                try {
                    leaderProps = this.zkController.getZkStateReader().getLeaderProps(this.collection, sliceName);
                }
                catch (InterruptedException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Exception finding leader for shard " + sliceName, (Throwable)e);
                }
                ZkCoreNodeProps coreLeaderProps = new ZkCoreNodeProps(leaderProps);
                String leaderNodeName = coreLeaderProps.getCoreNodeName();
                String coreName = this.req.getCore().getName();
                String coreNodeName = this.zkController.getNodeName() + "_" + coreName;
                this.isLeader = coreNodeName.equals(leaderNodeName);
                if (this.isLeader) {
                    leaderForAnyShard = true;
                    continue;
                }
                leaders.add(new SolrCmdDistributor.StdNode(coreLeaderProps));
            }
            params.remove("commit");
            this.cmdDistrib.distribDelete(cmd, leaders, params);
            if (!leaderForAnyShard) {
                return;
            }
            phase = DistribPhase.TOLEADER;
        }
        List<SolrCmdDistributor.Node> replicas = null;
        if (this.zkEnabled && DistribPhase.TOLEADER == phase) {
            this.isLeader = true;
            replicas = this.setupRequest();
        } else if (DistribPhase.FROMLEADER == phase) {
            this.isLeader = false;
        }
        if (this.vinfo == null) {
            super.processDelete(cmd);
            return;
        }
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get(VERSION_FIELD);
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplay = (cmd.getFlags() & UpdateCommand.REPLAY) != 0;
        boolean bl = leaderLogic = this.isLeader && !isReplay;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        this.vinfo.blockUpdates();
        try {
            if (this.versionsStored) {
                if (leaderLogic) {
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(-version);
                    this.doLocalDelete(cmd);
                } else {
                    cmd.setVersion(-versionOnUpdate);
                    if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                        this.ulog.deleteByQuery(cmd);
                        return;
                    }
                    this.doLocalDelete(cmd);
                }
            }
        }
        finally {
            this.vinfo.unblockUpdates();
        }
        if (leaderLogic && replicas != null) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set(VERSION_FIELD, new String[]{Long.toString(cmd.getVersion())});
            params.set("update.distrib", new String[]{DistribPhase.FROMLEADER.toString()});
            params.set("update.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            this.cmdDistrib.distribDelete(cmd, replicas, params);
            this.cmdDistrib.finish();
        }
        if (this.returnVersions && this.rsp != null) {
            if (this.deleteByQueryResponse == null) {
                this.deleteByQueryResponse = new NamedList();
                this.rsp.add("deleteByQuery", this.deleteByQueryResponse);
            }
            this.deleteByQueryResponse.add(cmd.getQuery(), (Object)cmd.getVersion());
        }
    }

    private void zkCheck() {
        if (this.zkController.isConnected()) {
            return;
        }
        long timeoutAt = System.currentTimeMillis() + (long)this.zkController.getClientTimeout();
        while (System.currentTimeMillis() < timeoutAt) {
            if (this.zkController.isConnected()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot talk to ZooKeeper - Updates are disabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean versionDelete(DeleteUpdateCommand cmd) throws IOException {
        boolean bl;
        Long lastVersion;
        boolean leaderLogic;
        BytesRef idBytes = cmd.getIndexedId();
        if (this.vinfo == null || idBytes == null) {
            super.processDelete(cmd);
            return false;
        }
        int bucketHash = Hash.murmurhash3_x86_32((byte[])idBytes.bytes, (int)idBytes.offset, (int)idBytes.length, (int)0);
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get(VERSION_FIELD);
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        long signedVersionOnUpdate = versionOnUpdate;
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplay = (cmd.getFlags() & UpdateCommand.REPLAY) != 0;
        boolean bl2 = leaderLogic = this.isLeader && !isReplay;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        VersionBucket bucket = this.vinfo.bucket(bucketHash);
        this.vinfo.lockForUpdate();
        try {
            VersionBucket versionBucket = bucket;
            synchronized (versionBucket) {
                if (!this.versionsStored) break block16;
                long bucketVersion = bucket.highest;
                if (leaderLogic) {
                    if (signedVersionOnUpdate != 0L) {
                        long foundVersion;
                        Long lastVersion2 = this.vinfo.lookupVersion(cmd.getIndexedId());
                        long l = foundVersion = lastVersion2 == null ? -1L : lastVersion2;
                        if (!(signedVersionOnUpdate == foundVersion || signedVersionOnUpdate < 0L && foundVersion < 0L || signedVersionOnUpdate == 1L && foundVersion > 0L)) {
                            throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getId() + " expected=" + signedVersionOnUpdate + " actual=" + foundVersion);
                        }
                    }
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(-version);
                    bucket.updateHighest(version);
                    break block16;
                }
                cmd.setVersion(-versionOnUpdate);
                if (this.ulog.getState() != UpdateLog.State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                    cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                    this.ulog.delete(cmd);
                    boolean version = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl38 : MonitorExitStatement: MONITOREXIT : var11_10
                    this.vinfo.unlockForUpdate();
                    return version;
                }
                if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                    bucket.updateHighest(versionOnUpdate);
                    break block16;
                }
                lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                if (lastVersion == null) break block16;
            }
        }
        catch (Throwable throwable) {
            this.vinfo.unlockForUpdate();
            throw throwable;
        }
        {
            block16: {
                if (Math.abs(lastVersion) >= versionOnUpdate) {
                    boolean bl3 = true;
                    // MONITOREXIT @DISABLED, blocks:[5, 7] lbl52 : MonitorExitStatement: MONITOREXIT : var11_10
                    this.vinfo.unlockForUpdate();
                    return bl3;
                }
            }
            this.doLocalDelete(cmd);
            bl = false;
        }
        this.vinfo.unlockForUpdate();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        if (this.zkEnabled) {
            this.zkCheck();
        }
        if (this.vinfo != null) {
            this.vinfo.lockForUpdate();
        }
        try {
            if (this.ulog == null || this.ulog.getState() == UpdateLog.State.ACTIVE || (cmd.getFlags() & UpdateCommand.REPLAY) != 0) {
                super.processCommit(cmd);
            } else {
                log.info("Ignoring commit while not ACTIVE - state: " + (Object)((Object)this.ulog.getState()) + " replay:" + (cmd.getFlags() & UpdateCommand.REPLAY));
            }
        }
        finally {
            if (this.vinfo != null) {
                this.vinfo.unlockForUpdate();
            }
        }
        if (this.zkEnabled) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            if (!this.req.getParams().getBool(COMMIT_END_POINT, false)) {
                params.set(COMMIT_END_POINT, true);
                String nodeName = this.req.getCore().getCoreDescriptor().getCoreContainer().getZkController().getNodeName();
                String shardZkNodeName = nodeName + "_" + this.req.getCore().getName();
                List<SolrCmdDistributor.Node> nodes = this.getCollectionUrls(this.req, this.req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName(), shardZkNodeName);
                if (nodes != null) {
                    this.cmdDistrib.distribCommit(cmd, nodes, params);
                    this.finish();
                }
            }
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.zkEnabled) {
            this.doFinish();
        }
        if (this.next != null && this.nodes == null) {
            this.next.finish();
        }
    }

    private List<SolrCmdDistributor.Node> getCollectionUrls(SolrQueryRequest req, String collection, String shardZkNodeName) {
        ClusterState clusterState = req.getCore().getCoreDescriptor().getCoreContainer().getZkController().getClusterState();
        ArrayList<SolrCmdDistributor.Node> urls = new ArrayList<SolrCmdDistributor.Node>();
        Map slices = clusterState.getSlices(collection);
        if (slices == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + clusterState);
        }
        for (Map.Entry sliceEntry : slices.entrySet()) {
            Slice replicas = (Slice)slices.get(sliceEntry.getKey());
            Map shardMap = replicas.getReplicasMap();
            for (Map.Entry entry : shardMap.entrySet()) {
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)entry.getValue());
                if (!clusterState.liveNodesContain(nodeProps.getNodeName()) || ((String)entry.getKey()).equals(shardZkNodeName)) continue;
                urls.add(new SolrCmdDistributor.StdNode(nodeProps));
            }
        }
        if (urls.size() == 0) {
            return null;
        }
        return urls;
    }

    private int hash(AddUpdateCommand cmd) {
        String hashableId = cmd.getHashableId();
        return Hash.murmurhash3_x86_32((CharSequence)hashableId, (int)0, (int)hashableId.length(), (int)0);
    }

    private int hash(DeleteUpdateCommand cmd) {
        return Hash.murmurhash3_x86_32((CharSequence)cmd.getId(), (int)0, (int)cmd.getId().length(), (int)0);
    }

    public static boolean getNonZkLeaderAssumption(SolrQueryRequest req) {
        DistribPhase phase = DistribPhase.parseParam(req.getParams().get("update.distrib"));
        return DistribPhase.FROMLEADER != phase;
    }

    public static class RetryNode
    extends SolrCmdDistributor.StdNode {
        private ZkStateReader zkStateReader;
        private String collection;
        private String shardId;

        public RetryNode(ZkCoreNodeProps nodeProps, ZkStateReader zkStateReader, String collection, String shardId) {
            super(nodeProps);
            this.zkStateReader = zkStateReader;
            this.collection = collection;
            this.shardId = shardId;
        }

        @Override
        public String toString() {
            return this.url;
        }

        @Override
        public boolean checkRetry() {
            ZkCoreNodeProps leaderProps;
            try {
                leaderProps = new ZkCoreNodeProps(this.zkStateReader.getLeaderProps(this.collection, this.shardId));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            this.url = leaderProps.getCoreUrl();
            return true;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.shardId == null ? 0 : this.shardId.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RetryNode other = (RetryNode)obj;
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }

    public static enum DistribPhase {
        NONE,
        TOLEADER,
        FROMLEADER;


        public static DistribPhase parseParam(String param) {
            if (param == null || param.trim().isEmpty()) {
                return NONE;
            }
            try {
                return DistribPhase.valueOf(param);
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal value for update.distrib: " + param, (Throwable)e);
            }
        }
    }
}

