/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.solr.cloud.RecoveryStrategy;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolrCoreState
extends SolrCoreState
implements RecoveryStrategy.RecoveryListener {
    public static Logger log = LoggerFactory.getLogger(DefaultSolrCoreState.class);
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final Object recoveryLock = new Object();
    private final Object writerPauseLock = new Object();
    private int refCnt = 1;
    private SolrIndexWriter indexWriter = null;
    private DirectoryFactory directoryFactory;
    private volatile boolean recoveryRunning;
    private RecoveryStrategy recoveryStrat;
    private boolean closed = false;
    private RefCounted<IndexWriter> refCntWriter;
    private boolean pauseWriter;
    private boolean writerFree = true;

    public DefaultSolrCoreState(DirectoryFactory directoryFactory) {
        this.directoryFactory = directoryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RefCounted<IndexWriter> getIndexWriter(SolrCore core) throws IOException {
        Object object = this.writerPauseLock;
        synchronized (object) {
            if (core == null) {
                if (this.refCntWriter != null) {
                    this.refCntWriter.incref();
                }
                return this.refCntWriter;
            }
            while (this.pauseWriter) {
                try {
                    this.writerPauseLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.indexWriter == null) {
                this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2", false);
            }
            if (this.refCntWriter == null) {
                this.refCntWriter = new RefCounted<IndexWriter>((IndexWriter)this.indexWriter){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() {
                        Object object = DefaultSolrCoreState.this.writerPauseLock;
                        synchronized (object) {
                            DefaultSolrCoreState.this.writerFree = true;
                            DefaultSolrCoreState.this.writerPauseLock.notifyAll();
                        }
                    }
                };
            }
            this.writerFree = false;
            this.writerPauseLock.notifyAll();
            this.refCntWriter.incref();
            return this.refCntWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void newIndexWriter(SolrCore core, boolean rollback) throws IOException {
        log.info("Creating new IndexWriter...");
        String coreName = core.getName();
        Object object = this.writerPauseLock;
        synchronized (object) {
            this.pauseWriter = true;
            log.info("Waiting until IndexWriter is unused... core=" + coreName);
            while (!this.writerFree) {
                try {
                    this.writerPauseLock.wait();
                }
                catch (InterruptedException e) {}
            }
            try {
                if (this.indexWriter != null) {
                    if (!rollback) {
                        try {
                            log.info("Closing old IndexWriter... core=" + coreName);
                            this.indexWriter.close();
                        }
                        catch (Throwable t) {
                            SolrException.log((Logger)log, (String)("Error closing old IndexWriter. core=" + coreName), (Throwable)t);
                        }
                    } else {
                        try {
                            log.info("Rollback old IndexWriter... core=" + coreName);
                            this.indexWriter.rollback();
                        }
                        catch (Throwable t) {
                            SolrException.log((Logger)log, (String)("Error rolling back old IndexWriter. core=" + coreName), (Throwable)t);
                        }
                    }
                }
                this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2", true);
                log.info("New IndexWriter is ready to be used.");
                this.refCntWriter = null;
            }
            finally {
                this.pauseWriter = false;
                this.writerPauseLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decref(SolrCoreState.IndexWriterCloser closer) {
        DefaultSolrCoreState defaultSolrCoreState = this;
        synchronized (defaultSolrCoreState) {
            --this.refCnt;
            if (this.refCnt == 0) {
                try {
                    log.info("SolrCoreState ref count has reached 0 - closing IndexWriter");
                    if (closer != null) {
                        closer.closeWriter(this.indexWriter);
                    } else if (this.indexWriter != null) {
                        this.indexWriter.close();
                    }
                }
                catch (Throwable t) {
                    log.error("Error during shutdown of writer.", t);
                }
                try {
                    this.directoryFactory.close();
                }
                catch (Throwable t) {
                    log.error("Error during shutdown of directory factory.", t);
                }
                try {
                    log.info("Closing SolrCoreState - canceling any ongoing recovery");
                    this.cancelRecovery();
                }
                catch (Throwable t) {
                    log.error("Error cancelling recovery", t);
                }
                this.closed = true;
            }
        }
    }

    @Override
    public synchronized void incref() {
        if (this.refCnt == 0) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        ++this.refCnt;
    }

    @Override
    public synchronized void rollbackIndexWriter(SolrCore core) throws IOException {
        this.newIndexWriter(core, true);
    }

    protected SolrIndexWriter createMainIndexWriter(SolrCore core, String name, boolean forceNewDirectory) throws IOException {
        return SolrIndexWriter.create(name, core.getNewIndexDir(), core.getDirectoryFactory(), false, core.getSchema(), core.getSolrConfig().indexConfig, core.getDeletionPolicy(), core.getCodec(), forceNewDirectory);
    }

    @Override
    public DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecovery(CoreContainer cc, String name) {
        if (this.SKIP_AUTO_RECOVERY) {
            log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
            return;
        }
        if (cc.isShutDown()) {
            log.warn("Skipping recovery because Solr is shutdown");
            return;
        }
        Object object = this.recoveryLock;
        synchronized (object) {
            log.info("Running recovery - first canceling any ongoing recovery");
            this.cancelRecovery();
            while (this.recoveryRunning) {
                try {
                    this.recoveryLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (cc.isShutDown()) {
                    log.warn("Skipping recovery because Solr is shutdown");
                    return;
                }
                if (!this.closed) continue;
                return;
            }
            boolean recoveringAfterStartup = this.recoveryStrat == null;
            this.recoveryStrat = new RecoveryStrategy(cc, name, this);
            this.recoveryStrat.setRecoveringAfterStartup(recoveringAfterStartup);
            this.recoveryStrat.start();
            this.recoveryRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRecovery() {
        Object object = this.recoveryLock;
        synchronized (object) {
            if (this.recoveryStrat != null && this.recoveryRunning) {
                this.recoveryStrat.close();
                while (true) {
                    try {
                        this.recoveryStrat.join();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
                this.recoveryRunning = false;
                this.recoveryLock.notifyAll();
            }
        }
    }

    @Override
    public void recovered() {
        this.recoveryRunning = false;
    }

    @Override
    public void failed() {
        this.recoveryRunning = false;
    }
}

