/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ParseUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.ConstNumberSource;
import org.apache.lucene.queries.function.valuesource.DoubleConstValueSource;
import org.apache.lucene.queries.function.valuesource.MultiValueSource;
import org.apache.lucene.queries.function.valuesource.VectorValueSource;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.function.distance.HaversineFunction;

public class HaversineConstFunction
extends ValueSource {
    public static ValueSourceParser parser = new ValueSourceParser(){

        @Override
        public ValueSource parse(FunctionQParser fp) throws ParseException {
            List<ValueSource> sources = fp.parseValueSourceList();
            MultiValueSource mv1 = null;
            MultiValueSource mv2 = null;
            if (sources.size() != 0) {
                ValueSource vs2;
                ValueSource vs1;
                if (sources.size() == 1) {
                    ValueSource vs = sources.get(0);
                    if (!(vs instanceof MultiValueSource)) {
                        throw new ParseException("geodist - invalid parameters:" + sources);
                    }
                    mv1 = (MultiValueSource)vs;
                } else if (sources.size() == 2) {
                    vs1 = sources.get(0);
                    vs2 = sources.get(1);
                    if (vs1 instanceof MultiValueSource && vs2 instanceof MultiValueSource) {
                        mv1 = (MultiValueSource)vs1;
                        mv2 = (MultiValueSource)vs2;
                    } else {
                        mv1 = HaversineConstFunction.makeMV(sources, sources);
                    }
                } else if (sources.size() == 3) {
                    vs1 = sources.get(0);
                    vs2 = sources.get(1);
                    if (vs1 instanceof MultiValueSource) {
                        mv1 = (MultiValueSource)vs1;
                        mv2 = HaversineConstFunction.makeMV(sources.subList(1, 3), sources);
                    } else {
                        mv1 = HaversineConstFunction.makeMV(sources.subList(0, 2), sources);
                        vs1 = sources.get(2);
                        if (!(vs1 instanceof MultiValueSource)) {
                            throw new ParseException("geodist - invalid parameters:" + sources);
                        }
                        mv2 = (MultiValueSource)vs1;
                    }
                } else if (sources.size() == 4) {
                    mv1 = HaversineConstFunction.makeMV(sources.subList(0, 2), sources);
                    mv2 = HaversineConstFunction.makeMV(sources.subList(2, 4), sources);
                } else if (sources.size() > 4) {
                    throw new ParseException("geodist - invalid parameters:" + sources);
                }
            }
            if (mv1 == null) {
                mv1 = HaversineConstFunction.parsePoint(fp);
                mv2 = HaversineConstFunction.parseSfield(fp);
            } else if (mv2 == null && (mv2 = HaversineConstFunction.parsePoint(fp)) == null) {
                mv2 = HaversineConstFunction.parseSfield(fp);
            }
            if (mv1 == null || mv2 == null) {
                throw new ParseException("geodist - not enough parameters:" + sources);
            }
            double[] constants = HaversineConstFunction.getConstants(mv1);
            MultiValueSource other = mv2;
            if (constants == null) {
                constants = HaversineConstFunction.getConstants(mv2);
                other = mv1;
            }
            if (constants != null && other instanceof VectorValueSource) {
                return new HaversineConstFunction(constants[0], constants[1], (VectorValueSource)other);
            }
            return new HaversineFunction(mv1, mv2, 6371.0087714, true);
        }
    };
    private final double latCenter;
    private final double lonCenter;
    private final VectorValueSource p2;
    private final ValueSource latSource;
    private final ValueSource lonSource;
    private final double latCenterRad_cos;
    private static final double EARTH_MEAN_DIAMETER = 12742.0175428;

    private static VectorValueSource makeMV(List<ValueSource> sources, List<ValueSource> orig) throws ParseException {
        ValueSource vs1 = sources.get(0);
        ValueSource vs2 = sources.get(1);
        if (vs1 instanceof MultiValueSource || vs2 instanceof MultiValueSource) {
            throw new ParseException("geodist - invalid parameters:" + orig);
        }
        return new VectorValueSource(sources);
    }

    private static MultiValueSource parsePoint(FunctionQParser fp) throws ParseException {
        String pt = fp.getParam("pt");
        if (pt == null) {
            return null;
        }
        double[] point = null;
        try {
            point = ParseUtils.parseLatitudeLongitude((String)pt);
        }
        catch (InvalidShapeException e) {
            throw new ParseException("Bad spatial pt:" + pt);
        }
        return new VectorValueSource(Arrays.asList(new DoubleConstValueSource(point[0]), new DoubleConstValueSource(point[1])));
    }

    private static double[] getConstants(MultiValueSource vs) {
        if (!(vs instanceof VectorValueSource)) {
            return null;
        }
        List sources = ((VectorValueSource)vs).getSources();
        if (sources.get(0) instanceof ConstNumberSource && sources.get(1) instanceof ConstNumberSource) {
            return new double[]{((ConstNumberSource)sources.get(0)).getDouble(), ((ConstNumberSource)sources.get(1)).getDouble()};
        }
        return null;
    }

    private static MultiValueSource parseSfield(FunctionQParser fp) throws ParseException {
        String sfield = fp.getParam("sfield");
        if (sfield == null) {
            return null;
        }
        SchemaField sf = fp.getReq().getSchema().getField(sfield);
        ValueSource vs = sf.getType().getValueSource(sf, fp);
        if (!(vs instanceof MultiValueSource)) {
            throw new ParseException("Spatial field must implement MultiValueSource:" + sf);
        }
        return (MultiValueSource)vs;
    }

    public HaversineConstFunction(double latCenter, double lonCenter, VectorValueSource vs) {
        this.latCenter = latCenter;
        this.lonCenter = lonCenter;
        this.p2 = vs;
        this.latSource = (ValueSource)this.p2.getSources().get(0);
        this.lonSource = (ValueSource)this.p2.getSources().get(1);
        this.latCenterRad_cos = Math.cos(latCenter * (Math.PI / 180));
    }

    protected String name() {
        return "geodist";
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final FunctionValues latVals = this.latSource.getValues(context, readerContext);
        final FunctionValues lonVals = this.lonSource.getValues(context, readerContext);
        final double latCenterRad = this.latCenter * (Math.PI / 180);
        final double lonCenterRad = this.lonCenter * (Math.PI / 180);
        final double latCenterRad_cos = this.latCenterRad_cos;
        return new DoubleDocValues(this){

            public double doubleVal(int doc) {
                double latRad = latVals.doubleVal(doc) * (Math.PI / 180);
                double lonRad = lonVals.doubleVal(doc) * (Math.PI / 180);
                double diffX = latCenterRad - latRad;
                double diffY = lonCenterRad - lonRad;
                double hsinX = Math.sin(diffX * 0.5);
                double hsinY = Math.sin(diffY * 0.5);
                double h = hsinX * hsinX + latCenterRad_cos * Math.cos(latRad) * hsinY * hsinY;
                return 12742.0175428 * Math.atan2(Math.sqrt(h), Math.sqrt(1.0 - h));
            }

            public String toString(int doc) {
                return HaversineConstFunction.this.name() + '(' + latVals.toString(doc) + ',' + lonVals.toString(doc) + ',' + HaversineConstFunction.this.latCenter + ',' + HaversineConstFunction.this.lonCenter + ')';
            }
        };
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.latSource.createWeight(context, searcher);
        this.lonSource.createWeight(context, searcher);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HaversineConstFunction)) {
            return false;
        }
        HaversineConstFunction other = (HaversineConstFunction)((Object)o);
        return this.latCenter == other.latCenter && this.lonCenter == other.lonCenter && this.p2.equals((Object)other.p2);
    }

    public int hashCode() {
        int result = this.p2.hashCode();
        long temp = Double.doubleToRawLongBits(this.latCenter);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToRawLongBits(this.lonCenter);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String description() {
        return this.name() + '(' + this.p2 + ',' + this.latCenter + ',' + this.lonCenter + ')';
    }
}

