/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrCacheBase;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;

public class LRUCache<K, V>
extends SolrCacheBase
implements SolrCache<K, V> {
    private CumulativeStats stats;
    private long lookups;
    private long hits;
    private long inserts;
    private long evictions;
    private long warmupTime = 0L;
    private Map<K, V> map;
    private String description = "LRU Cache";

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        super.init(args, regenerator);
        String str = (String)args.get("size");
        final int limit = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("initialSize");
        int initialSize = Math.min(str == null ? 1024 : Integer.parseInt(str), limit);
        this.description = this.generateDescription(limit, initialSize);
        this.map = new LinkedHashMap<K, V>(initialSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                if (this.size() > limit) {
                    LRUCache.this.evictions++;
                    ((LRUCache)LRUCache.this).stats.evictions.incrementAndGet();
                    return true;
                }
                return false;
            }
        };
        if (persistence == null) {
            persistence = new CumulativeStats();
        }
        this.stats = (CumulativeStats)persistence;
        return persistence;
    }

    private String generateDescription(int limit, int initialSize) {
        String description = "LRU Cache(maxSize=" + limit + ", initialSize=" + initialSize;
        if (this.isAutowarmingOn()) {
            description = description + ", " + this.getAutowarmDescription();
        }
        description = description + ')';
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (this.getState() == SolrCache.State.LIVE) {
                this.stats.inserts.incrementAndGet();
            }
            ++this.inserts;
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Map<K, V> map = this.map;
        synchronized (map) {
            V val = this.map.get(key);
            if (this.getState() == SolrCache.State.LIVE) {
                ++this.lookups;
                this.stats.lookups.incrementAndGet();
                if (val != null) {
                    ++this.hits;
                    this.stats.hits.incrementAndGet();
                }
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache<K, V> old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.currentTimeMillis();
        LRUCache other = (LRUCache)old;
        if (this.isAutowarmingOn()) {
            Object[] keys;
            Object[] vals = null;
            Map<K, V> map = other.map;
            synchronized (map) {
                int i;
                int sz = this.autowarm.getWarmCount(other.map.size());
                keys = new Object[sz];
                vals = new Object[sz];
                Iterator<Map.Entry<K, V>> iter = other.map.entrySet().iterator();
                int skip = other.map.size() - sz;
                for (i = 0; i < skip; ++i) {
                    iter.next();
                }
                for (i = 0; i < sz; ++i) {
                    Map.Entry<K, V> entry = iter.next();
                    keys[i] = entry.getKey();
                    vals[i] = entry.getValue();
                }
            }
            for (int i = 0; i < keys.length; ++i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, keys[i], vals[i]);
                    if (continueRegen) continue;
                    break;
                }
                catch (Throwable e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + keys[i]), (Throwable)e);
                }
            }
        }
        this.warmupTime = System.currentTimeMillis() - warmingStartTime;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return LRUCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_0/solr/core/src/java/org/apache/solr/search/LRUCache.java $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        Map<K, V> map = this.map;
        synchronized (map) {
            lst.add("lookups", (Object)this.lookups);
            lst.add("hits", (Object)this.hits);
            lst.add("hitratio", (Object)LRUCache.calcHitRatio(this.lookups, this.hits));
            lst.add("inserts", (Object)this.inserts);
            lst.add("evictions", (Object)this.evictions);
            lst.add("size", (Object)this.map.size());
        }
        lst.add("warmupTime", (Object)this.warmupTime);
        long clookups = this.stats.lookups.get();
        long chits = this.stats.hits.get();
        lst.add("cumulative_lookups", (Object)clookups);
        lst.add("cumulative_hits", (Object)chits);
        lst.add("cumulative_hitratio", (Object)LRUCache.calcHitRatio(clookups, chits));
        lst.add("cumulative_inserts", (Object)this.stats.inserts.get());
        lst.add("cumulative_evictions", (Object)this.stats.evictions.get());
        return lst;
    }

    public String toString() {
        return this.name() + this.getStatistics().toString();
    }

    private static class CumulativeStats {
        AtomicLong lookups = new AtomicLong();
        AtomicLong hits = new AtomicLong();
        AtomicLong inserts = new AtomicLong();
        AtomicLong evictions = new AtomicLong();

        private CumulativeStats() {
        }
    }
}

