/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.FieldType;

class DateFieldSource
extends FieldCacheSource {
    FieldType ft;
    private static int hcode = DateFieldSource.class.hashCode();

    public DateFieldSource(String name, FieldType ft) {
        super(name);
        this.ft = ft;
    }

    public String description() {
        return "date(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        return new DocTermsIndexDocValues((ValueSource)this, readerContext, this.field){

            protected String toTerm(String readableValue) {
                return DateFieldSource.this.ft.toInternal(readableValue);
            }

            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            public int intVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                return ord;
            }

            public long longVal(int doc) {
                return this.intVal(doc);
            }

            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            public String strVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                if (ord == 0) {
                    return null;
                }
                BytesRef br = this.termsIndex.lookup(ord, this.spare);
                return DateFieldSource.this.ft.indexedToReadable(br, this.spareChars).toString();
            }

            public Object objectVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                if (ord == 0) {
                    return null;
                }
                BytesRef br = this.termsIndex.lookup(ord, new BytesRef());
                return DateFieldSource.this.ft.toObject(null, br);
            }

            public String toString(int doc) {
                return DateFieldSource.this.description() + '=' + this.intVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof DateFieldSource && super.equals(o);
    }

    public int hashCode() {
        return hcode + super.hashCode();
    }
}

