/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialArgsParser;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.util.MapListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpatialFieldType<T extends SpatialStrategy>
extends FieldType {
    public static final String SCORE_PARAM = "score";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected SpatialContext ctx;
    protected SpatialArgsParser argsParser;
    private final ConcurrentHashMap<String, T> fieldStrategyMap = new ConcurrentHashMap();

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String units = args.remove("units");
        if (!"degrees".equals(units)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Must specify units=\"degrees\" on field types with class " + this.getClass().getSimpleName());
        }
        MapListener<String, String> argsWrap = new MapListener<String, String>(args);
        this.ctx = SpatialContextFactory.makeSpatialContext(argsWrap, (ClassLoader)schema.getResourceLoader().getClassLoader());
        args.keySet().removeAll(argsWrap.getSeenKeys());
        this.argsParser = new SpatialArgsParser();
    }

    public final Field createField(SchemaField field, Object val, float boost) {
        throw new IllegalStateException("should be calling createFields because isPolyField() is true");
    }

    public final Field[] createFields(SchemaField field, Object val, float boost) {
        String shapeStr = null;
        Shape shape = null;
        if (val instanceof Shape) {
            shape = (Shape)val;
        } else {
            shapeStr = val.toString();
            shape = this.ctx.readShape(shapeStr);
        }
        if (shape == null) {
            this.log.debug("Field {}: null shape for input: {}", (Object)field, val);
            return null;
        }
        Field[] indexableFields = null;
        if (field.indexed()) {
            T strategy = this.getStrategy(field.getName());
            indexableFields = strategy.createIndexableFields(shape);
        }
        StoredField storedField = null;
        if (field.stored()) {
            if (shapeStr == null) {
                shapeStr = this.shapeToString(shape);
            }
            storedField = new StoredField(field.getName(), shapeStr);
        }
        if (indexableFields == null) {
            if (storedField == null) {
                return null;
            }
            return new Field[]{storedField};
        }
        if (storedField == null) {
            return indexableFields;
        }
        Field[] result = new Field[indexableFields.length + 1];
        System.arraycopy(indexableFields, 0, result, 0, indexableFields.length);
        result[result.length - 1] = storedField;
        return result;
    }

    protected String shapeToString(Shape shape) {
        return this.ctx.toString(shape);
    }

    protected abstract T newSpatialStrategy(String var1);

    @Override
    public final boolean isPolyField() {
        return true;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        if (!minInclusive || !maxInclusive) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both sides of spatial range query must be inclusive: " + field.getName());
        }
        Shape shape1 = this.ctx.readShape(part1);
        Shape shape2 = this.ctx.readShape(part2);
        if (!(shape1 instanceof Point) || !(shape2 instanceof Point)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both sides of spatial range query must be points: " + field.getName());
        }
        Point p1 = (Point)shape1;
        Point p2 = (Point)shape2;
        Rectangle bbox = this.ctx.makeRectangle(p1, p2);
        SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, (Shape)bbox);
        return this.getQueryFromSpatialArgs(parser, field, spatialArgs);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A ValueSource isn't directly available from this field. Instead try a query using the distance as the score.");
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return this.getQueryFromSpatialArgs(parser, field, this.argsParser.parse(externalVal, this.ctx));
    }

    private Query getQueryFromSpatialArgs(QParser parser, SchemaField field, SpatialArgs spatialArgs) {
        ValueSource valueSource;
        String score;
        T strategy = this.getStrategy(field.getName());
        SolrParams localParams = parser.getLocalParams();
        String string = score = localParams == null ? null : localParams.get(SCORE_PARAM);
        if (score == null || "none".equals(score) || "".equals(score)) {
            return strategy.makeQuery(spatialArgs);
        }
        if ("distance".equals(score)) {
            valueSource = strategy.makeDistanceValueSource(spatialArgs.getShape().getCenter());
        } else if ("recipDistance".equals(score)) {
            valueSource = strategy.makeRecipDistanceValueSource(spatialArgs.getShape());
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'score' local-param must be one of 'none', 'distance', or 'recipDistance'");
        }
        Filter filter = strategy.makeFilter(spatialArgs);
        return new FilteredQuery((Query)new FunctionQuery(valueSource), filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getStrategy(String fieldName) {
        Object strategy = (SpatialStrategy)this.fieldStrategyMap.get(fieldName);
        if (strategy == null) {
            ConcurrentHashMap<String, T> concurrentHashMap = this.fieldStrategyMap;
            synchronized (concurrentHashMap) {
                strategy = (SpatialStrategy)this.fieldStrategyMap.get(fieldName);
                if (strategy == null) {
                    strategy = this.newSpatialStrategy(fieldName);
                    this.fieldStrategyMap.put(fieldName, strategy);
                }
            }
        }
        return (T)strategy;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not supported on SpatialField: " + field.getName());
    }
}

