/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public class PivotFacetHelper {
    @Deprecated
    protected SimpleFacets getFacetImplementation(SolrQueryRequest req, DocSet docs, SolrParams params) {
        return new SimpleFacets(req, docs, params);
    }

    public SimpleOrderedMap<List<NamedList<Object>>> process(ResponseBuilder rb, SolrParams params, String[] pivots) throws IOException {
        if (!rb.doFacets || pivots == null) {
            return null;
        }
        int minMatch = params.getInt("facet.pivot.mincount", 1);
        SimpleOrderedMap pivotResponse = new SimpleOrderedMap();
        for (String pivot : pivots) {
            String[] fields = pivot.split(",");
            if (fields.length < 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Pivot Facet needs at least two fields: " + pivot);
            }
            DocSet docs = rb.getResults().docSet;
            String field = fields[0];
            String subField = fields[1];
            LinkedList<String> fnames = new LinkedList<String>();
            for (int i = fields.length - 1; i > 1; --i) {
                fnames.push(fields[i]);
            }
            SimpleFacets sf = this.getFacetImplementation(rb.req, rb.getResults().docSet, rb.req.getParams());
            NamedList<Integer> superFacets = sf.getTermCounts(field);
            pivotResponse.add(pivot, this.doPivots(superFacets, field, subField, fnames, rb, docs, minMatch));
        }
        return pivotResponse;
    }

    protected List<NamedList<Object>> doPivots(NamedList<Integer> superFacets, String field, String subField, Deque<String> fnames, ResponseBuilder rb, DocSet docs, int minMatch) throws IOException {
        SolrIndexSearcher searcher = rb.req.getSearcher();
        SchemaField sfield = searcher.getSchema().getField(field);
        FieldType ftype = sfield.getType();
        String nextField = fnames.poll();
        ArrayList<NamedList<Object>> values = new ArrayList<NamedList<Object>>(superFacets.size());
        for (Map.Entry kv : superFacets) {
            SimpleFacets sf;
            NamedList<Integer> nl;
            if ((Integer)kv.getValue() < minMatch) continue;
            String fieldValue = (String)kv.getKey();
            BytesRef termval = null;
            SimpleOrderedMap pivot = new SimpleOrderedMap();
            pivot.add("field", (Object)field);
            if (null == fieldValue) {
                pivot.add("value", null);
            } else {
                termval = new BytesRef();
                ftype.readableToIndexed(fieldValue, termval);
                pivot.add("value", ftype.toObject(sfield, termval));
            }
            pivot.add("count", kv.getValue());
            if (subField == null) {
                values.add((NamedList<Object>)pivot);
                continue;
            }
            DocSet subset = null;
            if (null == termval) {
                DocSet hasVal = searcher.getDocSet((Query)new TermRangeQuery(field, null, null, false, false));
                subset = docs.andNot(hasVal);
            } else {
                TermQuery query = new TermQuery(new Term(field, termval));
                subset = searcher.getDocSet((Query)query, docs);
            }
            if ((nl = (sf = this.getFacetImplementation(rb.req, subset, rb.req.getParams())).getTermCounts(subField)).size() < minMatch) continue;
            pivot.add("pivot", this.doPivots(nl, subField, nextField, fnames, rb, subset, minMatch));
            values.add((NamedList<Object>)pivot);
        }
        fnames.push(nextField);
        return values;
    }
}

