/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.net.MalformedURLException;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpShardHandlerFactory
extends ShardHandlerFactory
implements PluginInfoInitialized {
    protected static Logger log = LoggerFactory.getLogger(HttpShardHandlerFactory.class);
    ThreadPoolExecutor commExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultSolrThreadFactory("httpShardExecutor"));
    private HttpClient defaultClient;
    LBHttpSolrServer loadbalancer;
    int soTimeout = 0;
    int connectionTimeout = 0;
    int maxConnectionsPerHost = 20;
    int corePoolSize = 0;
    int maximumPoolSize = Integer.MAX_VALUE;
    int keepAliveTime = 5;
    int queueSize = -1;
    boolean accessPolicy = false;
    public String scheme = "http://";
    final Random r = new Random();
    static final String INIT_URL_SCHEME = "urlScheme";
    static final String INIT_CORE_POOL_SIZE = "corePoolSize";
    static final String INIT_MAX_POOL_SIZE = "maximumPoolSize";
    static final String MAX_THREAD_IDLE_TIME = "maxThreadIdleTime";
    static final String INIT_SIZE_OF_QUEUE = "sizeOfQueue";
    static final String INIT_FAIRNESS_POLICY = "fairnessPolicy";

    @Override
    public ShardHandler getShardHandler() {
        return this.getShardHandler(this.defaultClient);
    }

    public ShardHandler getShardHandler(HttpClient httpClient) {
        return new HttpShardHandler(this, httpClient);
    }

    @Override
    public void init(PluginInfo info) {
        NamedList args = info.initArgs;
        this.soTimeout = this.getParameter(args, "socketTimeout", this.soTimeout);
        this.scheme = this.getParameter(args, INIT_URL_SCHEME, "http://");
        this.scheme = this.scheme.endsWith("://") ? this.scheme : this.scheme + "://";
        this.connectionTimeout = this.getParameter(args, "connTimeout", this.connectionTimeout);
        this.maxConnectionsPerHost = this.getParameter(args, "maxConnectionsPerHost", this.maxConnectionsPerHost);
        this.corePoolSize = this.getParameter(args, INIT_CORE_POOL_SIZE, this.corePoolSize);
        this.maximumPoolSize = this.getParameter(args, INIT_MAX_POOL_SIZE, this.maximumPoolSize);
        this.keepAliveTime = this.getParameter(args, MAX_THREAD_IDLE_TIME, this.keepAliveTime);
        this.queueSize = this.getParameter(args, INIT_SIZE_OF_QUEUE, this.queueSize);
        this.accessPolicy = this.getParameter(args, INIT_FAIRNESS_POLICY, this.accessPolicy);
        SynchronousQueue<Runnable> blockingQueue = this.queueSize == -1 ? new SynchronousQueue(this.accessPolicy) : new ArrayBlockingQueue(this.queueSize, this.accessPolicy);
        this.commExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, blockingQueue, new DefaultSolrThreadFactory("httpShardExecutor"));
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        clientParams.set("maxConnectionsPerHost", this.maxConnectionsPerHost);
        clientParams.set("maxConnections", 10000);
        clientParams.set("socketTimeout", this.soTimeout);
        clientParams.set("connTimeout", this.connectionTimeout);
        clientParams.set("retry", false);
        this.defaultClient = HttpClientUtil.createClient((SolrParams)clientParams);
        try {
            this.loadbalancer = new LBHttpSolrServer(this.defaultClient, new String[0]);
        }
        catch (MalformedURLException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private <T> T getParameter(NamedList initArgs, String configKey, T defaultValue) {
        Object toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            toReturn = temp != null ? temp : defaultValue;
        }
        log.info("Setting {} to: {}", (Object)configKey, toReturn);
        return toReturn;
    }

    @Override
    public void close() {
        try {
            this.defaultClient.getConnectionManager().shutdown();
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            this.loadbalancer.shutdown();
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)this.commExecutor);
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
    }
}

