/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.net.ConnectException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;

public class HttpShardHandler
extends ShardHandler {
    private HttpShardHandlerFactory httpShardHandlerFactory;
    private CompletionService<ShardResponse> completionService;
    private Set<Future<ShardResponse>> pending;
    private Map<String, List<String>> shardToURLs;
    private HttpClient httpClient;

    public HttpShardHandler(HttpShardHandlerFactory httpShardHandlerFactory, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpShardHandlerFactory = httpShardHandlerFactory;
        this.completionService = new ExecutorCompletionService<ShardResponse>(httpShardHandlerFactory.commExecutor);
        this.pending = new HashSet<Future<ShardResponse>>();
        this.shardToURLs = new HashMap<String, List<String>>();
    }

    private List<String> getURLs(String shard) {
        List urls = this.shardToURLs.get(shard);
        if (urls == null) {
            urls = StrUtils.splitSmart((String)shard, (String)"|", (boolean)true);
            for (int i = 0; i < urls.size(); ++i) {
                urls.set(i, this.httpShardHandlerFactory.scheme + (String)urls.get(i));
            }
            if (urls.size() > 1) {
                Collections.shuffle(urls, this.httpShardHandlerFactory.r);
            }
            this.shardToURLs.put(shard, urls);
        }
        return urls;
    }

    @Override
    public void submit(final ShardRequest sreq, final String shard, final ModifiableSolrParams params) {
        final List<String> urls = this.getURLs(shard);
        Callable<ShardResponse> task = new Callable<ShardResponse>(){

            @Override
            public ShardResponse call() throws Exception {
                ShardResponse srsp = new ShardResponse();
                srsp.setShardRequest(sreq);
                srsp.setShard(shard);
                SimpleSolrResponse ssr = new SimpleSolrResponse();
                srsp.setSolrResponse(ssr);
                long startTime = System.currentTimeMillis();
                try {
                    params.remove("wt");
                    params.remove("version");
                    QueryRequest req = new QueryRequest((SolrParams)params);
                    req.setMethod(SolrRequest.METHOD.POST);
                    if (urls.size() == 0) {
                        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no servers hosting shard: " + shard);
                    }
                    if (urls.size() <= 1) {
                        String url = (String)urls.get(0);
                        srsp.setShardAddress(url);
                        HttpSolrServer server = new HttpSolrServer(url, HttpShardHandler.this.httpClient);
                        ssr.nl = server.request((SolrRequest)req);
                    } else {
                        LBHttpSolrServer.Rsp rsp = ((HttpShardHandler)HttpShardHandler.this).httpShardHandlerFactory.loadbalancer.request(new LBHttpSolrServer.Req((SolrRequest)req, urls));
                        ssr.nl = rsp.getResponse();
                        srsp.setShardAddress(rsp.getServer());
                    }
                }
                catch (ConnectException cex) {
                    srsp.setException(cex);
                }
                catch (Throwable th) {
                    srsp.setException(th);
                    if (th instanceof SolrException) {
                        srsp.setResponseCode(((SolrException)th).code());
                    }
                    srsp.setResponseCode(-1);
                }
                ssr.elapsedTime = System.currentTimeMillis() - startTime;
                return srsp;
            }
        };
        this.pending.add(this.completionService.submit(task));
    }

    @Override
    public ShardResponse takeCompletedIncludingErrors() {
        return this.take(false);
    }

    @Override
    public ShardResponse takeCompletedOrError() {
        return this.take(true);
    }

    private ShardResponse take(boolean bailOnError) {
        while (this.pending.size() > 0) {
            try {
                Future<ShardResponse> future = this.completionService.take();
                this.pending.remove(future);
                ShardResponse rsp = future.get();
                if (bailOnError && rsp.getException() != null) {
                    return rsp;
                }
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getShardRequest().responses.size() != rsp.getShardRequest().actualShards.length) continue;
                return rsp;
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Impossible Exception", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void cancelAll() {
        for (Future<ShardResponse> future : this.pending) {
            future.cancel(true);
        }
    }

    @Override
    public void checkDistributed(ResponseBuilder rb) {
        String shards_start;
        String shards_rows;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        rb.isDistrib = params.getBool("distrib", req.getCore().getCoreDescriptor().getCoreContainer().isZooKeeperAware());
        String shards = params.get("shards");
        boolean hasShardURL = shards != null && shards.indexOf(47) > 0;
        rb.isDistrib = hasShardURL | rb.isDistrib;
        if (rb.isDistrib) {
            ClusterState clusterState = null;
            Map slices = null;
            CoreDescriptor coreDescriptor = req.getCore().getCoreDescriptor();
            CloudDescriptor cloudDescriptor = coreDescriptor.getCloudDescriptor();
            ZkController zkController = coreDescriptor.getCoreContainer().getZkController();
            if (shards != null) {
                List lst = StrUtils.splitSmart((String)shards, (String)",", (boolean)true);
                rb.shards = lst.toArray(new String[lst.size()]);
                rb.slices = new String[rb.shards.length];
                if (zkController != null) {
                    for (int i = 0; i < rb.shards.length; ++i) {
                        if (rb.shards[i].indexOf(47) >= 0) continue;
                        rb.slices[i] = rb.shards[i];
                        rb.shards[i] = null;
                    }
                }
            } else if (zkController != null) {
                clusterState = zkController.getClusterState();
                String collections = params.get("collection");
                if (collections != null) {
                    List collectionList = StrUtils.splitSmart((String)collections, (String)",", (boolean)true);
                    slices = new HashMap();
                    for (int i = 0; i < collectionList.size(); ++i) {
                        String collection = (String)collectionList.get(i);
                        ClientUtils.appendMap((String)collection, slices, (Map)clusterState.getSlices(collection));
                    }
                } else {
                    slices = clusterState.getSlices(cloudDescriptor.getCollectionName());
                    if (slices == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection:" + cloudDescriptor.getCollectionName());
                    }
                }
                rb.slices = slices.keySet().toArray(new String[slices.size()]);
                rb.shards = new String[rb.slices.length];
            }
            if (zkController != null) {
                for (int i = 0; i < rb.shards.length; ++i) {
                    String sliceName;
                    Slice slice;
                    if (rb.shards[i] != null) continue;
                    if (clusterState == null) {
                        clusterState = zkController.getClusterState();
                        slices = clusterState.getSlices(cloudDescriptor.getCollectionName());
                    }
                    if ((slice = (Slice)slices.get(sliceName = rb.slices[i])) == null) {
                        rb.shards[i] = "";
                        continue;
                    }
                    Map sliceShards = slice.getReplicasMap();
                    Set liveNodes = clusterState.getLiveNodes();
                    StringBuilder sliceShardsStr = new StringBuilder();
                    boolean first = true;
                    for (Replica nodeProps : sliceShards.values()) {
                        ZkCoreNodeProps coreNodeProps = new ZkCoreNodeProps((ZkNodeProps)nodeProps);
                        if (!liveNodes.contains(coreNodeProps.getNodeName()) || !coreNodeProps.getState().equals("active")) continue;
                        if (first) {
                            first = false;
                        } else {
                            sliceShardsStr.append('|');
                        }
                        String url = coreNodeProps.getCoreUrl();
                        if (url.startsWith("http://")) {
                            url = url.substring(7);
                        }
                        sliceShardsStr.append(url);
                    }
                    rb.shards[i] = sliceShardsStr.toString();
                }
            }
        }
        if ((shards_rows = params.get("shards.rows")) != null) {
            rb.shards_rows = Integer.parseInt(shards_rows);
        }
        if ((shards_start = params.get("shards.start")) != null) {
            rb.shards_start = Integer.parseInt(shards_start);
        }
    }

    private static class SimpleSolrResponse
    extends SolrResponse {
        long elapsedTime;
        NamedList<Object> nl;

        private SimpleSolrResponse() {
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public NamedList<Object> getResponse() {
            return this.nl;
        }

        public void setResponse(NamedList<Object> rsp) {
            this.nl = rsp;
        }
    }
}

