/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QueryParsing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetComponent
extends SearchComponent {
    public static Logger log = LoggerFactory.getLogger(FacetComponent.class);
    public static final String COMPONENT_NAME = "facet";
    static final String PIVOT_KEY = "facet_pivot";
    PivotFacetHelper pivotHelper;
    private static final String commandPrefix = "{!terms=$";

    @Override
    public void init(NamedList args) {
        this.pivotHelper = new PivotFacetHelper();
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.setNeedDocSet(true);
            rb.doFacets = true;
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (rb.doFacets) {
            SimpleOrderedMap<List<NamedList<Object>>> v;
            SolrParams params = rb.req.getParams();
            SimpleFacets f = new SimpleFacets(rb.req, rb.getResults().docSet, params, rb);
            NamedList<Object> counts = f.getFacetCounts();
            String[] pivots = params.getParams("facet.pivot");
            if (pivots != null && pivots.length > 0 && (v = this.pivotHelper.process(rb, params, pivots)) != null) {
                counts.add(PIVOT_KEY, v);
            }
            rb.rsp.add("facet_counts", counts);
        }
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.doFacets) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                ArrayList<String> refinements = null;
                for (DistribFieldFacet dff : rb._facetInfo.facets.values()) {
                    List<String> refList;
                    if (!dff.needRefinements || (refList = dff._toRefine[shardNum]) == null || refList.size() == 0) continue;
                    String key = dff.getKey();
                    String termsKey = key + "__terms";
                    String termsVal = StrUtils.join(refList, (char)',');
                    String termsKeyEncoded = QueryParsing.encodeLocalParamVal(termsKey);
                    String facetCommand = dff.localParams != null ? commandPrefix + termsKeyEncoded + " " + dff.facetStr.substring(2) : commandPrefix + termsKeyEncoded + '}' + dff.field;
                    if (refinements == null) {
                        refinements = new ArrayList<String>();
                    }
                    refinements.add(facetCommand);
                    refinements.add(termsKey);
                    refinements.add(termsVal);
                }
                if (refinements == null) continue;
                String shard = rb.shards[shardNum];
                ShardRequest refine = null;
                boolean newRequest = false;
                for (ShardRequest sreq : rb.outgoing) {
                    if ((sreq.purpose & 0x40) == 0 || sreq.shards == null || sreq.shards.length != 1 || !sreq.shards[0].equals(shard)) continue;
                    refine = sreq;
                    break;
                }
                if (refine == null) {
                    newRequest = true;
                    refine = new ShardRequest();
                    refine.shards = new String[]{rb.shards[shardNum]};
                    refine.params = new ModifiableSolrParams(rb.req.getParams());
                    refine.params.remove("start");
                    refine.params.set("rows", new String[]{"0"});
                }
                refine.purpose |= 0x20;
                refine.params.set(COMPONENT_NAME, new String[]{"true"});
                refine.params.remove("facet.field");
                refine.params.remove("facet.query");
                int i = 0;
                while (i < refinements.size()) {
                    String facetCommand = (String)refinements.get(i++);
                    String termsKey = (String)refinements.get(i++);
                    String termsVal = (String)refinements.get(i++);
                    refine.params.add("facet.field", new String[]{facetCommand});
                    refine.params.set(termsKey, new String[]{termsVal});
                }
                if (!newRequest) continue;
                rb.addRequest(this, refine);
            }
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doFacets) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            sreq.purpose |= 0x10;
            FacetInfo fi = rb._facetInfo;
            if (fi == null) {
                rb._facetInfo = fi = new FacetInfo();
                fi.parse(rb.req.getParams(), rb);
            }
            sreq.params.remove("facet.mincount");
            sreq.params.remove("facet.offset");
            sreq.params.remove("facet.limit");
            for (DistribFieldFacet dff : fi.facets.values()) {
                String paramStart = "f." + dff.field + '.';
                sreq.params.remove(paramStart + "facet.mincount");
                sreq.params.remove(paramStart + "facet.offset");
                int n = dff.initialLimit = dff.limit <= 0 ? dff.limit : dff.offset + dff.limit;
                if (dff.sort.equals("count")) {
                    if (dff.limit > 0) {
                        dff.initialLimit = (int)((double)dff.initialLimit * 1.5) + 10;
                        dff.initialMincount = 0;
                    } else {
                        dff.initialMincount = Math.min(dff.minCount, 1);
                    }
                } else {
                    dff.initialMincount = dff.minCount <= 1 ? dff.minCount : (int)Math.ceil((double)dff.minCount / (double)rb.slices.length);
                }
                if (dff.initialMincount != 0) {
                    sreq.params.set(paramStart + "facet.mincount", dff.initialMincount);
                }
                dff.initialLimit = rb.req.getParams().getInt("facet.shard.limit", dff.initialLimit);
                sreq.params.set(paramStart + "facet.limit", dff.initialLimit);
            }
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doFacets) {
            return;
        }
        if ((sreq.purpose & 0x10) != 0) {
            this.countFacets(rb, sreq);
        } else if ((sreq.purpose & 0x20) != 0) {
            this.refineFacets(rb, sreq);
        }
    }

    private void countFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse srsp : sreq.responses) {
            SimpleOrderedMap facet_ranges;
            SimpleOrderedMap facet_dates;
            NamedList facet_fields;
            int shardNum = rb.getShardNum(srsp.getShard());
            NamedList facet_counts = null;
            try {
                facet_counts = (NamedList)srsp.getSolrResponse().getResponse().get("facet_counts");
            }
            catch (Exception ex) {
                if (rb.req.getParams().getBool("shards.tolerant", false)) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read facet info for shard: " + srsp.getShard(), (Throwable)ex);
            }
            NamedList facet_queries = (NamedList)facet_counts.get("facet_queries");
            if (facet_queries != null) {
                for (int i = 0; i < facet_queries.size(); ++i) {
                    String returnedKey = facet_queries.getName(i);
                    long count = ((Number)facet_queries.getVal(i)).longValue();
                    QueryFacet qf = fi.queryFacets.get(returnedKey);
                    qf.count += count;
                }
            }
            if ((facet_fields = (NamedList)facet_counts.get("facet_fields")) != null) {
                for (DistribFieldFacet dff : fi.facets.values()) {
                    dff.add(shardNum, (NamedList)facet_fields.get(dff.getKey()), dff.initialLimit);
                }
            }
            if ((facet_dates = (SimpleOrderedMap)facet_counts.get("facet_dates")) != null) {
                for (Map.Entry entry : facet_dates) {
                    String field = (String)entry.getKey();
                    if (fi.dateFacets.get(field) == null) {
                        fi.dateFacets.add(field, entry.getValue());
                        continue;
                    }
                    SimpleOrderedMap shardFieldValues = (SimpleOrderedMap)entry.getValue();
                    SimpleOrderedMap existFieldValues = (SimpleOrderedMap)fi.dateFacets.get(field);
                    for (Map.Entry existPair : existFieldValues) {
                        Integer newValue;
                        String key = (String)existPair.getKey();
                        if (key.equals("gap") || key.equals("end") || key.equals("start") || null == (newValue = (Integer)shardFieldValues.get(key))) continue;
                        Integer oldValue = (Integer)existPair.getValue();
                        existPair.setValue(oldValue + newValue);
                    }
                }
            }
            if ((facet_ranges = (SimpleOrderedMap)facet_counts.get("facet_ranges")) == null) continue;
            for (Map.Entry entry : facet_ranges) {
                String field = (String)entry.getKey();
                if (fi.rangeFacets.get(field) == null) {
                    fi.rangeFacets.add(field, entry.getValue());
                    continue;
                }
                NamedList shardFieldValues = (NamedList)((SimpleOrderedMap)entry.getValue()).get("counts");
                NamedList existFieldValues = (NamedList)((SimpleOrderedMap)fi.rangeFacets.get(field)).get("counts");
                for (Map.Entry existPair : existFieldValues) {
                    String key = (String)existPair.getKey();
                    Integer newValue = (Integer)shardFieldValues.get(key);
                    if (null == newValue) continue;
                    Integer oldValue = (Integer)existPair.getValue();
                    existPair.setValue(oldValue + newValue);
                }
            }
        }
        for (DistribFieldFacet dff : fi.facets.values()) {
            if (dff.initialLimit <= 0 && dff.initialMincount == 0 || dff.minCount == 0 && dff.sort.equals("index")) continue;
            List[] tmp = new List[rb.shards.length];
            dff._toRefine = tmp;
            ShardFacetCount[] counts = dff.getCountSorted();
            int ntop = Math.min(counts.length, dff.limit >= 0 ? dff.offset + dff.limit : Integer.MAX_VALUE);
            long smallestCount = counts.length == 0 ? 0L : counts[ntop - 1].count;
            for (int i = 0; i < counts.length; ++i) {
                ShardFacetCount sfc = counts[i];
                boolean needRefinement = false;
                if (i < ntop) {
                    needRefinement = true;
                } else {
                    long maxCount = sfc.count;
                    for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                        OpenBitSet obs = dff.counted[shardNum];
                        if (obs == null || obs.get(sfc.termNum)) continue;
                        maxCount += dff.maxPossible(sfc, shardNum);
                    }
                    if (maxCount >= smallestCount) {
                        needRefinement = true;
                    }
                }
                if (!needRefinement) continue;
                for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                    OpenBitSet obs = dff.counted[shardNum];
                    if (obs == null || obs.get(sfc.termNum) || dff.maxPossible(sfc, shardNum) <= 0L) continue;
                    dff.needRefinements = true;
                    List<String> lst = dff._toRefine[shardNum];
                    if (lst == null) {
                        lst = dff._toRefine[shardNum] = new ArrayList<String>();
                    }
                    lst.add(sfc.name);
                }
            }
        }
    }

    private void refineFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse srsp : sreq.responses) {
            NamedList facet_counts = (NamedList)srsp.getSolrResponse().getResponse().get("facet_counts");
            NamedList facet_fields = (NamedList)facet_counts.get("facet_fields");
            if (facet_fields == null) continue;
            for (int i = 0; i < facet_fields.size(); ++i) {
                String key = facet_fields.getName(i);
                DistribFieldFacet dff = fi.facets.get(key);
                if (dff == null) continue;
                NamedList shardCounts = (NamedList)facet_fields.getVal(i);
                for (int j = 0; j < shardCounts.size(); ++j) {
                    String name = shardCounts.getName(j);
                    long count = ((Number)shardCounts.getVal(j)).longValue();
                    ShardFacetCount sfc = dff.counts.get(name);
                    if (sfc == null) {
                        log.error("Unexpected term returned for facet refining. key=" + key + " term='" + name + "'" + "\n\trequest params=" + sreq.params + "\n\ttoRefine=" + dff._toRefine + "\n\tresponse=" + shardCounts);
                        continue;
                    }
                    sfc.count += count;
                }
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doFacets || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        FacetInfo fi = rb._facetInfo;
        SimpleOrderedMap facet_counts = new SimpleOrderedMap();
        SimpleOrderedMap facet_queries = new SimpleOrderedMap();
        facet_counts.add("facet_queries", (Object)facet_queries);
        for (QueryFacet qf : fi.queryFacets.values()) {
            facet_queries.add(qf.getKey(), (Object)this.num(qf.count));
        }
        SimpleOrderedMap facet_fields = new SimpleOrderedMap();
        facet_counts.add("facet_fields", (Object)facet_fields);
        for (DistribFieldFacet dff : fi.facets.values()) {
            ShardFacetCount[] counts;
            NamedList fieldCounts = new NamedList();
            facet_fields.add(dff.getKey(), (Object)fieldCounts);
            boolean countSorted = dff.sort.equals("count");
            if (countSorted) {
                counts = dff.countSorted;
                if (counts == null || dff.needRefinements) {
                    counts = dff.getCountSorted();
                }
            } else {
                counts = dff.sort.equals("index") ? dff.getLexSorted() : dff.getLexSorted();
            }
            if (countSorted) {
                int end = dff.limit < 0 ? counts.length : Math.min(dff.offset + dff.limit, counts.length);
                for (int i = dff.offset; i < end && counts[i].count >= (long)dff.minCount; ++i) {
                    fieldCounts.add(counts[i].name, (Object)this.num(counts[i].count));
                }
            } else {
                int off = dff.offset;
                int lim = dff.limit >= 0 ? dff.limit : Integer.MAX_VALUE;
                for (int i = 0; i < counts.length; ++i) {
                    long count = counts[i].count;
                    if (count < (long)dff.minCount) continue;
                    if (off > 0) {
                        --off;
                        continue;
                    }
                    if (lim > 0) {
                        --lim;
                        fieldCounts.add(counts[i].name, (Object)this.num(count));
                        continue;
                    }
                    break;
                }
            }
            if (!dff.missing) continue;
            fieldCounts.add(null, (Object)this.num(dff.missingCount));
        }
        facet_counts.add("facet_dates", fi.dateFacets);
        facet_counts.add("facet_ranges", fi.rangeFacets);
        rb.rsp.add("facet_counts", facet_counts);
        rb._facetInfo = null;
    }

    private Number num(long val) {
        if (val < Integer.MAX_VALUE) {
            return (int)val;
        }
        return val;
    }

    private Number num(Long val) {
        if (val < Integer.MAX_VALUE) {
            return val.intValue();
        }
        return val;
    }

    @Override
    public String getDescription() {
        return "Handle Faceting";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_0/solr/core/src/java/org/apache/solr/handler/component/FacetComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    public static class ShardFacetCount {
        public String name;
        public String indexed;
        public long count;
        public int termNum;

        public String toString() {
            return "{term=" + this.name + ",termNum=" + this.termNum + ",count=" + this.count + "}";
        }
    }

    public static class DistribFieldFacet
    extends FieldFacet {
        public List<String>[] _toRefine;
        public long missingMaxPossible;
        public long[] missingMax;
        public OpenBitSet[] counted;
        public HashMap<String, ShardFacetCount> counts = new HashMap(128);
        public int termNum;
        public int initialLimit;
        public int initialMincount;
        public boolean needRefinements;
        public ShardFacetCount[] countSorted;

        DistribFieldFacet(ResponseBuilder rb, String facetStr) {
            super(rb, facetStr);
            this.missingMax = new long[rb.shards.length];
            this.counted = new OpenBitSet[rb.shards.length];
        }

        void add(int shardNum, NamedList shardCounts, int numRequested) {
            int sz;
            int numReceived = sz = shardCounts == null ? 0 : shardCounts.size();
            OpenBitSet terms = new OpenBitSet((long)(this.termNum + sz));
            long last = 0L;
            for (int i = 0; i < sz; ++i) {
                String name = shardCounts.getName(i);
                long count = ((Number)shardCounts.getVal(i)).longValue();
                if (name == null) {
                    this.missingCount += count;
                    --numReceived;
                    continue;
                }
                ShardFacetCount sfc = this.counts.get(name);
                if (sfc == null) {
                    sfc = new ShardFacetCount();
                    sfc.name = name;
                    sfc.indexed = this.ftype == null ? sfc.name : this.ftype.toInternal(sfc.name);
                    ++this.termNum;
                    sfc.termNum = sfc.termNum;
                    this.counts.put(name, sfc);
                }
                sfc.count += count;
                terms.fastSet(sfc.termNum);
                last = count;
            }
            if (numRequested < 0 || numRequested != 0 && numReceived < numRequested) {
                last = this.initialMincount;
            }
            this.missingMaxPossible += last;
            this.missingMax[shardNum] = last;
            this.counted[shardNum] = terms;
        }

        public ShardFacetCount[] getLexSorted() {
            ShardFacetCount[] arr = this.counts.values().toArray(new ShardFacetCount[this.counts.size()]);
            Arrays.sort(arr, new Comparator<ShardFacetCount>(){

                @Override
                public int compare(ShardFacetCount o1, ShardFacetCount o2) {
                    return o1.indexed.compareTo(o2.indexed);
                }
            });
            this.countSorted = arr;
            return arr;
        }

        public ShardFacetCount[] getCountSorted() {
            ShardFacetCount[] arr = this.counts.values().toArray(new ShardFacetCount[this.counts.size()]);
            Arrays.sort(arr, new Comparator<ShardFacetCount>(){

                @Override
                public int compare(ShardFacetCount o1, ShardFacetCount o2) {
                    if (o2.count < o1.count) {
                        return -1;
                    }
                    if (o1.count < o2.count) {
                        return 1;
                    }
                    return o1.indexed.compareTo(o2.indexed);
                }
            });
            this.countSorted = arr;
            return arr;
        }

        long maxPossible(ShardFacetCount sfc, int shardNum) {
            return this.missingMax[shardNum];
        }
    }

    public static class FieldFacet
    extends FacetBase {
        public String field;
        public FieldType ftype;
        public int offset;
        public int limit;
        public int minCount;
        public String sort;
        public boolean missing;
        public String prefix;
        public long missingCount;

        public FieldFacet(ResponseBuilder rb, String facetStr) {
            super(rb, "facet.field", facetStr);
            this.fillParams(rb, rb.req.getParams(), this.facetOn);
        }

        private void fillParams(ResponseBuilder rb, SolrParams params, String field) {
            this.field = field;
            this.ftype = rb.req.getSchema().getFieldTypeNoEx(this.field);
            this.offset = params.getFieldInt(field, "facet.offset", 0);
            this.limit = params.getFieldInt(field, "facet.limit", 100);
            Integer mincount = params.getFieldInt(field, "facet.mincount");
            if (mincount == null) {
                Boolean zeros = params.getFieldBool(field, "facet.zeros");
                mincount = zeros != null && zeros == false ? 1 : 0;
            }
            this.minCount = mincount;
            this.missing = params.getFieldBool(field, "facet.missing", false);
            this.sort = params.getFieldParam(field, "facet.sort", this.limit > 0 ? "count" : "index");
            if (this.sort.equals("true")) {
                this.sort = "count";
            } else if (this.sort.equals("false")) {
                this.sort = "index";
            }
            this.prefix = params.getFieldParam(field, "facet.prefix");
        }
    }

    public static class QueryFacet
    extends FacetBase {
        public long count;

        public QueryFacet(ResponseBuilder rb, String facetStr) {
            super(rb, "facet.query", facetStr);
        }
    }

    public static class FacetBase {
        String facetType;
        String facetStr;
        String facetOn;
        private String key;
        SolrParams localParams;

        public FacetBase(ResponseBuilder rb, String facetType, String facetStr) {
            this.facetType = facetType;
            this.facetStr = facetStr;
            try {
                this.localParams = QueryParsing.getLocalParams(facetStr, rb.req.getParams());
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            this.facetOn = facetStr;
            this.key = facetStr;
            if (this.localParams != null) {
                if (!facetType.equals("facet.query")) {
                    this.key = this.facetOn = this.localParams.get("v");
                }
                this.key = this.localParams.get("key", this.key);
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.facetType;
        }
    }

    public static class FacetInfo {
        public LinkedHashMap<String, QueryFacet> queryFacets;
        public LinkedHashMap<String, DistribFieldFacet> facets;
        public SimpleOrderedMap<SimpleOrderedMap<Object>> dateFacets = new SimpleOrderedMap();
        public SimpleOrderedMap<SimpleOrderedMap<Object>> rangeFacets = new SimpleOrderedMap();

        void parse(SolrParams params, ResponseBuilder rb) {
            String[] facetFs;
            this.queryFacets = new LinkedHashMap();
            this.facets = new LinkedHashMap();
            String[] facetQs = params.getParams("facet.query");
            if (facetQs != null) {
                for (String query : facetQs) {
                    QueryFacet queryFacet = new QueryFacet(rb, query);
                    this.queryFacets.put(queryFacet.getKey(), queryFacet);
                }
            }
            if ((facetFs = params.getParams("facet.field")) != null) {
                for (String field : facetFs) {
                    DistribFieldFacet ff = new DistribFieldFacet(rb, field);
                    this.facets.put(ff.getKey(), ff);
                }
            }
        }
    }
}

