/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase {
    protected static Logger log = LoggerFactory.getLogger(CollectionsHandler.class);
    protected final CoreContainer coreContainer;

    public CollectionsHandler() {
        this.coreContainer = null;
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        SolrParams params = req.getParams();
        CollectionParams.CollectionAction action = null;
        String a = params.get("action");
        if (a != null) {
            action = CollectionParams.CollectionAction.get((String)a);
        }
        if (action != null) {
            switch (action) {
                case CREATE: {
                    this.handleCreateAction(req, rsp);
                    break;
                }
                case DELETE: {
                    this.handleDeleteAction(req, rsp);
                    break;
                }
                case RELOAD: {
                    this.handleReloadAction(req, rsp);
                    break;
                }
                case SYNCSHARD: {
                    this.handleSyncShardAction(req, rsp);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown action: " + action);
                }
            }
        }
        rsp.setHttpCaching(false);
    }

    private void handleReloadAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Reloading Collection : " + req.getParamString());
        String name = req.getParams().required().get("name");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "reloadcollection", "name", name});
        this.coreContainer.getZkController().getOverseerCollectionQueue().offer(ZkStateReader.toJSON((Object)m));
    }

    private void handleSyncShardAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException, SolrServerException, IOException {
        log.info("Syncing shard : " + req.getParamString());
        String collection = req.getParams().required().get("collection");
        String shard = req.getParams().required().get("shard");
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        ZkNodeProps leaderProps = clusterState.getLeader(collection, shard);
        ZkCoreNodeProps nodeProps = new ZkCoreNodeProps(leaderProps);
        HttpSolrServer server = new HttpSolrServer(nodeProps.getBaseUrl());
        CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
        reqSyncShard.setCollection(collection);
        reqSyncShard.setShard(shard);
        reqSyncShard.setCoreName(nodeProps.getCoreName());
        server.request((SolrRequest)reqSyncShard);
    }

    private void handleDeleteAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Deleting Collection : " + req.getParamString());
        String name = req.getParams().required().get("name");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "deletecollection", "name", name});
        this.coreContainer.getZkController().getOverseerCollectionQueue().offer(ZkStateReader.toJSON((Object)m));
    }

    private void handleCreateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws InterruptedException, KeeperException {
        log.info("Creating Collection : " + req.getParamString());
        Integer numReplicas = req.getParams().getInt("replicationFactor", 0);
        String name = req.getParams().required().get("name");
        String configName = req.getParams().get("collection.configName");
        String numShards = req.getParams().get("numShards");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "createcollection", "replicationFactor", numReplicas.toString(), "name", name, "collection.configName", configName, "numShards", numShards});
        this.coreContainer.getZkController().getOverseerCollectionQueue().offer(ZkStateReader.toJSON((Object)m));
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/trunk/solr/core/src/java/org/apache/solr/handler/admin/CollectionHandler.java $";
    }
}

