/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class DumpRequestHandler
extends RequestHandlerBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        rsp.add("params", req.getParams().toNamedList());
        if (req.getContentStreams() != null) {
            ArrayList<SimpleOrderedMap> streams = new ArrayList<SimpleOrderedMap>();
            for (ContentStream content : req.getContentStreams()) {
                SimpleOrderedMap stream = new SimpleOrderedMap();
                stream.add("name", (Object)content.getName());
                stream.add("sourceInfo", (Object)content.getSourceInfo());
                stream.add("size", (Object)content.getSize());
                stream.add("contentType", (Object)content.getContentType());
                Reader reader = content.getReader();
                try {
                    stream.add("stream", (Object)IOUtils.toString((Reader)reader));
                }
                finally {
                    reader.close();
                }
                streams.add(stream);
            }
            rsp.add("streams", streams);
        }
        rsp.add("context", req.getContext());
    }

    @Override
    public String getDescription() {
        return "Dump handler (debug)";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_0/solr/core/src/java/org/apache/solr/handler/DumpRequestHandler.java $";
    }
}

