/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.update.PeerSync;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final ShardHandler shardHandler;
    private ThreadPoolExecutor recoveryCmdExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultSolrThreadFactory("recoveryCmdExecutor"));
    private volatile boolean isClosed;
    private static final HttpClient client;

    public SyncStrategy() {
        this.shardHandler = new HttpShardHandlerFactory().getShardHandler(client);
    }

    public boolean sync(ZkController zkController, SolrCore core, ZkNodeProps leaderProps) {
        if (this.SKIP_AUTO_RECOVERY) {
            return true;
        }
        this.log.info("Sync replicas to " + ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps));
        if (core.getUpdateHandler().getUpdateLog() == null) {
            this.log.error("No UpdateLog found - cannot sync");
            return false;
        }
        boolean success = this.syncReplicas(zkController, core, leaderProps);
        return success;
    }

    private boolean syncReplicas(ZkController zkController, SolrCore core, ZkNodeProps leaderProps) {
        boolean success = false;
        CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shardId = cloudDesc.getShardId();
        if (this.isClosed) {
            this.log.info("We have been closed, won't sync with replicas");
            return false;
        }
        try {
            success = this.syncWithReplicas(zkController, core, leaderProps, collection, shardId);
        }
        catch (Exception e) {
            SolrException.log((Logger)this.log, (String)"Sync Failed", (Throwable)e);
        }
        try {
            if (this.isClosed) {
                this.log.info("We have been closed, won't attempt to sync replicas back to leader");
                return false;
            }
            if (success) {
                this.log.info("Sync Success - now sync replicas to me");
                this.syncToMe(zkController, collection, shardId, leaderProps);
            } else {
                SolrException.log((Logger)this.log, (String)"Sync Failed");
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)this.log, (String)"Sync Failed", (Throwable)e);
        }
        return success;
    }

    private boolean syncWithReplicas(ZkController zkController, SolrCore core, ZkNodeProps props, String collection, String shardId) {
        List nodes = zkController.getZkStateReader().getReplicaProps(collection, shardId, props.getStr("node_name"), props.getStr("core"));
        if (nodes == null) {
            return true;
        }
        ArrayList<String> syncWith = new ArrayList<String>();
        for (ZkCoreNodeProps node : nodes) {
            syncWith.add(node.getCoreUrl());
        }
        PeerSync peerSync = new PeerSync(core, syncWith, core.getUpdateHandler().getUpdateLog().numRecordsToKeep, true);
        return peerSync.sync();
    }

    private void syncToMe(ZkController zkController, String collection, String shardId, ZkNodeProps leaderProps) {
        ShardResponse srsp;
        List nodes = zkController.getZkStateReader().getReplicaProps(collection, shardId, leaderProps.getStr("node_name"), leaderProps.getStr("core"));
        if (nodes == null) {
            this.log.info(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + " has no replicas");
            return;
        }
        ZkCoreNodeProps zkLeader = new ZkCoreNodeProps(leaderProps);
        for (ZkCoreNodeProps node : nodes) {
            try {
                this.log.info(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": try and ask " + node.getCoreUrl() + " to sync");
                this.requestSync(node.getBaseUrl(), node.getCoreUrl(), zkLeader.getCoreUrl(), node.getCoreName());
            }
            catch (Exception e) {
                SolrException.log((Logger)this.log, (String)"Error syncing replica to leader", (Throwable)e);
            }
        }
        while ((srsp = this.shardHandler.takeCompletedOrError()) != null) {
            boolean success = this.handleResponse(srsp);
            if (srsp.getException() != null) {
                SolrException.log((Logger)this.log, (String)("Sync request error: " + srsp.getException()));
            }
            if (!success) {
                try {
                    this.log.info(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": Sync failed - asking replica (" + srsp.getShardAddress() + ") to recover.");
                    if (this.isClosed) {
                        this.log.info("We have been closed, don't request that a replica recover");
                        continue;
                    }
                    this.requestRecovery(leaderProps, ((ShardCoreRequest)srsp.getShardRequest()).baseUrl, ((ShardCoreRequest)srsp.getShardRequest()).coreName);
                }
                catch (Throwable t) {
                    SolrException.log((Logger)this.log, (String)(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": Could not tell a replica to recover"), (Throwable)t);
                }
                continue;
            }
            this.log.info(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": " + " sync completed with " + srsp.getShardAddress());
        }
    }

    private boolean handleResponse(ShardResponse srsp) {
        NamedList response = srsp.getSolrResponse().getResponse();
        if (response == null) {
            return false;
        }
        Boolean success = (Boolean)response.get("sync");
        if (success == null) {
            success = false;
        }
        return success;
    }

    private void requestSync(String baseUrl, String replica, String leaderUrl, String coreName) {
        ShardCoreRequest sreq = new ShardCoreRequest();
        sreq.coreName = coreName;
        sreq.baseUrl = baseUrl;
        sreq.purpose = 1;
        if (replica.startsWith("http://")) {
            replica = replica.substring(7);
        }
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams();
        sreq.params.set("qt", new String[]{"/get"});
        sreq.params.set("distrib", false);
        sreq.params.set("getVersions", new String[]{Integer.toString(100)});
        sreq.params.set("sync", new String[]{leaderUrl});
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    public void close() {
        this.isClosed = true;
        ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)this.recoveryCmdExecutor);
    }

    private void requestRecovery(final ZkNodeProps leaderProps, final String baseUrl, final String coreName) throws SolrServerException, IOException {
        Thread thread = new Thread(){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
                recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
                recoverRequestCmd.setCoreName(coreName);
                HttpSolrServer server = new HttpSolrServer(baseUrl);
                server.setConnectionTimeout(45000);
                server.setSoTimeout(45000);
                try {
                    server.request((SolrRequest)recoverRequestCmd);
                }
                catch (Throwable t) {
                    SolrException.log((Logger)SyncStrategy.this.log, (String)(ZkCoreNodeProps.getCoreUrl((ZkNodeProps)leaderProps) + ": Could not tell a replica to recover"), (Throwable)t);
                }
            }
        };
        this.recoveryCmdExecutor.execute(thread);
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    static {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 10000);
        params.set("maxConnectionsPerHost", 20);
        params.set("connTimeout", 30000);
        params.set("socketTimeout", 30000);
        params.set("retry", false);
        client = HttpClientUtil.createClient((SolrParams)params);
    }

    private static class ShardCoreRequest
    extends ShardRequest {
        String coreName;
        public String baseUrl;

        private ShardCoreRequest() {
        }
    }
}

