/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardLeaderElectionContext
extends ShardLeaderElectionContextBase {
    private static Logger log = LoggerFactory.getLogger(ShardLeaderElectionContext.class);
    private ZkController zkController;
    private CoreContainer cc;
    private SyncStrategy syncStrategy = new SyncStrategy();
    private volatile boolean isClosed = false;

    public ShardLeaderElectionContext(LeaderElector leaderElector, String shardId, String collection, String shardZkNodeName, ZkNodeProps props, ZkController zkController, CoreContainer cc) {
        super(leaderElector, shardId, collection, shardZkNodeName, props, zkController.getZkStateReader());
        this.zkController = zkController;
        this.cc = cc;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.syncStrategy.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runLeaderProcess(boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        log.info("Running the leader process.");
        String coreName = this.leaderProps.getStr("core");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "leader", "shard", this.shardId, "collection", this.collection});
        Overseer.getInQueue(this.zkClient).offer(ZkStateReader.toJSON((Object)m));
        String leaderVoteWait = this.cc.getZkController().getLeaderVoteWait();
        if (!weAreReplacement && leaderVoteWait != null) {
            this.waitForReplicasToComeUp(weAreReplacement, leaderVoteWait);
        }
        SolrCore core = null;
        try {
            core = this.cc.getCore(coreName);
            if (core == null) {
                this.cancelElection();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fatal Error, SolrCore not found:" + coreName + " in " + this.cc.getCoreNames());
            }
            if (weAreReplacement && !this.shouldIBeLeader(this.leaderProps, core)) {
                this.rejoinLeaderElection(this.leaderSeqPath, core);
                return;
            }
            log.info("I may be the new leader - try and sync");
            core.getUpdateHandler().getSolrCoreState().cancelRecovery();
            boolean success = false;
            try {
                success = this.syncStrategy.sync(this.zkController, core, this.leaderProps);
            }
            catch (Throwable t) {
                SolrException.log((Logger)log, (String)"Exception while trying to sync", (Throwable)t);
                success = false;
            }
            if (!success && !this.areAnyOtherReplicasActive(this.zkController, this.leaderProps, this.collection, this.shardId)) {
                log.info("Sync was not a success but no one else is active! I am the leader");
                success = true;
            }
            if (!success) {
                this.rejoinLeaderElection(this.leaderSeqPath, core);
                return;
            }
            log.info("I am the new leader: " + ZkCoreNodeProps.getCoreUrl((ZkNodeProps)this.leaderProps));
            core.getCoreDescriptor().getCloudDescriptor().isLeader = true;
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
        try {
            super.runLeaderProcess(weAreReplacement);
        }
        catch (Throwable t) {
            try {
                core = this.cc.getCore(coreName);
                core.getCoreDescriptor().getCloudDescriptor().isLeader = false;
                this.rejoinLeaderElection(coreName, core);
            }
            finally {
                if (core != null) {
                    core.close();
                }
            }
        }
    }

    private boolean areAnyOtherReplicasActive(ZkController zkController, ZkNodeProps leaderProps, String collection, String shardId) {
        ClusterState clusterState = zkController.getZkStateReader().getClusterState();
        Map slices = clusterState.getSlices(collection);
        Slice slice = (Slice)slices.get(shardId);
        Map replicasMap = slice.getReplicasMap();
        for (Map.Entry shard : replicasMap.entrySet()) {
            String state = ((Replica)shard.getValue()).getStr("state");
            if (!state.equals("active") || !clusterState.liveNodesContain(((Replica)shard.getValue()).getStr("node_name")) || new ZkCoreNodeProps((ZkNodeProps)shard.getValue()).getCoreUrl().equals(new ZkCoreNodeProps(leaderProps).getCoreUrl())) continue;
            return true;
        }
        return false;
    }

    private void waitForReplicasToComeUp(boolean weAreReplacement, String leaderVoteWait) throws InterruptedException {
        int timeout = Integer.parseInt(leaderVoteWait);
        long timeoutAt = System.currentTimeMillis() + (long)timeout;
        String shardsElectZkPath = this.electionPath + "/election";
        Slice slices = this.zkController.getClusterState().getSlice(this.collection, this.shardId);
        while (!this.isClosed) {
            if (slices != null) {
                int found = 0;
                try {
                    found = this.zkClient.getChildren(shardsElectZkPath, null, true).size();
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, (String)"Errir checking for the number of election participants", (Throwable)e);
                }
                if (found >= slices.getReplicasMap().size()) {
                    log.info("Enough replicas found to continue.");
                    return;
                }
                log.info("Waiting until we see more replicas up: total=" + slices.getReplicasMap().size() + " found=" + found + " timeoutin=" + (timeoutAt - System.currentTimeMillis()));
                if (System.currentTimeMillis() > timeoutAt) {
                    log.info("Was waiting for replicas to come up, but they are taking too long - assuming they won't come back till later");
                    return;
                }
            }
            Thread.sleep(500L);
            slices = this.zkController.getClusterState().getSlice(this.collection, this.shardId);
        }
    }

    private void rejoinLeaderElection(String leaderSeqPath, SolrCore core) throws InterruptedException, KeeperException, IOException {
        if (this.cc.isShutDown()) {
            log.info("Not rejoining election because CoreContainer is shutdown");
            return;
        }
        log.info("There is a better leader candidate than us - going back into recovery");
        try {
            this.zkController.publish(core.getCoreDescriptor(), "down");
        }
        catch (Throwable t) {
            SolrException.log((Logger)log, (String)"Error trying to publish down state", (Throwable)t);
        }
        this.cancelElection();
        try {
            core.getUpdateHandler().getSolrCoreState().doRecovery(this.cc, core.getName());
        }
        catch (Throwable t) {
            SolrException.log((Logger)log, (String)"Error trying to start recovery", (Throwable)t);
        }
        this.leaderElector.joinElection(this);
    }

    private boolean shouldIBeLeader(ZkNodeProps leaderProps, SolrCore core) {
        log.info("Checking if I should try and be the leader.");
        if (this.isClosed) {
            log.info("Bailing on leader process because we have been closed");
            return false;
        }
        if (core.getCoreDescriptor().getCloudDescriptor().getLastPublished().equals("active")) {
            log.info("My last published State was Active, it's okay to be the leader.");
            return true;
        }
        return false;
    }
}

