/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateLog;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryStrategy
extends Thread
implements ClosableThread {
    private static final int MAX_RETRIES = 500;
    private static final int INTERRUPTED = 501;
    private static final int STARTING_RECOVERY_DELAY = 1000;
    private static final String REPLICATION_HANDLER = "/replication";
    private static Logger log = LoggerFactory.getLogger(RecoveryStrategy.class);
    private volatile boolean close = false;
    private RecoveryListener recoveryListener;
    private ZkController zkController;
    private String baseUrl;
    private String coreZkNodeName;
    private ZkStateReader zkStateReader;
    private volatile String coreName;
    private int retries;
    private boolean recoveringAfterStartup;
    private CoreContainer cc;

    public RecoveryStrategy(CoreContainer cc, String name, RecoveryListener recoveryListener) {
        this.cc = cc;
        this.coreName = name;
        this.recoveryListener = recoveryListener;
        this.setName("RecoveryThread");
        this.zkController = cc.getZkController();
        this.zkStateReader = this.zkController.getZkStateReader();
        this.baseUrl = this.zkController.getBaseUrl();
        this.coreZkNodeName = this.zkController.getNodeName() + "_" + this.coreName;
    }

    public void setRecoveringAfterStartup(boolean recoveringAfterStartup) {
        this.recoveringAfterStartup = recoveringAfterStartup;
    }

    public void close() {
        this.close = true;
        log.warn("Stopping recovery for zkNodeName=" + this.coreZkNodeName + "core=" + this.coreName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoveryFailed(SolrCore core, ZkController zkController, String baseUrl, String shardZkNodeName, CoreDescriptor cd) throws KeeperException, InterruptedException {
        SolrException.log((Logger)log, (String)("Recovery failed - I give up. core=" + this.coreName));
        try {
            zkController.publish(cd, "recovery_failed");
        }
        finally {
            this.close();
            this.recoveryListener.failed();
        }
    }

    private void replicate(String nodeName, SolrCore core, ZkNodeProps leaderprops, String baseUrl) throws SolrServerException, IOException {
        String leaderBaseUrl = leaderprops.getStr("base_url");
        ZkCoreNodeProps leaderCNodeProps = new ZkCoreNodeProps(leaderprops);
        String leaderUrl = leaderCNodeProps.getCoreUrl();
        log.info("Attempting to replicate from " + leaderUrl + ". core=" + this.coreName);
        if (!leaderBaseUrl.equals(baseUrl)) {
            boolean success;
            ReplicationHandler replicationHandler;
            this.commitOnLeader(leaderUrl);
            SolrRequestHandler handler = core.getRequestHandler(REPLICATION_HANDLER);
            if (handler instanceof RequestHandlers.LazyRequestHandlerWrapper) {
                handler = ((RequestHandlers.LazyRequestHandlerWrapper)handler).getWrappedHandler();
            }
            if ((replicationHandler = (ReplicationHandler)handler) == null) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Skipping recovery, no /replication handler found");
            }
            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.set("masterUrl", new String[]{leaderUrl});
            if (this.isClosed()) {
                this.retries = 501;
            }
            if (!(success = replicationHandler.doFetch((SolrParams)solrParams, true))) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replication for recovery failed.");
            }
        }
    }

    private void commitOnLeader(String leaderUrl) throws SolrServerException, IOException {
        HttpSolrServer server = new HttpSolrServer(leaderUrl);
        server.setConnectionTimeout(30000);
        server.setSoTimeout(30000);
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams());
        ureq.getParams().set("commit_end_point", true);
        ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true).process((SolrServer)server);
        server.shutdown();
    }

    private void sendPrepRecoveryCmd(String leaderBaseUrl, String leaderCoreName) throws SolrServerException, IOException {
        HttpSolrServer server = new HttpSolrServer(leaderBaseUrl);
        server.setConnectionTimeout(45000);
        server.setSoTimeout(45000);
        CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
        prepCmd.setCoreName(leaderCoreName);
        prepCmd.setNodeName(this.zkController.getNodeName());
        prepCmd.setCoreNodeName(this.coreZkNodeName);
        prepCmd.setState("recovering");
        prepCmd.setCheckLive(Boolean.valueOf(true));
        prepCmd.setOnlyIfLeader(true);
        server.request((SolrRequest)prepCmd);
        server.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SolrCore core = this.cc.getCore(this.coreName);
        if (core == null) {
            SolrException.log((Logger)log, (String)("SolrCore not found - cannot recover:" + this.coreName));
            return;
        }
        try {
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
            log.info("Starting recovery process.  core=" + this.coreName + " recoveringAfterStartup=" + this.recoveringAfterStartup);
            try {
                this.doRecovery(core);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (Throwable t) {
                log.error("", t);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", t);
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
            SolrRequestInfo.clearRequestInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecovery(SolrCore core) throws KeeperException, InterruptedException {
        List<Long> recentVersions;
        boolean replayed = false;
        boolean successfulRecovery = false;
        UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            SolrException.log((Logger)log, (String)("No UpdateLog found - cannot recover. core=" + this.coreName));
            this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
            return;
        }
        boolean firstTime = true;
        UpdateLog.RecentUpdates recentUpdates = null;
        try {
            recentUpdates = ulog.getRecentUpdates();
            recentVersions = recentUpdates.getVersions(ulog.numRecordsToKeep);
        }
        catch (Throwable t) {
            SolrException.log((Logger)log, (String)("Corrupt tlog - ignoring. core=" + this.coreName), (Throwable)t);
            recentVersions = new ArrayList<Long>(0);
        }
        finally {
            if (recentUpdates != null) {
                recentUpdates.close();
            }
        }
        List<Long> startingVersions = ulog.getStartingVersions();
        if (startingVersions != null && this.recoveringAfterStartup) {
            try {
                int oldIdx;
                long firstStartingVersion;
                long l = firstStartingVersion = startingVersions.size() > 0 ? startingVersions.get(0) : 0L;
                for (oldIdx = 0; oldIdx < recentVersions.size() && recentVersions.get(oldIdx) != firstStartingVersion; ++oldIdx) {
                }
                if (oldIdx > 0) {
                    log.info("####### Found new versions added after startup: num=" + oldIdx);
                    log.info("###### currentVersions=" + recentVersions);
                }
                log.info("###### startupVersions=" + startingVersions);
            }
            catch (Throwable t) {
                SolrException.log((Logger)log, (String)("Error getting recent versions. core=" + this.coreName), (Throwable)t);
                recentVersions = new ArrayList<Long>(0);
            }
        }
        if (this.recoveringAfterStartup) {
            recentVersions = startingVersions;
            try {
                if ((ulog.getStartingOperation() & 0x10) != 0) {
                    log.info("Looks like a previous replication recovery did not complete - skipping peer sync. core=" + this.coreName);
                    firstTime = false;
                }
            }
            catch (Throwable t) {
                SolrException.log((Logger)log, (String)("Error trying to get ulog starting operation. core=" + this.coreName), (Throwable)t);
                firstTime = false;
            }
        }
        while (!successfulRecovery && !this.isInterrupted()) {
            try {
                CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
                ZkNodeProps leaderprops = this.zkStateReader.getLeaderProps(cloudDesc.getCollectionName(), cloudDesc.getShardId());
                String leaderBaseUrl = leaderprops.getStr("base_url");
                String leaderCoreName = leaderprops.getStr("core");
                String leaderUrl = ZkCoreNodeProps.getCoreUrl((String)leaderBaseUrl, (String)leaderCoreName);
                String ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.baseUrl, (String)this.coreName);
                boolean isLeader = leaderUrl.equals(ourUrl);
                if (isLeader && !cloudDesc.isLeader) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cloud state still says we are leader.");
                }
                if (cloudDesc.isLeader) {
                    log.warn("We have not yet recovered - but we are now the leader! core=" + this.coreName);
                    log.info("Finished recovery process. core=" + this.coreName);
                    this.zkController.publish(core.getCoreDescriptor(), "active");
                    return;
                }
                this.zkController.publish(core.getCoreDescriptor(), "recovering");
                if (firstTime) {
                    firstTime = false;
                    log.info("Attempting to PeerSync from " + leaderUrl + " core=" + this.coreName + " - recoveringAfterStartup=" + this.recoveringAfterStartup);
                    PeerSync peerSync = new PeerSync(core, Collections.singletonList(leaderUrl), ulog.numRecordsToKeep);
                    peerSync.setStartingVersions(recentVersions);
                    boolean syncSuccess = peerSync.sync();
                    if (syncSuccess) {
                        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
                        core.getUpdateHandler().commit(new CommitUpdateCommand(req, false));
                        log.info("PeerSync Recovery was successful - registering as Active. core=" + this.coreName);
                        this.zkController.publish(core.getCoreDescriptor(), "active");
                        successfulRecovery = true;
                        this.close = true;
                        return;
                    }
                    log.info("PeerSync Recovery was not successful - trying replication. core=" + this.coreName);
                }
                log.info("Starting Replication Recovery. core=" + this.coreName);
                this.sendPrepRecoveryCmd(leaderBaseUrl, leaderCoreName);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                log.info("Begin buffering updates. core=" + this.coreName);
                ulog.bufferUpdates();
                replayed = false;
                try {
                    this.replicate(this.zkController.getNodeName(), core, leaderprops, leaderUrl);
                    this.replay(ulog);
                    replayed = true;
                    log.info("Replication Recovery was successful - registering as Active. core=" + this.coreName);
                    this.zkController.publish(core.getCoreDescriptor(), "active");
                    this.close = true;
                    successfulRecovery = true;
                    this.recoveryListener.recovered();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Recovery was interrupted", (Throwable)e);
                    this.retries = 501;
                }
                catch (Throwable t) {
                    SolrException.log((Logger)log, (String)"Error while trying to recover", (Throwable)t);
                }
                finally {
                    if (!replayed) {
                        try {
                            ulog.dropBufferedUpdates();
                        }
                        catch (Throwable t) {
                            SolrException.log((Logger)log, (String)"", (Throwable)t);
                        }
                    }
                }
            }
            catch (Throwable t) {
                SolrException.log((Logger)log, (String)("Error while trying to recover. core=" + this.coreName), (Throwable)t);
            }
            if (successfulRecovery) continue;
            try {
                log.error("Recovery failed - trying again... core=" + this.coreName);
                if (this.isClosed()) {
                    this.retries = 501;
                }
                ++this.retries;
                if (this.retries >= 500) {
                    if (this.retries == 501) {
                        SolrException.log((Logger)log, (String)("Recovery failed - interrupted. core=" + this.coreName));
                        try {
                            this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
                        }
                        catch (Throwable t) {
                            SolrException.log((Logger)log, (String)"Could not publish that recovery failed", (Throwable)t);
                        }
                        break;
                    }
                    SolrException.log((Logger)log, (String)("Recovery failed - max retries exceeded. core=" + this.coreName));
                    try {
                        this.recoveryFailed(core, this.zkController, this.baseUrl, this.coreZkNodeName, core.getCoreDescriptor());
                    }
                    catch (Throwable t) {
                        SolrException.log((Logger)log, (String)"Could not publish that recovery failed", (Throwable)t);
                    }
                    break;
                }
            }
            catch (Throwable e) {
                SolrException.log((Logger)log, (String)("core=" + this.coreName), (Throwable)e);
            }
            try {
                double loopCount = Math.min(Math.pow(2.0, this.retries), 600.0);
                int i = 0;
                while ((double)i < loopCount && !this.isClosed()) {
                    Thread.sleep(1000L);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Recovery was interrupted. core=" + this.coreName, (Throwable)e);
                this.retries = 501;
            }
        }
        log.info("Finished recovery process. core=" + this.coreName);
    }

    private Future<UpdateLog.RecoveryInfo> replay(UpdateLog ulog) throws InterruptedException, ExecutionException {
        Future<UpdateLog.RecoveryInfo> future = ulog.applyBufferedUpdates();
        if (future == null) {
            log.info("No replay needed. core=" + this.coreName);
        } else {
            log.info("Replaying buffered documents. core=" + this.coreName);
            UpdateLog.RecoveryInfo report = future.get();
            if (report.failed) {
                SolrException.log((Logger)log, (String)"Replay failed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
            }
        }
        return future;
    }

    public boolean isClosed() {
        return this.close;
    }

    public static interface RecoveryListener {
        public void recovered();

        public void failed();
    }
}

