/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionProcessor
implements Runnable {
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String DELETECOLLECTION = "deletecollection";
    public static final String CREATECOLLECTION = "createcollection";
    public static final String RELOADCOLLECTION = "reloadcollection";
    private static final String QUEUE_OPERATION = "operation";
    private static Logger log = LoggerFactory.getLogger(OverseerCollectionProcessor.class);
    private DistributedQueue workQueue;
    private String myId;
    private ShardHandler shardHandler;
    private String adminPath;
    private ZkStateReader zkStateReader;
    private boolean isClosed;

    public OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
        this.workQueue = Overseer.getCollectionQueue(zkStateReader.getZkClient());
    }

    @Override
    public void run() {
        log.info("Process current queue of collection creations");
        while (this.amILeader() && !this.isClosed) {
            try {
                byte[] head = this.workQueue.peek(true);
                ZkNodeProps message = ZkNodeProps.load((byte[])head);
                String operation = message.getStr(QUEUE_OPERATION);
                boolean success = this.processMessage(message, operation);
                if (!success) {
                    SolrException.log((Logger)log, (String)("Collection creation of " + message.getStr("name") + " failed"));
                }
                this.workQueue.remove();
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.warn("Overseer cannot talk to ZK");
                    return;
                }
                SolrException.log((Logger)log, (String)"", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public void close() {
        this.isClosed = true;
    }

    private boolean amILeader() {
        try {
            ZkNodeProps props = ZkNodeProps.load((byte[])this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            if (this.myId.equals(props.getStr("id"))) {
                return true;
            }
        }
        catch (KeeperException e) {
            log.warn("", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
        return false;
    }

    private boolean processMessage(ZkNodeProps message, String operation) {
        if (CREATECOLLECTION.equals(operation)) {
            return this.createCollection(this.zkStateReader.getClusterState(), message);
        }
        if (DELETECOLLECTION.equals(operation)) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteInstanceDir", true);
            return this.collectionCmd(this.zkStateReader.getClusterState(), message, params);
        }
        if (RELOADCOLLECTION.equals(operation)) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
            return this.collectionCmd(this.zkStateReader.getClusterState(), message, params);
        }
        return true;
    }

    private boolean createCollection(ClusterState clusterState, ZkNodeProps message) {
        ShardResponse srsp;
        int numShards;
        int numReplicas;
        String numReplicasString = message.getStr(REPLICATION_FACTOR);
        try {
            numReplicas = numReplicasString == null ? 0 : Integer.parseInt(numReplicasString);
        }
        catch (Exception ex) {
            SolrException.log((Logger)log, (String)"Could not parse replicationFactor", (Throwable)ex);
            return false;
        }
        String numShardsString = message.getStr("numShards");
        try {
            numShards = numShardsString == null ? 0 : Integer.parseInt(numShardsString);
        }
        catch (Exception ex) {
            SolrException.log((Logger)log, (String)"Could not parse numShards", (Throwable)ex);
            return false;
        }
        String name = message.getStr("name");
        String configName = message.getStr("collection.configName");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
        Set nodes = clusterState.getLiveNodes();
        ArrayList nodeList = new ArrayList(nodes.size());
        nodeList.addAll(nodes);
        Collections.shuffle(nodeList);
        int numNodes = numShards * (numReplicas + 1);
        List createOnNodes = nodeList.subList(0, Math.min(nodeList.size(), numNodes));
        log.info("Create collection " + name + " on " + createOnNodes);
        for (String replica : createOnNodes) {
            replica = replica.replaceAll("_", "/");
            params.set("name", new String[]{name});
            params.set("collection.configName", new String[]{configName});
            params.set("numShards", numShards);
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{this.adminPath});
            sreq.purpose = 1;
            if (replica.startsWith("http://")) {
                replica = replica.substring(7);
            }
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            this.shardHandler.submit(sreq, replica, sreq.params);
        }
        int failed = 0;
        do {
            Throwable e;
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null || (e = srsp.getException()) == null) continue;
            ++failed;
            log.error("Error talking to shard: " + srsp.getShard(), e);
        } while (srsp != null);
        return failed <= 0;
    }

    private boolean collectionCmd(ClusterState clusterState, ZkNodeProps message, ModifiableSolrParams params) {
        ShardResponse srsp;
        log.info("Executing Collection Cmd : " + params);
        String name = message.getStr("name");
        Map slices = (Map)clusterState.getCollectionStates().get(name);
        if (slices == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection:" + name);
        }
        for (Map.Entry entry : slices.entrySet()) {
            Slice slice = (Slice)entry.getValue();
            Map shards = slice.getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                ZkNodeProps node = (ZkNodeProps)shardEntry.getValue();
                if (!clusterState.liveNodesContain(node.getStr("node_name"))) continue;
                params.set("core", new String[]{node.getStr("core")});
                String replica = node.getStr("base_url");
                ShardRequest sreq = new ShardRequest();
                params.set("qt", new String[]{this.adminPath});
                sreq.purpose = 1;
                if (replica.startsWith("http://")) {
                    replica = replica.substring(7);
                }
                sreq.shards = new String[]{replica};
                sreq.actualShards = sreq.shards;
                sreq.params = params;
                log.info("Collection Admin sending CoreAdmin cmd to " + replica);
                this.shardHandler.submit(sreq, replica, sreq.params);
            }
        }
        int failed = 0;
        do {
            Throwable e;
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null || (e = srsp.getException()) == null) continue;
            ++failed;
            log.error("Error talking to shard: " + srsp.getShard(), e);
        } while (srsp != null);
        return failed <= 0;
    }
}

