/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.AssignShard;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.OverseerCollectionProcessor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.HashPartitioner;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overseer {
    public static final String QUEUE_OPERATION = "operation";
    private static final int STATE_UPDATE_DELAY = 500;
    private static Logger log = LoggerFactory.getLogger(Overseer.class);
    private OverseerThread ccThread;
    private OverseerThread updaterThread;
    private volatile boolean isClosed;
    private ZkStateReader reader;
    private ShardHandler shardHandler;
    private String adminPath;

    public Overseer(ShardHandler shardHandler, String adminPath, ZkStateReader reader) throws KeeperException, InterruptedException {
        this.reader = reader;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
    }

    public void start(String id) {
        log.info("Overseer (id=" + id + ") starting");
        Overseer.createOverseerNode(this.reader.getZkClient());
        ThreadGroup tg = new ThreadGroup("Overseer state updater.");
        this.updaterThread = new OverseerThread(tg, new ClusterStateUpdater(this.reader, id));
        this.updaterThread.setDaemon(true);
        ThreadGroup ccTg = new ThreadGroup("Overseer collection creation process.");
        this.ccThread = new OverseerThread(ccTg, new OverseerCollectionProcessor(this.reader, id, this.shardHandler, this.adminPath), "Overseer-" + id);
        this.ccThread.setDaemon(true);
        this.updaterThread.start();
        this.ccThread.start();
    }

    public void close() {
        this.isClosed = true;
        if (this.updaterThread != null) {
            this.updaterThread.close();
            this.updaterThread.interrupt();
        }
        if (this.ccThread != null) {
            this.ccThread.close();
            this.ccThread.interrupt();
        }
    }

    public static DistributedQueue getInQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue", null);
    }

    static DistributedQueue getInternalQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue-work", null);
    }

    static DistributedQueue getCollectionQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/collection-queue-work", null);
    }

    private static void createOverseerNode(SolrZkClient zkClient) {
        try {
            zkClient.create("/overseer", new byte[0], CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
        }
        catch (InterruptedException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    class OverseerThread
    extends Thread
    implements ClosableThread {
        private volatile boolean isClosed;

        public OverseerThread(ThreadGroup tg, ClusterStateUpdater clusterStateUpdater) {
            super(tg, clusterStateUpdater);
        }

        public OverseerThread(ThreadGroup ccTg, OverseerCollectionProcessor overseerCollectionProcessor, String string) {
            super(ccTg, overseerCollectionProcessor, string);
        }

        public void close() {
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }

    private class ClusterStateUpdater
    implements Runnable,
    ClosableThread {
        private static final String DELETECORE = "deletecore";
        private final ZkStateReader reader;
        private final SolrZkClient zkClient;
        private final String myId;
        private final DistributedQueue stateUpdateQueue;
        private final DistributedQueue workQueue;
        private volatile boolean isClosed;

        public ClusterStateUpdater(ZkStateReader reader, String myId) {
            this.zkClient = reader.getZkClient();
            this.stateUpdateQueue = Overseer.getInQueue(this.zkClient);
            this.workQueue = Overseer.getInternalQueue(this.zkClient);
            this.myId = myId;
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String operation;
            ZkNodeProps message;
            ClusterState clusterState;
            byte[] head;
            Object object;
            if (!this.isClosed && this.amILeader()) {
                object = this.reader.getUpdateLock();
                synchronized (object) {
                    try {
                        head = this.workQueue.peek();
                        if (head != null) {
                            this.reader.updateClusterState(true);
                            clusterState = this.reader.getClusterState();
                            log.info("Replaying operations from work queue.");
                            while (head != null && this.amILeader()) {
                                message = ZkNodeProps.load((byte[])head);
                                operation = message.getStr(Overseer.QUEUE_OPERATION);
                                clusterState = this.processMessage(clusterState, message, operation);
                                this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON((Object)clusterState), true);
                                this.workQueue.remove();
                                head = this.workQueue.peek();
                            }
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("Solr cannot talk to ZK");
                            return;
                        }
                        SolrException.log((Logger)log, (String)"", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            log.info("Starting to work on the main queue");
            while (!this.isClosed && this.amILeader()) {
                object = this.reader.getUpdateLock();
                synchronized (object) {
                    try {
                        head = this.stateUpdateQueue.peek();
                        if (head != null) {
                            this.reader.updateClusterState(true);
                            clusterState = this.reader.getClusterState();
                            while (head != null) {
                                message = ZkNodeProps.load((byte[])head);
                                operation = message.getStr(Overseer.QUEUE_OPERATION);
                                clusterState = this.processMessage(clusterState, message, operation);
                                this.workQueue.offer(head);
                                this.stateUpdateQueue.remove();
                                head = this.stateUpdateQueue.peek();
                            }
                            this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON((Object)clusterState), true);
                        }
                        while (this.workQueue.poll() != null) {
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("Overseer cannot talk to ZK");
                            return;
                        }
                        SolrException.log((Logger)log, (String)"", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private ClusterState processMessage(ClusterState clusterState, ZkNodeProps message, String operation) {
            if ("state".equals(operation)) {
                clusterState = this.updateState(clusterState, message);
            } else if (DELETECORE.equals(operation)) {
                clusterState = this.removeCore(clusterState, message);
            } else if ("leader".equals(operation)) {
                StringBuilder sb = new StringBuilder();
                String baseUrl = message.getStr("base_url");
                String coreName = message.getStr("core");
                sb.append(baseUrl);
                if (baseUrl != null && !baseUrl.endsWith("/")) {
                    sb.append("/");
                }
                sb.append(coreName == null ? "" : coreName);
                if (!sb.substring(sb.length() - 1).equals("/")) {
                    sb.append("/");
                }
                clusterState = this.setShardLeader(clusterState, message.getStr("collection"), message.getStr("shard"), sb.length() > 0 ? sb.toString() : null);
            } else {
                throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
            }
            return clusterState;
        }

        private boolean amILeader() {
            try {
                ZkNodeProps props = ZkNodeProps.load((byte[])this.zkClient.getData("/overseer_elect/leader", null, null, true));
                if (this.myId.equals(props.getStr("id"))) {
                    return true;
                }
            }
            catch (KeeperException e) {
                log.warn("", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
            return false;
        }

        private ClusterState updateState(ClusterState state, ZkNodeProps message) {
            Map<String, Replica> replicas;
            Replica oldReplica;
            String sliceName;
            Integer numShards;
            String collection = message.getStr("collection");
            String zkCoreNodeName = message.getStr("node_name") + "_" + message.getStr("core");
            Integer n = numShards = message.getStr("numShards") != null ? Integer.valueOf(Integer.parseInt(message.getStr("numShards"))) : null;
            if (!state.getCollections().contains(collection) && numShards != null) {
                state = this.createCollection(state, collection, numShards);
            }
            if ((sliceName = message.getStr("shard")) == null) {
                String nodeName = message.getStr("node_name");
                sliceName = this.getAssignedId(state, nodeName, message);
            }
            if (sliceName == null) {
                sliceName = AssignShard.assignShard(collection, state, numShards);
            }
            Slice slice = state.getSlice(collection, sliceName);
            LinkedHashMap<String, Object> replicaProps = new LinkedHashMap<String, Object>();
            replicaProps.putAll(message.getProperties());
            if (slice != null && (oldReplica = (Replica)slice.getReplicasMap().get(zkCoreNodeName)) != null && oldReplica.containsKey("leader")) {
                replicaProps.put("leader", oldReplica.get("leader"));
            }
            replicaProps.remove("numShards");
            replicaProps.remove(Overseer.QUEUE_OPERATION);
            Replica replica = new Replica(zkCoreNodeName, replicaProps);
            Map sliceProps = null;
            if (slice != null) {
                sliceProps = slice.getProperties();
                replicas = slice.getReplicasCopy();
            } else {
                replicas = new HashMap(1);
            }
            replicas.put(replica.getName(), replica);
            slice = new Slice(sliceName, replicas, sliceProps);
            ClusterState newClusterState = this.updateSlice(state, collection, slice);
            return newClusterState;
        }

        private ClusterState createCollection(ClusterState state, String collectionName, int numShards) {
            HashPartitioner hp = new HashPartitioner();
            List ranges = hp.partitionRange(numShards, hp.fullRange());
            LinkedHashMap newStates = new LinkedHashMap();
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
            newStates.putAll(state.getCollectionStates());
            for (int i = 0; i < numShards; ++i) {
                String sliceName = "shard" + (i + 1);
                LinkedHashMap sliceProps = new LinkedHashMap(1);
                sliceProps.put(Slice.RANGE, ranges.get(i));
                newSlices.put(sliceName, new Slice(sliceName, null, sliceProps));
            }
            newStates.put(collectionName, newSlices);
            ClusterState newClusterState = new ClusterState(state.getLiveNodes(), newStates);
            return newClusterState;
        }

        private String getAssignedId(ClusterState state, String nodeName, ZkNodeProps coreState) {
            String key = coreState.getStr("node_name") + "_" + coreState.getStr("core");
            Map slices = state.getSlices(coreState.getStr("collection"));
            if (slices != null) {
                for (Slice slice : slices.values()) {
                    if (slice.getReplicasMap().get(key) == null) continue;
                    return slice.getName();
                }
            }
            return null;
        }

        private ClusterState updateSlice(ClusterState state, String collection, Slice slice) {
            LinkedHashMap newCollections = new LinkedHashMap(state.getCollectionStates());
            HashMap<String, Object> slices = (HashMap<String, Slice>)newCollections.get(collection);
            slices = slices == null ? new HashMap<String, Slice>(1) : new LinkedHashMap(slices);
            slices.put(slice.getName(), slice);
            newCollections.put(collection, slices);
            return new ClusterState(state.getLiveNodes(), newCollections);
        }

        private ClusterState setShardLeader(ClusterState state, String collection, String sliceName, String leaderUrl) {
            LinkedHashMap newStates = new LinkedHashMap(state.getCollectionStates());
            LinkedHashMap<String, Slice> slices = (LinkedHashMap<String, Slice>)newStates.get(collection);
            if (slices == null) {
                log.error("Could not mark shard leader for non existing collection:" + collection);
                return state;
            }
            slices = new LinkedHashMap<String, Slice>(slices);
            newStates.put(collection, slices);
            Slice slice = (Slice)slices.get(sliceName);
            if (slice == null) {
                log.error("Could not mark leader for non existing slice:" + sliceName);
                return state;
            }
            Replica oldLeader = slice.getLeader();
            LinkedHashMap<String, Replica> newReplicas = new LinkedHashMap<String, Replica>();
            for (Replica replica : slice.getReplicas()) {
                LinkedHashMap<String, String> replicaProps;
                String coreURL = ZkCoreNodeProps.getCoreUrl((String)replica.getStr("base_url"), (String)replica.getStr("core"));
                if (replica == oldLeader && !coreURL.equals(leaderUrl)) {
                    replicaProps = new LinkedHashMap<String, String>(replica.getProperties());
                    replicaProps.remove(Slice.LEADER);
                    replica = new Replica(replica.getName(), replicaProps);
                } else if (coreURL.equals(leaderUrl)) {
                    replicaProps = new LinkedHashMap(replica.getProperties());
                    replicaProps.put(Slice.LEADER, "true");
                    replica = new Replica(replica.getName(), replicaProps);
                }
                newReplicas.put(replica.getName(), replica);
            }
            Map newSliceProps = slice.shallowCopy();
            newSliceProps.put(Slice.REPLICAS, newReplicas);
            Slice newSlice = new Slice(slice.getName(), newReplicas, slice.getProperties());
            slices.put(newSlice.getName(), newSlice);
            return new ClusterState(state.getLiveNodes(), newStates);
        }

        private ClusterState removeCore(ClusterState clusterState, ZkNodeProps message) {
            String coreNodeName = message.getStr("node_name") + "_" + message.getStr("core");
            String collection = message.getStr("collection");
            LinkedHashMap<String, Map> newStates = new LinkedHashMap<String, Map>();
            for (String collectionName : clusterState.getCollections()) {
                if (collection.equals(collectionName)) {
                    Map slices = clusterState.getSlices(collection);
                    LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
                    for (Slice slice : slices.values()) {
                        if (slice.getReplicasMap().containsKey(coreNodeName)) {
                            Map newReplicas = slice.getReplicasCopy();
                            newReplicas.remove(coreNodeName);
                            Slice newSlice = new Slice(slice.getName(), newReplicas, slice.getProperties());
                            newSlices.put(slice.getName(), newSlice);
                            continue;
                        }
                        newSlices.put(slice.getName(), slice);
                    }
                    int cnt = 0;
                    for (Slice slice : newSlices.values()) {
                        cnt += slice.getReplicasMap().size();
                    }
                    if (cnt > 0) {
                        newStates.put(collectionName, newSlices);
                        continue;
                    }
                    try {
                        this.zkClient.clean("/collections/" + collectionName);
                    }
                    catch (InterruptedException e) {
                        SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collectionName), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (KeeperException e) {
                        SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collectionName), (Throwable)e);
                    }
                    continue;
                }
                newStates.put(collectionName, clusterState.getSlices(collectionName));
            }
            ClusterState newState = new ClusterState(clusterState.getLiveNodes(), newStates);
            return newState;
        }

        public void close() {
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

