/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SimplePostTool {
    public static final String DEFAULT_POST_URL = "http://localhost:8983/solr/update";
    public static final String VERSION_OF_THIS_TOOL = "1.5";
    private static final String DEFAULT_COMMIT = "yes";
    private static final String DEFAULT_OPTIMIZE = "no";
    private static final String DEFAULT_OUT = "no";
    private static final String DEFAULT_AUTO = "no";
    private static final String DEFAULT_RECURSIVE = "no";
    private static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private static final String DEFAULT_FILE_TYPES = "xml,json,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log";
    private static final String DATA_MODE_FILES = "files";
    private static final String DATA_MODE_ARGS = "args";
    private static final String DATA_MODE_STDIN = "stdin";
    private static final String DEFAULT_DATA_MODE = "files";
    private static final String TRUE_STRINGS = "true,on,yes,1";
    private boolean auto = false;
    private boolean recursive = false;
    private String fileTypes;
    private static HashMap<String, String> mimeMap;
    private GlobFileFilter globFileFilter;
    private static final Set<String> DATA_MODES;
    private static final String USAGE_STRING_SHORT = "Usage: java [SystemProperties] -jar post.jar [-h|-] [<file|folder|arg> [<file|folder|arg>...]]";
    protected URL solrUrl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String mode;
        SimplePostTool.info("SimplePostTool version 1.5");
        if (0 < args.length && ("-help".equals(args[0]) || "--help".equals(args[0]) || "-h".equals(args[0]))) {
            SimplePostTool.usage();
            return;
        }
        PrintStream out = null;
        String type = System.getProperty("type");
        String params = System.getProperty("params", "");
        URL u = null;
        try {
            u = new URL(System.getProperty("url", SimplePostTool.appendParam(DEFAULT_POST_URL, params)));
        }
        catch (MalformedURLException e) {
            SimplePostTool.fatal("System Property 'url' is not a valid URL: " + u);
        }
        SimplePostTool t = new SimplePostTool(u);
        if (SimplePostTool.isOn(System.getProperty("auto", "no"))) {
            t.setAuto(true);
        }
        if (SimplePostTool.isOn(System.getProperty("recursive", "no"))) {
            t.setRecursive(true);
        }
        if (!DATA_MODES.contains(mode = System.getProperty("data", "files"))) {
            SimplePostTool.fatal("System Property 'data' is not valid for this tool: " + mode);
        }
        if (SimplePostTool.isOn(System.getProperty("out", "no"))) {
            out = System.out;
        }
        t.setFileTypes(System.getProperty("filetypes", DEFAULT_FILE_TYPES));
        int numFilesPosted = 0;
        try {
            if ("files".equals(mode)) {
                if (0 >= args.length) {
                    SimplePostTool.usageShort();
                    return;
                }
                if (!args[0].equals("-")) {
                    SimplePostTool.info("Posting files to base url " + u + (!t.auto ? " using content-type " + (type == null ? DEFAULT_CONTENT_TYPE : type) : "") + "..");
                    if (t.auto) {
                        SimplePostTool.info("Entering auto mode. File endings considered are " + t.getFileTypes());
                    }
                    if (t.recursive) {
                        SimplePostTool.info("Entering recursive mode");
                    }
                    numFilesPosted = t.postFiles(args, 0, out, type);
                    SimplePostTool.info(numFilesPosted + " files indexed.");
                }
            } else if (DATA_MODE_ARGS.equals(mode)) {
                if (0 >= args.length) {
                    SimplePostTool.usageShort();
                    return;
                }
                SimplePostTool.info("POSTing args to " + u + "..");
                for (String a : args) {
                    t.postData(SimplePostTool.stringToStream(a), null, out, type);
                }
            } else if (DATA_MODE_STDIN.equals(mode)) {
                SimplePostTool.info("POSTing stdin to " + u + "..");
                t.postData(System.in, null, out, type);
            }
            if (SimplePostTool.isOn(System.getProperty("commit", DEFAULT_COMMIT))) {
                SimplePostTool.info("COMMITting Solr index changes to " + u + "..");
                t.commit();
            }
            if (!SimplePostTool.isOn(System.getProperty("optimize", "no"))) return;
            SimplePostTool.info("Performing an OPTIMIZE to " + u + "..");
            t.optimize();
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            SimplePostTool.fatal("RuntimeException " + e);
        }
    }

    private static void usageShort() {
        System.out.println("Usage: java [SystemProperties] -jar post.jar [-h|-] [<file|folder|arg> [<file|folder|arg>...]]\n       Please invoke with -h option for extended usage help.");
    }

    private static void usage() {
        System.out.println("Usage: java [SystemProperties] -jar post.jar [-h|-] [<file|folder|arg> [<file|folder|arg>...]]\n\nSupported System Properties and their defaults:\n  -Ddata=files|args|stdin (default=files)\n  -Dtype=<content-type> (default=application/xml)\n  -Durl=<solr-update-url> (default=http://localhost:8983/solr/update)\n  -Dauto=yes|no (default=no)\n  -Drecursive=yes|no (default=no)\n  -Dfiletypes=<type>[,<type>,...] (default=xml,json,csv,pdf,doc,docx,ppt,pptx,xls,xlsx,odt,odp,ods,ott,otp,ots,rtf,htm,html,txt,log)\n  -Dparams=\"<key>=<value>[&<key>=<value>...]\" (values must be URL-encoded)\n  -Dcommit=yes|no (default=yes)\n  -Doptimize=yes|no (default=no)\n  -Dout=yes|no (default=no)\n\nThis is a simple command line tool for POSTing raw data to a Solr\nport.  Data can be read from files specified as commandline args,\nas raw commandline arg strings, or via STDIN.\nExamples:\n  java -jar post.jar *.xml\n  java -Ddata=args  -jar post.jar '<delete><id>42</id></delete>'\n  java -Ddata=stdin -jar post.jar < hd.xml\n  java -Dtype=text/csv -jar post.jar *.csv\n  java -Dtype=application/json -jar post.jar *.json\n  java -Durl=http://localhost:8983/solr/update/extract -Dparams=literal.id=a -Dtype=application/pdf -jar post.jar a.pdf\n  java -Dauto -jar post.jar *\n  java -Dauto -Drecursive -jar post.jar afolder\n  java -Dauto -Dfiletypes=ppt,html -jar post.jar afolder\nThe options controlled by System Properties include the Solr\nURL to POST to, the Content-Type of the data, whether a commit\nor optimize should be executed, and whether the response should\nbe written to STDOUT. If auto=yes the tool will try to set type\nand url automatically from file name. When posting rich documents\nthe file name will be propagated as \"resource.name\" and also used as \"literal.id\".\nYou may override these or any other request parameter through the -Dparams property.\nIf you want to do a commit only, use \"-\" as argument.");
    }

    private static boolean isOn(String property) {
        return TRUE_STRINGS.indexOf(property) >= 0;
    }

    int postFiles(String[] args, int startIndexInArgs, OutputStream out, String type) {
        int filesPosted = 0;
        for (int j = startIndexInArgs; j < args.length; ++j) {
            String fileGlob;
            GlobFileFilter ff;
            File[] files;
            File srcFile = new File(args[j]);
            if (srcFile.isDirectory() && srcFile.canRead()) {
                filesPosted += this.postDirectory(srcFile, out, type);
                continue;
            }
            if (srcFile.isFile() && srcFile.canRead()) {
                filesPosted += this.postFiles(new File[]{srcFile}, out, type);
                continue;
            }
            File parent = srcFile.getParentFile();
            if (parent == null) {
                parent = new File(".");
            }
            if ((files = parent.listFiles(ff = new GlobFileFilter(fileGlob = srcFile.getName(), false))).length == 0) {
                SimplePostTool.warn("No files or directories matching " + srcFile);
                continue;
            }
            filesPosted += this.postFiles(parent.listFiles(ff), out, type);
        }
        return filesPosted;
    }

    private int postDirectory(File dir, OutputStream out, String type) {
        if (dir.isHidden() && !dir.getName().equals(".")) {
            return 0;
        }
        SimplePostTool.info("Indexing directory " + dir.getPath());
        int posted = 0;
        posted += this.postFiles(dir.listFiles(this.globFileFilter), out, type);
        if (this.recursive) {
            for (File d : dir.listFiles()) {
                if (!d.isDirectory()) continue;
                posted += this.postDirectory(d, out, type);
            }
        }
        return posted;
    }

    int postFiles(File[] files, OutputStream out, String type) {
        int filesPosted = 0;
        for (File srcFile : files) {
            if (!srcFile.isFile() || srcFile.isHidden()) continue;
            this.postFile(srcFile, out, type);
            ++filesPosted;
        }
        return filesPosted;
    }

    static void warn(String msg) {
        System.err.println("SimplePostTool: WARNING: " + msg);
    }

    static void info(String msg) {
        System.out.println(msg);
    }

    static void fatal(String msg) {
        System.err.println("SimplePostTool: FATAL: " + msg);
        System.exit(1);
    }

    public SimplePostTool(URL solrUrl) {
        this.solrUrl = solrUrl;
    }

    public void commit() {
        SimplePostTool.doGet(SimplePostTool.appendParam(this.solrUrl.toString(), "commit=true"));
    }

    public void optimize() {
        SimplePostTool.doGet(SimplePostTool.appendParam(this.solrUrl.toString(), "optimize=true"));
    }

    public static String appendParam(String url, String param) {
        String[] pa;
        for (String p : pa = param.split("&")) {
            if (p.trim().length() == 0) continue;
            String[] kv = p.split("=");
            if (kv.length == 2) {
                url = url + (url.indexOf(63) > 0 ? "&" : "?") + kv[0] + "=" + kv[1];
                continue;
            }
            SimplePostTool.warn("Skipping param " + p + " which is not on form key=value");
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postFile(File file, OutputStream output, String type) {
        InputStream is = null;
        try {
            URL url = this.solrUrl;
            if (this.auto) {
                if (type == null) {
                    type = this.guessType(file);
                }
                if (type == null) {
                    SimplePostTool.warn("Skipping " + file.getName() + ". Unsupported file type for auto mode.");
                    return;
                }
                if (!(type.equals("text/xml") || type.equals("text/csv") || type.equals("application/json"))) {
                    String urlStr = url.getProtocol() + "://" + url.getAuthority() + url.getPath() + "/extract" + (url.getQuery() != null ? "?" + url.getQuery() : "");
                    if (urlStr.indexOf("resource.name") == -1) {
                        urlStr = SimplePostTool.appendParam(urlStr, "resource.name=" + URLEncoder.encode(file.getAbsolutePath(), "UTF-8"));
                    }
                    if (urlStr.indexOf("literal.id") == -1) {
                        urlStr = SimplePostTool.appendParam(urlStr, "literal.id=" + URLEncoder.encode(file.getAbsolutePath(), "UTF-8"));
                    }
                    url = new URL(urlStr);
                }
            } else if (type == null) {
                type = DEFAULT_CONTENT_TYPE;
            }
            SimplePostTool.info("POSTing file " + file.getName() + (this.auto ? " (" + type + ")" : ""));
            is = new FileInputStream(file);
            this.postData(is, (int)file.length(), output, type, url);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            SimplePostTool.warn("Can't open/read file: " + file);
            return;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                SimplePostTool.fatal("IOException while closing file: " + e);
            }
        }
    }

    private String guessType(File file) {
        String name = file.getName();
        String suffix = name.substring(name.lastIndexOf(".") + 1);
        return mimeMap.get(suffix.toLowerCase(Locale.ROOT));
    }

    public static void doGet(String url) {
        try {
            SimplePostTool.doGet(new URL(url));
        }
        catch (MalformedURLException e) {
            SimplePostTool.warn("The specified URL " + url + " is not a valid URL. Please check");
        }
    }

    public static void doGet(URL url) {
        try {
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            if (200 != urlc.getResponseCode()) {
                SimplePostTool.warn("Solr returned an error #" + urlc.getResponseCode() + " " + urlc.getResponseMessage() + " for url " + url);
            }
        }
        catch (IOException e) {
            SimplePostTool.warn("An error occured posting data to " + url + ". Please check that Solr is running.");
        }
    }

    public void postData(InputStream data, Integer length, OutputStream output, String type) {
        this.postData(data, length, output, type, this.solrUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postData(InputStream data, Integer length, OutputStream output, String type, URL url) {
        if (type == null) {
            type = DEFAULT_CONTENT_TYPE;
        }
        HttpURLConnection urlc = null;
        try {
            try {
                urlc = (HttpURLConnection)url.openConnection();
                try {
                    urlc.setRequestMethod("POST");
                }
                catch (ProtocolException e) {
                    SimplePostTool.fatal("Shouldn't happen: HttpURLConnection doesn't support POST??" + e);
                }
                urlc.setDoOutput(true);
                urlc.setDoInput(true);
                urlc.setUseCaches(false);
                urlc.setAllowUserInteraction(false);
                urlc.setRequestProperty("Content-type", type);
                if (null != length) {
                    urlc.setFixedLengthStreamingMode(length);
                }
            }
            catch (IOException e) {
                SimplePostTool.fatal("Connection error (is Solr running at " + this.solrUrl + " ?): " + e);
            }
            OutputStream out = null;
            try {
                out = urlc.getOutputStream();
                SimplePostTool.pipe(data, out);
            }
            catch (IOException e) {
                SimplePostTool.fatal("IOException while posting data: " + e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException x) {}
            }
            InputStream in = null;
            try {
                if (200 != urlc.getResponseCode()) {
                    SimplePostTool.warn("Solr returned an error #" + urlc.getResponseCode() + " " + urlc.getResponseMessage());
                }
                in = urlc.getInputStream();
                SimplePostTool.pipe(in, output);
            }
            catch (IOException e) {
                SimplePostTool.warn("IOException while reading response: " + e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException x) {}
            }
        }
        finally {
            if (urlc != null) {
                urlc.disconnect();
            }
        }
    }

    public static InputStream stringToStream(String s) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            SimplePostTool.fatal("Shouldn't happen: UTF-8 not supported?!?!?!");
        }
        return is;
    }

    private static void pipe(InputStream source, OutputStream dest) throws IOException {
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = source.read(buf)) >= 0) {
            if (null == dest) continue;
            dest.write(buf, 0, read);
        }
        if (null != dest) {
            dest.flush();
        }
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getFileTypes() {
        return this.fileTypes;
    }

    public void setFileTypes(String fileTypes) {
        this.fileTypes = fileTypes;
        String glob = fileTypes.equals("*") ? ".*" : "^.*\\.(" + fileTypes.replace(",", "|") + ")$";
        this.globFileFilter = new GlobFileFilter(glob, true);
    }

    static {
        DATA_MODES = new HashSet<String>();
        DATA_MODES.add("files");
        DATA_MODES.add(DATA_MODE_ARGS);
        DATA_MODES.add(DATA_MODE_STDIN);
        mimeMap = new HashMap();
        mimeMap.put("xml", "text/xml");
        mimeMap.put("csv", "text/csv");
        mimeMap.put("json", "application/json");
        mimeMap.put("pdf", "application/pdf");
        mimeMap.put("rtf", "text/rtf");
        mimeMap.put("html", "text/html");
        mimeMap.put("htm", "text/html");
        mimeMap.put("doc", "application/msword");
        mimeMap.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimeMap.put("ppt", "application/vnd.ms-powerpoint");
        mimeMap.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimeMap.put("xls", "application/vnd.ms-excel");
        mimeMap.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimeMap.put("odt", "application/vnd.oasis.opendocument.text");
        mimeMap.put("ott", "application/vnd.oasis.opendocument.text");
        mimeMap.put("odp", "application/vnd.oasis.opendocument.presentation");
        mimeMap.put("otp", "application/vnd.oasis.opendocument.presentation");
        mimeMap.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        mimeMap.put("ots", "application/vnd.oasis.opendocument.spreadsheet");
        mimeMap.put("txt", "text/plain");
        mimeMap.put("log", "text/plain");
    }

    class GlobFileFilter
    implements FileFilter {
        private String _pattern;
        private Pattern p;

        public GlobFileFilter(String pattern, boolean isRegex) {
            this._pattern = pattern;
            if (!isRegex) {
                this._pattern = this._pattern.replace("^", "\\^").replace("$", "\\$").replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("+", "\\+").replace("*", ".*").replace("?", ".");
                this._pattern = "^" + this._pattern + "$";
            }
            try {
                this.p = Pattern.compile(this._pattern, 2);
            }
            catch (PatternSyntaxException e) {
                SimplePostTool.fatal("Invalid type list " + pattern + ". " + e.getDescription());
            }
        }

        @Override
        public boolean accept(File file) {
            return this.p.matcher(file.getName()).find();
        }
    }
}

