/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.Writer;

public class FastWriter
extends Writer {
    private static final int BUFSIZE = 8192;
    protected final Writer sink;
    protected final char[] buf;
    protected int pos;

    public FastWriter(Writer w) {
        this(w, new char[8192], 0);
    }

    public FastWriter(Writer sink, char[] tempBuffer, int start) {
        this.sink = sink;
        this.buf = tempBuffer;
        this.pos = start;
    }

    public static FastWriter wrap(Writer sink) {
        return sink instanceof FastWriter ? (FastWriter)sink : new FastWriter(sink);
    }

    @Override
    public void write(int c) throws IOException {
        this.write((char)c);
    }

    public void write(char c) throws IOException {
        if (this.pos >= this.buf.length) {
            this.sink.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        this.buf[this.pos++] = c;
    }

    @Override
    public FastWriter append(char c) throws IOException {
        if (this.pos >= this.buf.length) {
            this.sink.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        this.buf[this.pos++] = c;
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int space = this.buf.length - this.pos;
        if (len < space) {
            System.arraycopy(cbuf, off, this.buf, this.pos, len);
            this.pos += len;
        } else if (len < 8192) {
            System.arraycopy(cbuf, off, this.buf, this.pos, space);
            this.sink.write(this.buf, 0, this.buf.length);
            this.pos = len - space;
            System.arraycopy(cbuf, off + space, this.buf, 0, this.pos);
        } else {
            this.sink.write(this.buf, 0, this.pos);
            this.pos = 0;
            this.sink.write(cbuf, off, len);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int space = this.buf.length - this.pos;
        if (len < space) {
            str.getChars(off, off + len, this.buf, this.pos);
            this.pos += len;
        } else if (len < 8192) {
            str.getChars(off, off + space, this.buf, this.pos);
            this.sink.write(this.buf, 0, this.buf.length);
            str.getChars(off + space, off + len, this.buf, 0);
            this.pos = len - space;
        } else {
            this.sink.write(this.buf, 0, this.pos);
            this.pos = 0;
            this.sink.write(str, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.sink.write(this.buf, 0, this.pos);
        this.pos = 0;
        this.sink.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.sink.close();
    }

    public void flushBuffer() throws IOException {
        this.sink.write(this.buf, 0, this.pos);
        this.pos = 0;
    }
}

