/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.util.RefCounted;

public class VersionInfo {
    public static final String VERSION_FIELD = "_version_";
    private final UpdateLog ulog;
    private final VersionBucket[] buckets;
    private SchemaField versionField;
    private SchemaField idField;
    final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    long vclock;
    long time;
    private final Object clockSync = new Object();

    public VersionInfo(UpdateLog ulog, int nBuckets) {
        this.ulog = ulog;
        SolrCore core = ulog.uhandler.core;
        this.versionField = core.getSchema().getFieldOrNull(VERSION_FIELD);
        this.idField = core.getSchema().getUniqueKeyField();
        this.buckets = new VersionBucket[BitUtil.nextHighestPowerOfTwo((int)nBuckets)];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new VersionBucket();
        }
    }

    public void reload() {
    }

    public SchemaField getVersionField() {
        return this.versionField;
    }

    public void lockForUpdate() {
        this.lock.readLock().lock();
    }

    public void unlockForUpdate() {
        this.lock.readLock().unlock();
    }

    public void blockUpdates() {
        this.lock.writeLock().lock();
    }

    public void unblockUpdates() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNewClock() {
        Object object = this.clockSync;
        synchronized (object) {
            this.time = System.currentTimeMillis();
            long result = this.time << 20;
            if (result <= this.vclock) {
                result = this.vclock + 1L;
            }
            this.vclock = result;
            return this.vclock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOldClock() {
        Object object = this.clockSync;
        synchronized (object) {
            return this.vclock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClock(long clock) {
        Object object = this.clockSync;
        synchronized (object) {
            this.vclock = Math.max(this.vclock, clock);
        }
    }

    public VersionBucket bucket(int hash) {
        int slot = hash & this.buckets.length - 1;
        return this.buckets[slot];
    }

    public Long lookupVersion(BytesRef idBytes) {
        return this.ulog.lookupVersion(idBytes);
    }

    public Long getVersionFromIndex(BytesRef idBytes) {
        RefCounted<SolrIndexSearcher> newestSearcher = this.ulog.uhandler.core.getRealtimeSearcher();
        try {
            SolrIndexSearcher searcher = newestSearcher.get();
            long lookup = searcher.lookupId(idBytes);
            if (lookup < 0L) {
                Long l = null;
                return l;
            }
            ValueSource vs = this.versionField.getType().getValueSource(this.versionField, null);
            Map context = ValueSource.newContext((IndexSearcher)searcher);
            vs.createWeight(context, (IndexSearcher)searcher);
            FunctionValues fv = vs.getValues(context, (AtomicReaderContext)searcher.getTopReaderContext().leaves().get((int)(lookup >> 32)));
            long ver = fv.longVal((int)lookup);
            Long l = ver;
            return l;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading version from index", (Throwable)e);
        }
        finally {
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }
}

