/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequestExt;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.util.AdjustableSemaphore;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCmdDistributor {
    private static final int MAX_RETRIES_ON_FORWARD = 6;
    public static Logger log = LoggerFactory.getLogger(SolrCmdDistributor.class);
    static ThreadPoolExecutor commExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultSolrThreadFactory("cmdDistribExecutor"));
    static final HttpClient client;
    static AdjustableSemaphore semaphore;
    CompletionService<Request> completionService;
    Set<Future<Request>> pending;
    int maxBufferedAddsPerServer = 10;
    int maxBufferedDeletesPerServer = 10;
    private Response response = new Response();
    private final Map<Node, List<AddRequest>> adds = new HashMap<Node, List<AddRequest>>();
    private final Map<Node, List<DeleteRequest>> deletes = new HashMap<Node, List<DeleteRequest>>();

    public SolrCmdDistributor(int numHosts) {
        int maxPermits = Math.max(8, (numHosts - 1) * 8);
        if (maxPermits != semaphore.getMaxPermits()) {
            semaphore.setMaxPermits(maxPermits);
        }
        this.completionService = new ExecutorCompletionService<Request>(commExecutor);
        this.pending = new HashSet<Future<Request>>();
    }

    public void finish() {
        this.flushAdds(1);
        this.flushDeletes(1);
        this.checkResponses(true);
    }

    public void distribDelete(DeleteUpdateCommand cmd, List<Node> urls, ModifiableSolrParams params) throws IOException {
        this.checkResponses(false);
        if (cmd.isDeleteById()) {
            this.doDelete(cmd, urls, params);
        } else {
            this.doDelete(cmd, urls, params);
        }
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.checkResponses(false);
        this.flushDeletes(1);
        AddUpdateCommand clone = new AddUpdateCommand(null);
        clone.solrDoc = cmd.solrDoc;
        clone.commitWithin = cmd.commitWithin;
        clone.overwrite = cmd.overwrite;
        clone.setVersion(cmd.getVersion());
        AddRequest addRequest = new AddRequest();
        addRequest.cmd = clone;
        addRequest.params = params;
        for (Node node : nodes) {
            List<AddRequest> alist = this.adds.get(node);
            if (alist == null) {
                alist = new ArrayList<AddRequest>(2);
                this.adds.put(node, alist);
            }
            alist.add(addRequest);
        }
        this.flushAdds(this.maxBufferedAddsPerServer);
    }

    public void distribCommit(CommitUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.checkResponses(true);
        UpdateRequestExt ureq = new UpdateRequestExt();
        ureq.setParams(params);
        this.addCommit(ureq, cmd);
        for (Node node : nodes) {
            this.submit(ureq, node);
        }
        if (cmd.waitSearcher) {
            this.checkResponses(true);
        }
    }

    private void doDelete(DeleteUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) {
        this.flushAdds(1);
        DeleteUpdateCommand clonedCmd = this.clone(cmd);
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.cmd = clonedCmd;
        deleteRequest.params = params;
        for (Node node : nodes) {
            List<DeleteRequest> dlist = this.deletes.get(node);
            if (dlist == null) {
                dlist = new ArrayList<DeleteRequest>(2);
                this.deletes.put(node, dlist);
            }
            dlist.add(deleteRequest);
        }
        this.flushDeletes(this.maxBufferedDeletesPerServer);
    }

    void addCommit(UpdateRequestExt ureq, CommitUpdateCommand cmd) {
        if (cmd == null) {
            return;
        }
        ureq.setAction(cmd.optimize ? AbstractUpdateRequest.ACTION.OPTIMIZE : AbstractUpdateRequest.ACTION.COMMIT, false, cmd.waitSearcher);
    }

    boolean flushAdds(int limit) {
        HashSet<Node> removeNodes = new HashSet<Node>();
        Set<Node> nodes = this.adds.keySet();
        for (Node node : nodes) {
            List<AddRequest> alist = this.adds.get(node);
            if (alist == null || alist.size() < limit) continue;
            UpdateRequestExt ureq = new UpdateRequestExt();
            ModifiableSolrParams combinedParams = new ModifiableSolrParams();
            for (AddRequest aReq : alist) {
                AddUpdateCommand cmd = aReq.cmd;
                combinedParams.add((SolrParams)aReq.params);
                ureq.add(cmd.solrDoc, cmd.commitWithin, cmd.overwrite);
            }
            if (ureq.getParams() == null) {
                ureq.setParams(new ModifiableSolrParams());
            }
            ureq.getParams().add((SolrParams)combinedParams);
            removeNodes.add(node);
            this.submit(ureq, node);
        }
        for (Node node : removeNodes) {
            this.adds.remove(node);
        }
        return true;
    }

    boolean flushDeletes(int limit) {
        HashSet<Node> removeNodes = new HashSet<Node>();
        Set<Node> nodes = this.deletes.keySet();
        for (Node node : nodes) {
            List<DeleteRequest> dlist = this.deletes.get(node);
            if (dlist == null || dlist.size() < limit) continue;
            UpdateRequestExt ureq = new UpdateRequestExt();
            ModifiableSolrParams combinedParams = new ModifiableSolrParams();
            for (DeleteRequest dReq : dlist) {
                DeleteUpdateCommand cmd = dReq.cmd;
                combinedParams.add((SolrParams)dReq.params);
                if (cmd.isDeleteById()) {
                    ureq.deleteById(cmd.getId(), Long.valueOf(cmd.getVersion()));
                } else {
                    ureq.deleteByQuery(cmd.query);
                }
                if (ureq.getParams() == null) {
                    ureq.setParams(new ModifiableSolrParams());
                }
                ureq.getParams().add((SolrParams)combinedParams);
            }
            removeNodes.add(node);
            this.submit(ureq, node);
        }
        for (Node node : removeNodes) {
            this.deletes.remove(node);
        }
        return true;
    }

    private DeleteUpdateCommand clone(DeleteUpdateCommand cmd) {
        DeleteUpdateCommand c = (DeleteUpdateCommand)cmd.clone();
        c.setFlags(cmd.getFlags());
        c.setVersion(cmd.getVersion());
        return c;
    }

    void submit(UpdateRequestExt ureq, Node node) {
        Request sreq = new Request();
        sreq.node = node;
        sreq.ureq = ureq;
        this.submit(sreq);
    }

    public void submit(final Request sreq) {
        final String url = sreq.node.getUrl();
        Callable<Request> task = new Callable<Request>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Request call() throws Exception {
                Request clonedRequest = new Request();
                clonedRequest.node = sreq.node;
                clonedRequest.ureq = sreq.ureq;
                clonedRequest.retries = sreq.retries;
                try {
                    String fullUrl = !url.startsWith("http://") && !url.startsWith("https://") ? "http://" + url : url;
                    HttpSolrServer server = new HttpSolrServer(fullUrl, client);
                    clonedRequest.ursp = server.request((SolrRequest)clonedRequest.ureq);
                }
                catch (Exception e) {
                    clonedRequest.exception = e;
                    clonedRequest.rspCode = e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1;
                }
                finally {
                    semaphore.release();
                }
                return clonedRequest;
            }
        };
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException();
        }
        this.pending.add(this.completionService.submit(task));
    }

    void checkResponses(boolean block) {
        while (this.pending != null && this.pending.size() > 0) {
            try {
                Future<Request> future;
                Future<Request> future2 = future = block ? this.completionService.take() : this.completionService.poll();
                if (future == null) {
                    return;
                }
                this.pending.remove(future);
                try {
                    Request sreq = future.get();
                    if (sreq.rspCode == 0) continue;
                    boolean isRetry = sreq.node.checkRetry();
                    boolean doRetry = false;
                    int rspCode = sreq.rspCode;
                    if (isRetry) {
                        if (rspCode == 404 || rspCode == 403 || rspCode == 503 || rspCode == 500) {
                            doRetry = true;
                        }
                        if (sreq.exception instanceof IOException) {
                            doRetry = true;
                        } else if (sreq.exception instanceof SolrServerException && ((SolrServerException)((Object)sreq.exception)).getRootCause() instanceof IOException) {
                            doRetry = true;
                        }
                    }
                    if (isRetry && sreq.retries < 6 && doRetry) {
                        ++sreq.retries;
                        sreq.rspCode = 0;
                        sreq.exception = null;
                        SolrException.log((Logger)log, (String)("forwarding update to " + sreq.node.getUrl() + " failed - retrying ... "));
                        Thread.sleep(500L);
                        this.submit(sreq);
                        this.checkResponses(block);
                        continue;
                    }
                    Exception e = sreq.exception;
                    Error error = new Error();
                    error.e = e;
                    error.node = sreq.node;
                    this.response.errors.add(error);
                    this.response.sreq = sreq;
                    SolrException.log((Logger)log, (String)("shard update error " + sreq.node), (Throwable)sreq.exception);
                }
                catch (ExecutionException e) {
                    SolrException.log((Logger)SolrCore.log, (String)"error sending update request to shard", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "interrupted waiting for shard update response", (Throwable)e);
            }
        }
    }

    public Response getResponse() {
        return this.response;
    }

    static {
        semaphore = new AdjustableSemaphore(8);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 500);
        params.set("maxConnectionsPerHost", 16);
        client = HttpClientUtil.createClient((SolrParams)params);
    }

    public static class StdNode
    extends Node {
        protected String url;
        protected String baseUrl;
        protected String coreName;
        private ZkCoreNodeProps nodeProps;

        public StdNode(ZkCoreNodeProps nodeProps) {
            this.url = nodeProps.getCoreUrl();
            this.baseUrl = nodeProps.getBaseUrl();
            this.coreName = nodeProps.getCoreName();
            this.nodeProps = nodeProps;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.url;
        }

        @Override
        public boolean checkRetry() {
            return false;
        }

        @Override
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public String getCoreName() {
            return this.coreName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseUrl == null ? 0 : this.baseUrl.hashCode());
            result = 31 * result + (this.coreName == null ? 0 : this.coreName.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StdNode other = (StdNode)obj;
            if (this.baseUrl == null ? other.baseUrl != null : !this.baseUrl.equals(other.baseUrl)) {
                return false;
            }
            if (this.coreName == null ? other.coreName != null : !this.coreName.equals(other.coreName)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        @Override
        public ZkCoreNodeProps getNodeProps() {
            return this.nodeProps;
        }
    }

    public static abstract class Node {
        public abstract String getUrl();

        public abstract boolean checkRetry();

        public abstract String getCoreName();

        public abstract String getBaseUrl();

        public abstract ZkCoreNodeProps getNodeProps();
    }

    public static class Error {
        public Node node;
        public Exception e;
    }

    public static class Response {
        public Request sreq;
        public List<Error> errors = new ArrayList<Error>();
    }

    public static class Request {
        public Node node;
        UpdateRequestExt ureq;
        NamedList<Object> ursp;
        int rspCode;
        public Exception exception;
        int retries;
    }

    class DeleteRequest {
        DeleteUpdateCommand cmd;
        ModifiableSolrParams params;

        DeleteRequest() {
        }
    }

    class AddRequest {
        AddUpdateCommand cmd;
        ModifiableSolrParams params;

        AddRequest() {
        }
    }
}

