/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class DocumentBuilder {
    private final IndexSchema schema;
    private Document doc;
    private HashMap<String, String> map;

    public DocumentBuilder(IndexSchema schema) {
        this.schema = schema;
    }

    public void startDoc() {
        this.doc = new Document();
        this.map = new HashMap();
    }

    protected void addSingleField(SchemaField sfield, String val, float boost) {
        if (sfield.isPolyField()) {
            IndexableField[] fields = sfield.createFields(val, boost);
            if (fields.length > 0) {
                String oldValue;
                if (!sfield.multiValued() && (oldValue = this.map.put(sfield.getName(), val)) != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: multiple values encountered for non multiValued field " + sfield.getName() + ": first='" + oldValue + "' second='" + val + "'");
                }
                for (IndexableField field : fields) {
                    this.doc.add(field);
                }
            }
        } else {
            String oldValue;
            IndexableField field = sfield.createField(val, boost);
            if (field != null && !sfield.multiValued() && (oldValue = this.map.put(sfield.getName(), val)) != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: multiple values encountered for non multiValued field " + sfield.getName() + ": first='" + oldValue + "' second='" + val + "'");
            }
            this.doc.add(field);
        }
    }

    public void addField(SchemaField sfield, String val, float boost) {
        this.addSingleField(sfield, val, boost);
    }

    public void addField(String name, String val) {
        this.addField(name, val, 1.0f);
    }

    public void addField(String name, String val, float boost) {
        List<CopyField> copyFields;
        SchemaField sfield = this.schema.getFieldOrNull(name);
        if (sfield != null) {
            this.addField(sfield, val, boost);
        }
        if ((copyFields = this.schema.getCopyFieldsList(name)) != null) {
            for (CopyField cf : copyFields) {
                this.addSingleField(cf.getDestination(), cf.getLimitedValue(val), boost);
            }
        }
        if (sfield == null && (copyFields == null || copyFields.size() == 0)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR:unknown field '" + name + "'");
        }
    }

    public void endDoc() {
    }

    public Document getDoc() throws IllegalArgumentException {
        ArrayList<String> missingFields = null;
        for (SchemaField field : this.schema.getRequiredFields()) {
            if (this.doc.getField(field.getName()) != null) continue;
            if (field.getDefaultValue() != null) {
                DocumentBuilder.addField(this.doc, field, field.getDefaultValue(), 1.0f);
                continue;
            }
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(field.getName());
        }
        if (missingFields != null) {
            StringBuilder builder = new StringBuilder();
            if (this.schema.getUniqueKeyField() != null) {
                String n = this.schema.getUniqueKeyField().getName();
                String v = this.doc.getField(n).stringValue();
                builder.append("Document [" + n + "=" + v + "] ");
            }
            builder.append("missing required fields: ");
            for (String field : missingFields) {
                builder.append(field);
                builder.append(" ");
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, builder.toString());
        }
        Document ret = this.doc;
        this.doc = null;
        return ret;
    }

    private static void addField(Document doc, SchemaField field, Object val, float boost) {
        if (field.isPolyField()) {
            IndexableField[] farr;
            for (IndexableField f : farr = field.getType().createFields(field, val, boost)) {
                if (f == null) continue;
                doc.add(f);
            }
        } else {
            IndexableField f = field.createField(val, boost);
            if (f != null) {
                doc.add(f);
            }
        }
    }

    private static String getID(SolrInputDocument doc, IndexSchema schema) {
        String id = "";
        SchemaField sf = schema.getUniqueKeyField();
        if (sf != null) {
            id = "[doc=" + doc.getFieldValue(sf.getName()) + "] ";
        }
        return id;
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema) {
        Document out = new Document();
        float docBoost = doc.getDocumentBoost();
        for (SolrInputField solrInputField : doc) {
            boolean applyBoost;
            String name = solrInputField.getName();
            SchemaField sfield = schema.getFieldOrNull(name);
            boolean used = false;
            float boost = solrInputField.getBoost();
            boolean bl = applyBoost = sfield != null && sfield.indexed() && !sfield.omitNorms();
            if (sfield != null && !sfield.multiValued() && solrInputField.getValueCount() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "multiple values encountered for non multiValued field " + sfield.getName() + ": " + solrInputField.getValue());
            }
            if (!applyBoost && boost != 1.0f) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "cannot set an index-time boost, unindexed or norms are omitted for field " + sfield.getName() + ": " + solrInputField.getValue());
            }
            boolean hasField = false;
            try {
                for (Object v : solrInputField) {
                    if (v == null) continue;
                    hasField = true;
                    if (sfield != null) {
                        used = true;
                        DocumentBuilder.addField(out, sfield, v, applyBoost ? docBoost * boost : 1.0f);
                    }
                    List<CopyField> copyFields = schema.getCopyFieldsList(name);
                    for (CopyField cf : copyFields) {
                        SchemaField destinationField = cf.getDestination();
                        if (!destinationField.multiValued() && out.getField(destinationField.getName()) != null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "multiple values encountered for non multiValued copy field " + destinationField.getName() + ": " + v);
                        }
                        used = true;
                        Object val = v;
                        if (val instanceof String && cf.getMaxChars() > 0) {
                            val = cf.getLimitedValue((String)val);
                        }
                        DocumentBuilder.addField(out, destinationField, val, destinationField.indexed() && !destinationField.omitNorms() ? docBoost * boost : 1.0f);
                    }
                    boost = docBoost;
                }
            }
            catch (SolrException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "Error adding field '" + solrInputField.getName() + "'='" + solrInputField.getValue() + "' msg=" + ex.getMessage(), (Throwable)ex);
            }
            if (used || !hasField) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + DocumentBuilder.getID(doc, schema) + "unknown field '" + name + "'");
        }
        for (SchemaField schemaField : schema.getRequiredFields()) {
            if (out.getField(schemaField.getName()) != null) continue;
            if (schemaField.getDefaultValue() != null) {
                DocumentBuilder.addField(out, schemaField, schemaField.getDefaultValue(), 1.0f);
                continue;
            }
            String msg = DocumentBuilder.getID(doc, schema) + "missing required field: " + schemaField.getName();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        return out;
    }
}

