/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.surround.parser.QueryParser;
import org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryparser.surround.query.SrndQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrQueryParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SurroundQParser
extends QParser {
    protected static final Logger LOG = LoggerFactory.getLogger(SurroundQParser.class);
    static final int DEFMAXBASICQUERIES = 1000;
    static final String MBQParam = "maxBasicQueries";
    String sortStr;
    SolrQueryParser lparser;
    int maxBasicQueries;

    public SurroundQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws ParseException {
        SrndQuery sq;
        String qstr = this.getString();
        if (qstr == null) {
            return null;
        }
        String mbqparam = this.getParam(MBQParam);
        if (mbqparam == null) {
            this.maxBasicQueries = 1000;
        } else {
            try {
                this.maxBasicQueries = Integer.parseInt(mbqparam);
            }
            catch (Exception e) {
                LOG.warn("Couldn't parse maxBasicQueries value " + mbqparam + ", using default of 1000");
                this.maxBasicQueries = 1000;
            }
        }
        try {
            sq = QueryParser.parse((String)qstr);
        }
        catch (org.apache.lucene.queryparser.surround.parser.ParseException pe) {
            throw new ParseException(pe.getMessage());
        }
        BasicQueryFactory bqFactory = new BasicQueryFactory(this.maxBasicQueries);
        String defaultField = QueryParsing.getDefaultField(this.getReq().getSchema(), this.getParam("df"));
        Query lquery = sq.makeLuceneQueryField(defaultField, bqFactory);
        return lquery;
    }
}

