/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.CachingCollector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.grouping.function.FunctionAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.function.FunctionAllGroupsCollector;
import org.apache.lucene.search.grouping.function.FunctionFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.function.FunctionSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.term.TermFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermSecondPassGroupingCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.DocSetDelegateCollector;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.collector.FilterCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grouping {
    private static final Logger logger = LoggerFactory.getLogger(Grouping.class);
    private final SolrIndexSearcher searcher;
    private final SolrIndexSearcher.QueryResult qr;
    private final SolrIndexSearcher.QueryCommand cmd;
    private final List<Command> commands = new ArrayList<Command>();
    private final boolean main;
    private final boolean cacheSecondPassSearch;
    private final int maxDocsPercentageToCache;
    private Sort sort;
    private Sort groupSort;
    private int limitDefault;
    private int docsPerGroupDefault;
    private int groupOffsetDefault;
    private Format defaultFormat;
    private TotalCount defaultTotalCount;
    private int maxDoc;
    private boolean needScores;
    private boolean getDocSet;
    private boolean getGroupedDocSet;
    private boolean getDocList;
    private Query query;
    private DocSet filter;
    private Filter luceneFilter;
    private NamedList grouped = new SimpleOrderedMap();
    private Set<Integer> idSet = new LinkedHashSet<Integer>();
    private int maxMatches;
    private float maxScore = Float.NEGATIVE_INFINITY;
    private boolean signalCacheWarning = false;
    private TimeLimitingCollector timeLimitingCollector;
    public DocList mainResult;

    public Grouping(SolrIndexSearcher searcher, SolrIndexSearcher.QueryResult qr, SolrIndexSearcher.QueryCommand cmd, boolean cacheSecondPassSearch, int maxDocsPercentageToCache, boolean main) {
        this.searcher = searcher;
        this.qr = qr;
        this.cmd = cmd;
        this.cacheSecondPassSearch = cacheSecondPassSearch;
        this.maxDocsPercentageToCache = maxDocsPercentageToCache;
        this.main = main;
    }

    public void add(Command groupingCommand) {
        this.commands.add(groupingCommand);
    }

    public void addFieldCommand(String field, SolrQueryRequest request) throws ParseException {
        SchemaField schemaField = this.searcher.getSchema().getField(field);
        FieldType fieldType = schemaField.getType();
        ValueSource valueSource = fieldType.getValueSource(schemaField, null);
        if (!(valueSource instanceof StrFieldSource)) {
            this.addFunctionCommand(field, request);
            return;
        }
        CommandField gc = new CommandField();
        gc.groupSort = this.groupSort;
        gc.groupBy = field;
        gc.key = field;
        gc.numGroups = this.limitDefault;
        gc.docsPerGroup = this.docsPerGroupDefault;
        gc.groupOffset = this.groupOffsetDefault;
        gc.offset = this.cmd.getOffset();
        gc.sort = this.sort;
        gc.format = this.defaultFormat;
        gc.totalCount = this.defaultTotalCount;
        if (this.main) {
            gc.main = true;
            gc.format = Format.simple;
        }
        if (gc.format == Format.simple) {
            gc.groupOffset = 0;
        }
        this.commands.add(gc);
    }

    public void addFunctionCommand(String groupByStr, SolrQueryRequest request) throws ParseException {
        Command gc;
        QParser parser = QParser.getParser(groupByStr, "func", request);
        Query q = parser.getQuery();
        if (q instanceof FunctionQuery) {
            ValueSource valueSource = ((FunctionQuery)q).getValueSource();
            if (valueSource instanceof StrFieldSource) {
                String field = ((StrFieldSource)valueSource).getField();
                CommandField commandField = new CommandField();
                commandField.groupBy = field;
                gc = commandField;
            } else {
                CommandFunc commandFunc = new CommandFunc();
                commandFunc.groupBy = valueSource;
                gc = commandFunc;
            }
        } else {
            CommandFunc commandFunc = new CommandFunc();
            commandFunc.groupBy = new QueryValueSource(q, 0.0f);
            gc = commandFunc;
        }
        gc.groupSort = this.groupSort;
        gc.key = groupByStr;
        gc.numGroups = this.limitDefault;
        gc.docsPerGroup = this.docsPerGroupDefault;
        gc.groupOffset = this.groupOffsetDefault;
        gc.offset = this.cmd.getOffset();
        gc.sort = this.sort;
        gc.format = this.defaultFormat;
        gc.totalCount = this.defaultTotalCount;
        if (this.main) {
            gc.main = true;
            gc.format = Format.simple;
        }
        if (gc.format == Format.simple) {
            gc.groupOffset = 0;
        }
        this.commands.add(gc);
    }

    public void addQueryCommand(String groupByStr, SolrQueryRequest request) throws ParseException {
        QParser parser = QParser.getParser(groupByStr, null, request);
        Query gq = parser.getQuery();
        CommandQuery gc = new CommandQuery();
        gc.query = gq;
        gc.groupSort = this.groupSort;
        gc.key = groupByStr;
        gc.numGroups = this.limitDefault;
        gc.docsPerGroup = this.docsPerGroupDefault;
        gc.groupOffset = this.groupOffsetDefault;
        gc.offset = this.cmd.getOffset();
        gc.numGroups = this.limitDefault;
        gc.format = this.defaultFormat;
        if (this.main) {
            gc.main = true;
            gc.format = Format.simple;
        }
        if (gc.format == Format.simple) {
            gc.docsPerGroup = gc.numGroups;
            gc.groupOffset = gc.offset;
        }
        this.commands.add(gc);
    }

    public Grouping setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public Grouping setGroupSort(Sort groupSort) {
        this.groupSort = groupSort;
        return this;
    }

    public Grouping setLimitDefault(int limitDefault) {
        this.limitDefault = limitDefault;
        return this;
    }

    public Grouping setDocsPerGroupDefault(int docsPerGroupDefault) {
        this.docsPerGroupDefault = docsPerGroupDefault;
        return this;
    }

    public Grouping setGroupOffsetDefault(int groupOffsetDefault) {
        this.groupOffsetDefault = groupOffsetDefault;
        return this;
    }

    public Grouping setDefaultFormat(Format defaultFormat) {
        this.defaultFormat = defaultFormat;
        return this;
    }

    public Grouping setDefaultTotalCount(TotalCount defaultTotalCount) {
        this.defaultTotalCount = defaultTotalCount;
        return this;
    }

    public Grouping setGetGroupedDocSet(boolean getGroupedDocSet) {
        this.getGroupedDocSet = getGroupedDocSet;
        return this;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void execute() throws IOException {
        int maxDocsToCache;
        if (this.commands.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify at least one field, function or query to group by.");
        }
        DocListAndSet out = new DocListAndSet();
        this.qr.setDocListAndSet(out);
        SolrIndexSearcher.ProcessedFilter pf = this.searcher.getProcessedFilter(this.cmd.getFilter(), this.cmd.getFilterList());
        Filter luceneFilter = pf.filter;
        this.maxDoc = this.searcher.maxDoc();
        this.needScores = (this.cmd.getFlags() & 1) != 0;
        boolean cacheScores = false;
        if (!this.needScores && !this.commands.isEmpty()) {
            if (this.commands.get((int)0).groupSort == null) {
                cacheScores = true;
            } else {
                for (SortField field : this.commands.get((int)0).groupSort.getSort()) {
                    if (field.getType() != SortField.Type.SCORE) continue;
                    cacheScores = true;
                    break;
                }
            }
        } else if (this.needScores) {
            cacheScores = this.needScores;
        }
        this.getDocSet = (this.cmd.getFlags() & 0x40000000) != 0;
        this.getDocList = (this.cmd.getFlags() & 2) != 0;
        this.query = QueryUtils.makeQueryable(this.cmd.getQuery());
        for (Command cmd : this.commands) {
            cmd.prepare();
        }
        AbstractAllGroupHeadsCollector<?> allGroupHeadsCollector = null;
        ArrayList<Object> collectors = new ArrayList<Object>(this.commands.size());
        for (Command cmd : this.commands) {
            Collector collector = cmd.createFirstPassCollector();
            if (collector != null) {
                collectors.add(collector);
            }
            if (!this.getGroupedDocSet || allGroupHeadsCollector != null) continue;
            allGroupHeadsCollector = cmd.createAllGroupCollector();
            collectors.add(allGroupHeadsCollector);
        }
        Collector allCollectors = MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()]));
        DocSetDelegateCollector setCollector = null;
        if (this.getDocSet && allGroupHeadsCollector == null) {
            setCollector = new DocSetDelegateCollector(this.maxDoc >> 6, this.maxDoc, allCollectors);
            allCollectors = setCollector;
        }
        CachingCollector cachedCollector = null;
        if (this.cacheSecondPassSearch && allCollectors != null && (maxDocsToCache = (int)Math.round((double)this.maxDoc * ((double)this.maxDocsPercentageToCache / 100.0))) > 0) {
            cachedCollector = CachingCollector.create((Collector)allCollectors, (boolean)cacheScores, (int)maxDocsToCache);
            allCollectors = cachedCollector;
        }
        if (pf.postFilter != null) {
            pf.postFilter.setLastDelegate(allCollectors);
            allCollectors = pf.postFilter;
        }
        if (allCollectors != null) {
            this.searchWithTimeLimiter(luceneFilter, allCollectors);
        }
        if (this.getGroupedDocSet && allGroupHeadsCollector != null) {
            FixedBitSet fixedBitSet = allGroupHeadsCollector.retrieveGroupHeads(this.maxDoc);
            long[] bits = fixedBitSet.getBits();
            OpenBitSet openBitSet = new OpenBitSet(bits, bits.length);
            this.qr.setDocSet(new BitDocSet(openBitSet));
        } else if (this.getDocSet) {
            this.qr.setDocSet(((DocSetCollector)setCollector).getDocSet());
        }
        collectors.clear();
        for (Command cmd : this.commands) {
            Collector collector = cmd.createSecondPassCollector();
            if (collector == null) continue;
            collectors.add(collector);
        }
        if (!collectors.isEmpty()) {
            Collector secondPhaseCollectors = MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()]));
            if (collectors.size() > 0) {
                if (cachedCollector != null) {
                    if (cachedCollector.isCached()) {
                        cachedCollector.replay(secondPhaseCollectors);
                    } else {
                        this.signalCacheWarning = true;
                        logger.warn(String.format(Locale.ROOT, "The grouping cache is active, but not used because it exceeded the max cache limit of %d percent", this.maxDocsPercentageToCache));
                        logger.warn("Please increase cache size or disable group caching.");
                        this.searchWithTimeLimiter(luceneFilter, secondPhaseCollectors);
                    }
                } else {
                    if (pf.postFilter != null) {
                        pf.postFilter.setLastDelegate(secondPhaseCollectors);
                        secondPhaseCollectors = pf.postFilter;
                    }
                    this.searchWithTimeLimiter(luceneFilter, secondPhaseCollectors);
                }
            }
        }
        for (Command cmd : this.commands) {
            cmd.finish();
        }
        this.qr.groupedResults = this.grouped;
        if (this.getDocList) {
            int sz = this.idSet.size();
            int[] ids = new int[sz];
            int idx = 0;
            for (int val : this.idSet) {
                ids[idx++] = val;
            }
            this.qr.setDocList(new DocSlice(0, sz, ids, null, this.maxMatches, this.maxScore));
        }
    }

    private void searchWithTimeLimiter(Filter luceneFilter, Collector collector) throws IOException {
        if (this.cmd.getTimeAllowed() > 0L) {
            if (this.timeLimitingCollector == null) {
                this.timeLimitingCollector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), this.cmd.getTimeAllowed());
            } else {
                this.timeLimitingCollector.setCollector(collector);
            }
            collector = this.timeLimitingCollector;
        }
        try {
            this.searcher.search(this.query, luceneFilter, collector);
        }
        catch (TimeLimitingCollector.TimeExceededException x) {
            logger.warn("Query: " + this.query + "; " + x.getMessage());
            this.qr.setPartialResults(true);
        }
    }

    int getMax(int offset, int len, int max) {
        int v;
        int n = v = len < 0 ? max : offset + len;
        if (v < 0 || v > max) {
            v = max;
        }
        return v;
    }

    public boolean isSignalCacheWarning() {
        return this.signalCacheWarning;
    }

    public class CommandFunc
    extends Command<MutableValue> {
        public ValueSource groupBy;
        Map context;
        FunctionFirstPassGroupingCollector firstPass;
        FunctionSecondPassGroupingCollector secondPass;
        TotalHitCountCollector fallBackCollector;
        FunctionAllGroupsCollector allGroupsCollector;
        Collection<SearchGroup<MutableValue>> topGroups;

        @Override
        protected void prepare() throws IOException {
            Map context = ValueSource.newContext((IndexSearcher)Grouping.this.searcher);
            this.groupBy.createWeight(context, (IndexSearcher)Grouping.this.searcher);
            this.actualGroupsToFind = Grouping.this.getMax(this.offset, this.numGroups, Grouping.this.maxDoc);
        }

        @Override
        protected Collector createFirstPassCollector() throws IOException {
            if (this.actualGroupsToFind <= 0) {
                this.fallBackCollector = new TotalHitCountCollector();
                return this.fallBackCollector;
            }
            this.sort = this.sort == null ? Sort.RELEVANCE : this.sort;
            this.firstPass = new FunctionFirstPassGroupingCollector(this.groupBy, this.context, Grouping.this.searcher.weightSort(this.sort), this.actualGroupsToFind);
            return this.firstPass;
        }

        @Override
        protected Collector createSecondPassCollector() throws IOException {
            if (this.actualGroupsToFind <= 0) {
                this.allGroupsCollector = new FunctionAllGroupsCollector(this.groupBy, this.context);
                return this.totalCount == TotalCount.grouped ? this.allGroupsCollector : null;
            }
            Collection collection = this.topGroups = this.format == Format.grouped ? this.firstPass.getTopGroups(this.offset, false) : this.firstPass.getTopGroups(0, false);
            if (this.topGroups == null) {
                if (this.totalCount == TotalCount.grouped) {
                    this.allGroupsCollector = new FunctionAllGroupsCollector(this.groupBy, this.context);
                    this.fallBackCollector = new TotalHitCountCollector();
                    return MultiCollector.wrap((Collector[])new Collector[]{this.allGroupsCollector, this.fallBackCollector});
                }
                this.fallBackCollector = new TotalHitCountCollector();
                return this.fallBackCollector;
            }
            int groupdDocsToCollect = Grouping.this.getMax(this.groupOffset, this.docsPerGroup, Grouping.this.maxDoc);
            groupdDocsToCollect = Math.max(groupdDocsToCollect, 1);
            this.secondPass = new FunctionSecondPassGroupingCollector(this.topGroups, this.sort, this.groupSort, groupdDocsToCollect, Grouping.this.needScores, Grouping.this.needScores, false, this.groupBy, this.context);
            if (this.totalCount == TotalCount.grouped) {
                this.allGroupsCollector = new FunctionAllGroupsCollector(this.groupBy, this.context);
                return MultiCollector.wrap((Collector[])new Collector[]{this.secondPass, this.allGroupsCollector});
            }
            return this.secondPass;
        }

        @Override
        public AbstractAllGroupHeadsCollector<?> createAllGroupCollector() throws IOException {
            Sort sortWithinGroup = this.groupSort != null ? this.groupSort : new Sort();
            return new FunctionAllGroupHeadsCollector(this.groupBy, this.context, sortWithinGroup);
        }

        @Override
        protected void finish() throws IOException {
            TopGroups topGroups = this.result = this.secondPass != null ? this.secondPass.getTopGroups(0) : null;
            if (this.main) {
                Grouping.this.mainResult = this.createSimpleResponse();
                return;
            }
            NamedList groupResult = this.commonResponse();
            if (this.format == Format.simple) {
                groupResult.add("doclist", (Object)this.createSimpleResponse());
                return;
            }
            ArrayList<SimpleOrderedMap> groupList = new ArrayList<SimpleOrderedMap>();
            groupResult.add("groups", groupList);
            if (this.result == null) {
                return;
            }
            if (this.numGroups == 0) {
                return;
            }
            for (GroupDocs group : this.result.groups) {
                SimpleOrderedMap nl = new SimpleOrderedMap();
                groupList.add(nl);
                nl.add("groupValue", ((MutableValue)group.groupValue).toObject());
                this.addDocList((NamedList)nl, group);
            }
        }

        @Override
        public int getMatches() {
            if (this.result == null && this.fallBackCollector == null) {
                return 0;
            }
            return this.result != null ? this.result.totalHitCount : this.fallBackCollector.getTotalHits();
        }

        @Override
        protected Integer getNumberOfGroups() {
            return this.allGroupsCollector == null ? null : Integer.valueOf(this.allGroupsCollector.getGroupCount());
        }
    }

    public class CommandQuery
    extends Command {
        public Query query;
        TopDocsCollector topCollector;
        FilterCollector collector;

        @Override
        protected void prepare() throws IOException {
            this.actualGroupsToFind = Grouping.this.getMax(this.offset, this.numGroups, Grouping.this.maxDoc);
        }

        @Override
        protected Collector createFirstPassCollector() throws IOException {
            DocSet groupFilt = Grouping.this.searcher.getDocSet(this.query);
            this.topCollector = this.newCollector(this.groupSort, Grouping.this.needScores);
            this.collector = new FilterCollector(groupFilt, (Collector)this.topCollector);
            return this.collector;
        }

        TopDocsCollector newCollector(Sort sort, boolean needScores) throws IOException {
            int groupDocsToCollect = Grouping.this.getMax(this.groupOffset, this.docsPerGroup, Grouping.this.maxDoc);
            if (sort == null || sort == Sort.RELEVANCE) {
                return TopScoreDocCollector.create((int)groupDocsToCollect, (boolean)true);
            }
            return TopFieldCollector.create((Sort)Grouping.this.searcher.weightSort(sort), (int)groupDocsToCollect, (boolean)false, (boolean)needScores, (boolean)needScores, (boolean)true);
        }

        @Override
        protected void finish() throws IOException {
            TopDocsCollector topDocsCollector = (TopDocsCollector)this.collector.getDelegate();
            TopDocs topDocs = topDocsCollector.topDocs();
            GroupDocs groupDocs = new GroupDocs(Float.NaN, topDocs.getMaxScore(), topDocs.totalHits, topDocs.scoreDocs, (Object)this.query.toString(), null);
            if (this.main) {
                Grouping.this.mainResult = this.getDocList(groupDocs);
            } else {
                NamedList rsp = this.commonResponse();
                this.addDocList(rsp, groupDocs);
            }
        }

        @Override
        public int getMatches() {
            return this.collector.getMatches();
        }
    }

    public class CommandField
    extends Command<BytesRef> {
        public String groupBy;
        TermFirstPassGroupingCollector firstPass;
        TermSecondPassGroupingCollector secondPass;
        TermAllGroupsCollector allGroupsCollector;
        TotalHitCountCollector fallBackCollector;
        Collection<SearchGroup<BytesRef>> topGroups;

        @Override
        protected void prepare() throws IOException {
            this.actualGroupsToFind = Grouping.this.getMax(this.offset, this.numGroups, Grouping.this.maxDoc);
        }

        @Override
        protected Collector createFirstPassCollector() throws IOException {
            if (this.actualGroupsToFind <= 0) {
                this.fallBackCollector = new TotalHitCountCollector();
                return this.fallBackCollector;
            }
            this.sort = this.sort == null ? Sort.RELEVANCE : this.sort;
            this.firstPass = new TermFirstPassGroupingCollector(this.groupBy, this.sort, this.actualGroupsToFind);
            return this.firstPass;
        }

        @Override
        protected Collector createSecondPassCollector() throws IOException {
            if (this.actualGroupsToFind <= 0) {
                this.allGroupsCollector = new TermAllGroupsCollector(this.groupBy);
                return this.totalCount == TotalCount.grouped ? this.allGroupsCollector : null;
            }
            Collection collection = this.topGroups = this.format == Format.grouped ? this.firstPass.getTopGroups(this.offset, false) : this.firstPass.getTopGroups(0, false);
            if (this.topGroups == null) {
                if (this.totalCount == TotalCount.grouped) {
                    this.allGroupsCollector = new TermAllGroupsCollector(this.groupBy);
                    this.fallBackCollector = new TotalHitCountCollector();
                    return MultiCollector.wrap((Collector[])new Collector[]{this.allGroupsCollector, this.fallBackCollector});
                }
                this.fallBackCollector = new TotalHitCountCollector();
                return this.fallBackCollector;
            }
            int groupedDocsToCollect = Grouping.this.getMax(this.groupOffset, this.docsPerGroup, Grouping.this.maxDoc);
            groupedDocsToCollect = Math.max(groupedDocsToCollect, 1);
            this.secondPass = new TermSecondPassGroupingCollector(this.groupBy, this.topGroups, this.sort, this.groupSort, groupedDocsToCollect, Grouping.this.needScores, Grouping.this.needScores, false);
            if (this.totalCount == TotalCount.grouped) {
                this.allGroupsCollector = new TermAllGroupsCollector(this.groupBy);
                return MultiCollector.wrap((Collector[])new Collector[]{this.secondPass, this.allGroupsCollector});
            }
            return this.secondPass;
        }

        @Override
        public AbstractAllGroupHeadsCollector<?> createAllGroupCollector() throws IOException {
            Sort sortWithinGroup = this.groupSort != null ? this.groupSort : new Sort();
            return TermAllGroupHeadsCollector.create((String)this.groupBy, (Sort)sortWithinGroup);
        }

        @Override
        protected void finish() throws IOException {
            TopGroups topGroups = this.result = this.secondPass != null ? this.secondPass.getTopGroups(0) : null;
            if (this.main) {
                Grouping.this.mainResult = this.createSimpleResponse();
                return;
            }
            NamedList groupResult = this.commonResponse();
            if (this.format == Format.simple) {
                groupResult.add("doclist", (Object)this.createSimpleResponse());
                return;
            }
            ArrayList<SimpleOrderedMap> groupList = new ArrayList<SimpleOrderedMap>();
            groupResult.add("groups", groupList);
            if (this.result == null) {
                return;
            }
            if (this.numGroups == 0) {
                return;
            }
            for (GroupDocs group : this.result.groups) {
                SimpleOrderedMap nl = new SimpleOrderedMap();
                groupList.add(nl);
                if (group.groupValue != null) {
                    SchemaField schemaField = Grouping.this.searcher.getSchema().getField(this.groupBy);
                    FieldType fieldType = schemaField.getType();
                    String readableValue = fieldType.indexedToReadable(((BytesRef)group.groupValue).utf8ToString());
                    IndexableField field = schemaField.createField(readableValue, 1.0f);
                    nl.add("groupValue", fieldType.toObject(field));
                } else {
                    nl.add("groupValue", null);
                }
                this.addDocList((NamedList)nl, group);
            }
        }

        @Override
        public int getMatches() {
            if (this.result == null && this.fallBackCollector == null) {
                return 0;
            }
            return this.result != null ? this.result.totalHitCount : this.fallBackCollector.getTotalHits();
        }

        @Override
        protected Integer getNumberOfGroups() {
            return this.allGroupsCollector == null ? null : Integer.valueOf(this.allGroupsCollector.getGroupCount());
        }
    }

    public abstract class Command<GROUP_VALUE_TYPE> {
        public String key;
        public Sort groupSort;
        public Sort sort;
        public int docsPerGroup;
        public int groupOffset;
        public int numGroups;
        int actualGroupsToFind;
        public int offset;
        public Format format;
        public boolean main;
        public TotalCount totalCount = TotalCount.ungrouped;
        TopGroups<GROUP_VALUE_TYPE> result;

        protected abstract void prepare() throws IOException;

        protected abstract Collector createFirstPassCollector() throws IOException;

        protected Collector createSecondPassCollector() throws IOException {
            return null;
        }

        public AbstractAllGroupHeadsCollector<?> createAllGroupCollector() throws IOException {
            return null;
        }

        protected abstract void finish() throws IOException;

        public abstract int getMatches();

        protected Integer getNumberOfGroups() {
            return null;
        }

        protected NamedList commonResponse() {
            SimpleOrderedMap groupResult = new SimpleOrderedMap();
            Grouping.this.grouped.add(this.key, (Object)groupResult);
            int matches = this.getMatches();
            groupResult.add("matches", (Object)matches);
            if (this.totalCount == TotalCount.grouped) {
                Integer totalNrOfGroups = this.getNumberOfGroups();
                groupResult.add("ngroups", (Object)(totalNrOfGroups == null ? 0 : totalNrOfGroups));
            }
            Grouping.this.maxMatches = Math.max(Grouping.this.maxMatches, matches);
            return groupResult;
        }

        protected DocList getDocList(GroupDocs groups) {
            int max = groups.totalHits;
            int off = this.groupOffset;
            int len = this.docsPerGroup;
            if (this.format == Format.simple) {
                off = this.offset;
                len = this.numGroups;
            }
            int docsToCollect = Grouping.this.getMax(off, len, max);
            int docsCollected = Math.min(docsToCollect, groups.scoreDocs.length);
            int[] ids = new int[docsCollected];
            float[] scores = Grouping.this.needScores ? new float[docsCollected] : null;
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = groups.scoreDocs[i].doc;
                if (scores == null) continue;
                scores[i] = groups.scoreDocs[i].score;
            }
            float score = groups.maxScore;
            Grouping.this.maxScore = Math.max(Grouping.this.maxScore, score);
            DocSlice docs = new DocSlice(off, Math.max(0, ids.length - off), ids, scores, groups.totalHits, score);
            if (Grouping.this.getDocList) {
                DocIterator iter = docs.iterator();
                while (iter.hasNext()) {
                    Grouping.this.idSet.add(iter.nextDoc());
                }
            }
            return docs;
        }

        protected void addDocList(NamedList rsp, GroupDocs groups) {
            rsp.add("doclist", (Object)this.getDocList(groups));
        }

        protected DocList createSimpleResponse() {
            GroupDocs[] groups = this.result != null ? this.result.groups : new GroupDocs[]{};
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ArrayList<Float> scores = new ArrayList<Float>();
            int docsToGather = Grouping.this.getMax(this.offset, this.numGroups, Grouping.this.maxDoc);
            int docsGathered = 0;
            float maxScore = Float.NEGATIVE_INFINITY;
            block0: for (GroupDocs group : groups) {
                if (group.maxScore > maxScore) {
                    maxScore = group.maxScore;
                }
                for (ScoreDoc scoreDoc : group.scoreDocs) {
                    if (docsGathered >= docsToGather) break block0;
                    ids.add(scoreDoc.doc);
                    scores.add(Float.valueOf(scoreDoc.score));
                    ++docsGathered;
                }
            }
            int len = docsGathered > this.offset ? docsGathered - this.offset : 0;
            int[] docs = ArrayUtils.toPrimitive((Integer[])ids.toArray(new Integer[ids.size()]));
            float[] docScores = ArrayUtils.toPrimitive((Float[])scores.toArray(new Float[scores.size()]));
            DocSlice docSlice = new DocSlice(this.offset, len, docs, docScores, this.getMatches(), maxScore);
            if (Grouping.this.getDocList) {
                for (int i = this.offset; i < docs.length; ++i) {
                    Grouping.this.idSet.add(docs[i]);
                }
            }
            return docSlice;
        }
    }

    public static enum TotalCount {
        grouped,
        ungrouped;

    }

    public static enum Format {
        grouped,
        simple;

    }
}

