/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.queries.function.BoostedQuery;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.ProductFloatFunction;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.params.DisMaxParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.DisMaxQParser;
import org.apache.solr.search.FieldParams;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.util.SolrPluginUtils;

class ExtendedDismaxQParser
extends QParser {
    private static String IMPOSSIBLE_FIELD_NAME = "\ufffc\ufffc\ufffc";
    private Map<String, Float> queryFields;
    private UserFields userFields;
    private Query parsedUserQuery;
    private String[] boostParams;
    private String[] multBoosts;
    private List<Query> boostQueries;
    private Query altUserQuery;
    private QParser altQParser;
    private SolrParams solrParams;
    static final RuntimeException unknownField = new RuntimeException("UnknownField");

    public ExtendedDismaxQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Query parse() throws ParseException {
        String[] boostFuncs;
        SolrParams localParams = this.getLocalParams();
        SolrParams params = this.getParams();
        this.solrParams = SolrParams.wrapDefaults((SolrParams)localParams, (SolrParams)params);
        String minShouldMatch = DisMaxQParser.parseMinShouldMatch(this.req.getSchema(), this.solrParams);
        this.userFields = new UserFields(U.parseFieldBoosts(this.solrParams.getParams("uf")));
        this.queryFields = DisMaxQParser.parseQueryFields(this.req.getSchema(), this.solrParams);
        int[] pslop = new int[4];
        pslop[0] = this.solrParams.getInt("ps", 0);
        pslop[2] = this.solrParams.getInt("ps2", pslop[0]);
        pslop[3] = this.solrParams.getInt("ps3", pslop[0]);
        List<FieldParams> phraseFields = U.parseFieldBoostsAndSlop(this.solrParams.getParams("pf"), 0, pslop[0]);
        List<FieldParams> phraseFields2 = U.parseFieldBoostsAndSlop(this.solrParams.getParams("pf2"), 2, pslop[2]);
        List<FieldParams> phraseFields3 = U.parseFieldBoostsAndSlop(this.solrParams.getParams("pf3"), 3, pslop[3]);
        float tiebreaker = this.solrParams.getFloat("tie", 0.0f);
        int qslop = this.solrParams.getInt("qs", 0);
        boolean stopwords = this.solrParams.getBool("stopwords", true);
        BooleanQuery query = new BooleanQuery(true);
        this.parsedUserQuery = null;
        String userQuery = this.getString();
        this.altUserQuery = null;
        if (userQuery == null || userQuery.trim().length() == 0) {
            String altQ = this.solrParams.get("q.alt");
            if (altQ == null) return null;
            this.altQParser = this.subQuery(altQ, null);
            this.altUserQuery = this.altQParser.getQuery();
            query.add(this.altUserQuery, BooleanClause.Occur.MUST);
        } else {
            boolean lowercaseOperators = this.solrParams.getBool("lowercaseOperators", true);
            String mainUserQuery = userQuery;
            ExtendedSolrQueryParser up = new ExtendedSolrQueryParser(this, IMPOSSIBLE_FIELD_NAME);
            up.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, this.queryFields);
            this.addAliasesFromRequest(up, tiebreaker);
            up.setPhraseSlop(qslop);
            up.setAllowLeadingWildcard(true);
            List<Clause> clauses = null;
            int numPluses = 0;
            int numMinuses = 0;
            int numOR = 0;
            int numNOT = 0;
            clauses = this.splitIntoClauses(userQuery, false);
            for (Clause clause : clauses) {
                if (clause.must == '+') {
                    ++numPluses;
                }
                if (clause.must == '-') {
                    ++numMinuses;
                }
                if (!clause.isBareWord()) continue;
                String s = clause.val;
                if ("OR".equals(s)) {
                    ++numOR;
                    continue;
                }
                if ("NOT".equals(s)) {
                    ++numNOT;
                    continue;
                }
                if (!lowercaseOperators || !"or".equals(s)) continue;
                ++numOR;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < clauses.size(); ++i) {
                Clause clause = clauses.get(i);
                String s = clause.raw;
                if (lowercaseOperators && i > 0 && i + 1 < clauses.size()) {
                    if ("AND".equalsIgnoreCase(s)) {
                        s = "AND";
                    } else if ("OR".equalsIgnoreCase(s)) {
                        s = "OR";
                    }
                }
                stringBuilder.append(s);
                stringBuilder.append(' ');
            }
            mainUserQuery = stringBuilder.toString();
            boolean doMinMatched = numOR + numNOT + numPluses + numMinuses == 0;
            try {
                up.setRemoveStopFilter(!stopwords);
                up.exceptions = true;
                this.parsedUserQuery = up.parse(mainUserQuery);
                if (stopwords && ExtendedDismaxQParser.isEmpty(this.parsedUserQuery)) {
                    up.setRemoveStopFilter(true);
                    this.parsedUserQuery = up.parse(mainUserQuery);
                }
            }
            catch (Exception e) {
                up.exceptions = false;
            }
            if (this.parsedUserQuery != null && doMinMatched && this.parsedUserQuery instanceof BooleanQuery) {
                SolrPluginUtils.setMinShouldMatch((BooleanQuery)this.parsedUserQuery, minShouldMatch);
            }
            if (this.parsedUserQuery == null) {
                StringBuilder stringBuilder2 = new StringBuilder();
                for (Clause clause : clauses) {
                    Float boost;
                    boolean doQuote = clause.isPhrase;
                    String s = clause.val;
                    if (!clause.isPhrase && ("OR".equals(s) || "AND".equals(s) || "NOT".equals(s))) {
                        doQuote = true;
                    }
                    if (clause.must != '\u0000') {
                        stringBuilder2.append(clause.must);
                    }
                    if (clause.field != null) {
                        stringBuilder2.append(clause.field);
                        stringBuilder2.append(':');
                    }
                    if (doQuote) {
                        stringBuilder2.append('\"');
                    }
                    stringBuilder2.append(clause.val);
                    if (doQuote) {
                        stringBuilder2.append('\"');
                    }
                    if (clause.field != null && (boost = this.userFields.getBoost(clause.field)) != null) {
                        stringBuilder2.append("^").append(boost);
                    }
                    stringBuilder2.append(' ');
                }
                String escapedUserQuery = stringBuilder2.toString();
                this.parsedUserQuery = up.parse(escapedUserQuery);
                if (this.parsedUserQuery instanceof BooleanQuery) {
                    BooleanQuery t = new BooleanQuery();
                    SolrPluginUtils.flattenBooleanQuery(t, (BooleanQuery)this.parsedUserQuery);
                    SolrPluginUtils.setMinShouldMatch(t, minShouldMatch);
                    this.parsedUserQuery = t;
                }
            }
            query.add(this.parsedUserQuery, BooleanClause.Occur.MUST);
            ArrayList<FieldParams> allPhraseFields = new ArrayList<FieldParams>();
            allPhraseFields.addAll(phraseFields);
            allPhraseFields.addAll(phraseFields2);
            allPhraseFields.addAll(phraseFields3);
            if (allPhraseFields.size() > 0) {
                ArrayList<Clause> normalClauses = new ArrayList<Clause>(clauses.size());
                for (Clause clause : clauses) {
                    String s;
                    if (clause.field != null || clause.isPhrase || clause.isBareWord() && ("OR".equals(s = clause.val.toString()) || "AND".equals(s) || "NOT".equals(s) || "TO".equals(s))) continue;
                    normalClauses.add(clause);
                }
                for (FieldParams phraseField : allPhraseFields) {
                    HashMap<String, Float> pf = new HashMap<String, Float>(1);
                    pf.put(phraseField.getField(), Float.valueOf(phraseField.getBoost()));
                    this.addShingledPhraseQueries(query, normalClauses, pf, phraseField.getWordGrams(), tiebreaker, phraseField.getSlop());
                }
            }
        }
        this.boostParams = this.solrParams.getParams("bq");
        this.boostQueries = null;
        if (this.boostParams != null && this.boostParams.length > 0) {
            Map<String, Float> bqBoosts = SolrPluginUtils.parseFieldBoosts(this.boostParams);
            this.boostQueries = new ArrayList<Query>();
            for (Map.Entry<String, Float> bqs : bqBoosts.entrySet()) {
                if (bqs.getKey().trim().length() == 0) continue;
                Query q = this.subQuery(bqs.getKey(), null).getQuery();
                Float b = bqs.getValue();
                if (b != null) {
                    q.setBoost(b.floatValue());
                }
                this.boostQueries.add(q);
            }
        }
        if (null != this.boostQueries) {
            for (Query f : this.boostQueries) {
                query.add(f, BooleanClause.Occur.SHOULD);
            }
        }
        if (null != (boostFuncs = this.solrParams.getParams("bf")) && 0 != boostFuncs.length) {
            for (String boostFunc : boostFuncs) {
                if (null == boostFunc || "".equals(boostFunc)) continue;
                Map<String, Float> ff = SolrPluginUtils.parseFieldBoosts(boostFunc);
                for (String f : ff.keySet()) {
                    Query query2 = this.subQuery(f, FunctionQParserPlugin.NAME).getQuery();
                    Float b = ff.get(f);
                    if (null != b) {
                        query2.setBoost(b.floatValue());
                    }
                    query.add(query2, BooleanClause.Occur.SHOULD);
                }
            }
        }
        BooleanQuery topQuery = query;
        this.multBoosts = this.solrParams.getParams("boost");
        if (this.multBoosts == null) return topQuery;
        if (this.multBoosts.length <= 0) return topQuery;
        ArrayList<void> boosts = new ArrayList<void>();
        for (String boostStr : this.multBoosts) {
            void var21_44;
            if (boostStr == null || boostStr.length() == 0) continue;
            Query boost = this.subQuery(boostStr, FunctionQParserPlugin.NAME).getQuery();
            if (boost instanceof FunctionQuery) {
                ValueSource valueSource = ((FunctionQuery)boost).getValueSource();
            } else {
                QueryValueSource queryValueSource = new QueryValueSource(boost, 1.0f);
            }
            boosts.add(var21_44);
        }
        if (boosts.size() > 1) {
            ProductFloatFunction prod = new ProductFloatFunction(boosts.toArray(new ValueSource[boosts.size()]));
            return new BoostedQuery((Query)query, (ValueSource)prod);
        }
        if (boosts.size() != 1) return topQuery;
        return new BoostedQuery((Query)query, (ValueSource)boosts.get(0));
    }

    private void addAliasesFromRequest(ExtendedSolrQueryParser up, float tiebreaker) {
        Iterator it = this.solrParams.getParameterNamesIterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (!param.startsWith("f.") || !param.endsWith(".qf")) continue;
            String fname = param.substring(2, param.length() - 3);
            String qfReplacement = this.solrParams.get(param);
            Map<String, Float> parsedQf = SolrPluginUtils.parseFieldBoosts(qfReplacement);
            if (parsedQf.size() == 0) {
                return;
            }
            up.addAlias(fname, tiebreaker, parsedQf);
        }
    }

    private void addShingledPhraseQueries(BooleanQuery mainQuery, List<Clause> clauses, Map<String, Float> fields, int shingleSize, float tiebreaker, int slop) throws ParseException {
        if (null == fields || fields.isEmpty() || null == clauses || clauses.size() < shingleSize) {
            return;
        }
        if (0 == shingleSize) {
            shingleSize = clauses.size();
        }
        int goat = shingleSize - 1;
        StringBuilder userPhraseQuery = new StringBuilder();
        for (int i = 0; i < clauses.size() - goat; ++i) {
            userPhraseQuery.append('\"');
            for (int j = 0; j <= goat; ++j) {
                userPhraseQuery.append(clauses.get((int)(i + j)).val);
                userPhraseQuery.append(' ');
            }
            userPhraseQuery.append('\"');
            userPhraseQuery.append(' ');
        }
        ExtendedSolrQueryParser pp = new ExtendedSolrQueryParser(this, IMPOSSIBLE_FIELD_NAME);
        pp.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, fields);
        pp.setPhraseSlop(slop);
        pp.setRemoveStopFilter(true);
        pp.makeDismax = true;
        pp.minClauseSize = 2;
        Query phrase = pp.parse(userPhraseQuery.toString());
        if (phrase != null) {
            mainQuery.add(phrase, BooleanClause.Occur.SHOULD);
        }
    }

    @Override
    public String[] getDefaultHighlightFields() {
        String[] highFields = this.queryFields.keySet().toArray(new String[0]);
        return highFields;
    }

    @Override
    public Query getHighlightQuery() throws ParseException {
        return this.parsedUserQuery == null ? this.altUserQuery : this.parsedUserQuery;
    }

    @Override
    public void addDebugInfo(NamedList<Object> debugInfo) {
        super.addDebugInfo(debugInfo);
        debugInfo.add("altquerystring", (Object)this.altUserQuery);
        if (null != this.boostQueries) {
            debugInfo.add("boost_queries", (Object)this.boostParams);
            debugInfo.add("parsed_boost_queries", QueryParsing.toString(this.boostQueries, this.getReq().getSchema()));
        }
        debugInfo.add("boostfuncs", (Object)this.getReq().getParams().getParams("bf"));
    }

    public List<Clause> splitIntoClauses(String s, boolean ignoreQuote) {
        ArrayList<Clause> lst = new ArrayList<Clause>(4);
        int pos = 0;
        int end = s.length();
        char ch = '\u0000';
        while (pos < end) {
            Clause clause = new Clause();
            boolean disallowUserField = true;
            ch = s.charAt(pos);
            while (Character.isWhitespace(ch) && ++pos < end) {
                ch = s.charAt(pos);
            }
            int start = pos;
            if (ch == '+' || ch == '-') {
                clause.must = ch;
                ++pos;
            }
            clause.field = this.getFieldName(s, pos, end);
            if (clause.field != null && !this.userFields.isAllowed(clause.field)) {
                clause.field = null;
            }
            if (clause.field != null) {
                disallowUserField = false;
                int colon = s.indexOf(58, pos);
                clause.rawField = s.substring(pos, colon);
                pos += colon - pos;
                ++pos;
            }
            if (pos >= end) break;
            char inString = '\u0000';
            ch = s.charAt(pos);
            if (!ignoreQuote && ch == '\"') {
                clause.isPhrase = true;
                inString = '\"';
                ++pos;
            }
            StringBuilder sb = new StringBuilder();
            while (pos < end) {
                if ((ch = s.charAt(pos++)) == '\\') {
                    sb.append(ch);
                    if (pos >= end) {
                        sb.append(ch);
                        break;
                    }
                    ch = s.charAt(pos++);
                    sb.append(ch);
                    continue;
                }
                if (inString != '\u0000' && ch == inString) {
                    inString = '\u0000';
                    break;
                }
                if (Character.isWhitespace(ch)) {
                    clause.hasWhitespace = true;
                    if (inString == '\u0000') {
                        --pos;
                        break;
                    }
                }
                if (inString == '\u0000') {
                    switch (ch) {
                        case '!': 
                        case '\"': 
                        case '&': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case ':': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': 
                        case '~': {
                            clause.hasSpecialSyntax = true;
                            sb.append('\\');
                        }
                    }
                } else if (ch == '\"') {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            clause.val = sb.toString();
            if (clause.isPhrase) {
                if (inString != '\u0000') {
                    return this.splitIntoClauses(s, true);
                }
                clause.hasSpecialSyntax = false;
            } else if (clause.val.length() == 0) {
                clause.syntaxError = true;
                if (clause.must != '\u0000') {
                    clause.val = "\\" + clause.must;
                    clause.must = '\u0000';
                    clause.hasSpecialSyntax = true;
                } else {
                    clause = null;
                }
            }
            if (clause == null) continue;
            if (disallowUserField) {
                clause.raw = s.substring(start, pos);
                if (!"*:*".equals(clause.raw)) {
                    clause.raw = clause.raw.replaceAll(":", "\\\\:");
                }
            } else {
                Float boost;
                clause.raw = s.substring(start, pos);
                if (this.userFields.isAllowed(clause.field) && !clause.raw.contains("^") && (boost = this.userFields.getBoost(clause.field)) != null) {
                    clause.raw = clause.raw + "^" + boost;
                }
            }
            lst.add(clause);
        }
        return lst;
    }

    public String getFieldName(String s, int pos, int end) {
        if (pos >= end) {
            return null;
        }
        int p = pos;
        int colon = s.indexOf(58, pos);
        if (colon <= pos || colon + 1 >= end || Character.isWhitespace(s.charAt(colon + 1))) {
            return null;
        }
        char ch = s.charAt(p++);
        while ((ch == '(' || ch == '+' || ch == '-') && pos < end) {
            ch = s.charAt(p++);
            ++pos;
        }
        if (!Character.isJavaIdentifierPart(ch)) {
            return null;
        }
        while (p < colon) {
            if (Character.isJavaIdentifierPart(ch = s.charAt(p++)) || ch == '-' || ch == '.') continue;
            return null;
        }
        String fname = s.substring(pos, p);
        boolean isInSchema = this.getReq().getSchema().getFieldTypeNoEx(fname) != null;
        boolean isAlias = this.solrParams.get("f." + fname + ".qf") != null;
        boolean isMagic = null != SolrQueryParser.MagicFieldName.get(fname);
        return isInSchema || isAlias || isMagic ? fname : null;
    }

    public static List<String> split(String s, boolean ignoreQuote) {
        ArrayList<String> lst = new ArrayList<String>(4);
        int pos = 0;
        int start = 0;
        int end = s.length();
        char inString = '\u0000';
        char ch = '\u0000';
        while (pos < end) {
            char prevChar = ch;
            if ((ch = s.charAt(pos++)) == '\\') {
                ++pos;
                continue;
            }
            if (inString != '\u0000' && ch == inString) {
                inString = '\u0000';
                continue;
            }
            if (!ignoreQuote && ch == '\"') {
                if (Character.isLetterOrDigit(prevChar)) continue;
                inString = ch;
                continue;
            }
            if (!Character.isWhitespace(ch) || inString != '\u0000') continue;
            lst.add(s.substring(start, pos - 1));
            start = pos;
        }
        if (start < end) {
            lst.add(s.substring(start, end));
        }
        if (inString != '\u0000') {
            return ExtendedDismaxQParser.split(s, true);
        }
        return lst;
    }

    static boolean isEmpty(Query q) {
        if (q == null) {
            return true;
        }
        return q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() == 0;
    }

    static {
        unknownField.fillInStackTrace();
    }

    static class DynamicField
    implements Comparable<DynamicField> {
        static final int STARTS_WITH = 1;
        static final int ENDS_WITH = 2;
        static final int CATCHALL = 3;
        final String wildcard;
        final int type;
        final String str;

        protected DynamicField(String wildcard) {
            this.wildcard = wildcard;
            if (wildcard.equals("*")) {
                this.type = 3;
                this.str = null;
            } else if (wildcard.startsWith("*")) {
                this.type = 2;
                this.str = wildcard.substring(1);
            } else if (wildcard.endsWith("*")) {
                this.type = 1;
                this.str = wildcard.substring(0, wildcard.length() - 1);
            } else {
                throw new RuntimeException("dynamic field name must start or end with *");
            }
        }

        public boolean matches(String name) {
            if (this.type == 3) {
                return true;
            }
            if (this.type == 1 && name.startsWith(this.str)) {
                return true;
            }
            return this.type == 2 && name.endsWith(this.str);
        }

        @Override
        public int compareTo(DynamicField other) {
            return other.wildcard.length() - this.wildcard.length();
        }

        public String toString() {
            return this.wildcard;
        }
    }

    static class UserFields {
        private Map<String, Float> userFieldsMap;
        private DynamicField[] dynamicUserFields;
        private DynamicField[] negativeDynamicUserFields;

        UserFields(Map<String, Float> ufm) {
            this.userFieldsMap = ufm;
            if (0 == this.userFieldsMap.size()) {
                this.userFieldsMap.put("*", null);
            }
            ArrayList<DynamicField> dynUserFields = new ArrayList<DynamicField>();
            ArrayList<DynamicField> negDynUserFields = new ArrayList<DynamicField>();
            for (String f : this.userFieldsMap.keySet()) {
                if (!f.contains("*")) continue;
                if (f.startsWith("-")) {
                    negDynUserFields.add(new DynamicField(f.substring(1)));
                    continue;
                }
                dynUserFields.add(new DynamicField(f));
            }
            Collections.sort(dynUserFields);
            this.dynamicUserFields = dynUserFields.toArray(new DynamicField[dynUserFields.size()]);
            Collections.sort(negDynUserFields);
            this.negativeDynamicUserFields = negDynUserFields.toArray(new DynamicField[negDynUserFields.size()]);
        }

        public boolean isAllowed(String fname) {
            boolean res = (this.userFieldsMap.containsKey(fname) || this.isDynField(fname, false)) && !this.userFieldsMap.containsKey("-" + fname) && !this.isDynField(fname, true);
            return res;
        }

        private boolean isDynField(String field, boolean neg) {
            return this.getDynFieldForName(field, neg) != null;
        }

        private String getDynFieldForName(String f, boolean neg) {
            for (DynamicField df : neg ? this.negativeDynamicUserFields : this.dynamicUserFields) {
                if (!df.matches(f)) continue;
                return df.wildcard;
            }
            return null;
        }

        public Float getBoost(String field) {
            return this.userFieldsMap.containsKey(field) ? this.userFieldsMap.get(field) : this.userFieldsMap.get(this.getDynFieldForName(field, false));
        }
    }

    static class ExtendedSolrQueryParser
    extends SolrQueryParser {
        boolean makeDismax = true;
        boolean disableCoord = true;
        boolean allowWildcard = true;
        int minClauseSize = 0;
        boolean exceptions;
        private Map<String, Analyzer> nonStopFilterAnalyzerPerField;
        private boolean removeStopFilter;
        protected Map<String, Alias> aliases = new HashMap<String, Alias>(3);
        QType type;
        String field;
        String val;
        String val2;
        boolean bool;
        boolean bool2;
        float flt;
        int slop;

        public ExtendedSolrQueryParser(QParser parser, String defaultField) {
            super(parser, defaultField, null);
            this.setDefaultOperator(QueryParser.Operator.OR);
        }

        public void setRemoveStopFilter(boolean remove) {
            this.removeStopFilter = remove;
        }

        protected Query getBooleanQuery(List clauses, boolean disableCoord) throws ParseException {
            Query q = super.getBooleanQuery(clauses, disableCoord);
            if (q != null) {
                q = QueryUtils.makeQueryable(q);
            }
            return q;
        }

        protected void addClause(List clauses, int conj, int mods, Query q) {
            super.addClause(clauses, conj, mods, q);
        }

        public void addAlias(String field, float tiebreaker, Map<String, Float> fieldBoosts) {
            Alias a = new Alias();
            a.tie = tiebreaker;
            a.fields = fieldBoosts;
            this.aliases.put(field, a);
        }

        public Alias getAlias(String field) {
            return this.aliases.get(field);
        }

        @Override
        protected Query getFieldQuery(String field, String val, boolean quoted) throws ParseException {
            this.type = QType.FIELD;
            this.field = field;
            this.val = val;
            this.slop = this.getPhraseSlop();
            return this.getAliasedQuery();
        }

        protected Query getFieldQuery(String field, String val, int slop) throws ParseException {
            this.type = QType.PHRASE;
            this.field = field;
            this.val = val;
            this.slop = slop;
            return this.getAliasedQuery();
        }

        @Override
        protected Query getPrefixQuery(String field, String val) throws ParseException {
            if (val.equals("") && field.equals("*")) {
                return new MatchAllDocsQuery();
            }
            this.type = QType.PREFIX;
            this.field = field;
            this.val = val;
            return this.getAliasedQuery();
        }

        protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws ParseException {
            Analyzer actualAnalyzer;
            if (this.removeStopFilter) {
                if (this.nonStopFilterAnalyzerPerField == null) {
                    this.nonStopFilterAnalyzerPerField = new HashMap<String, Analyzer>();
                }
                if ((actualAnalyzer = this.nonStopFilterAnalyzerPerField.get(field)) == null) {
                    actualAnalyzer = this.noStopwordFilterAnalyzer(field);
                }
            } else {
                actualAnalyzer = this.parser.getReq().getSchema().getFieldType(field).getQueryAnalyzer();
            }
            return super.newFieldQuery(actualAnalyzer, field, queryText, quoted);
        }

        @Override
        protected Query getRangeQuery(String field, String a, String b, boolean startInclusive, boolean endInclusive) throws ParseException {
            this.type = QType.RANGE;
            this.field = field;
            this.val = a;
            this.val2 = b;
            this.bool = startInclusive;
            this.bool2 = endInclusive;
            return this.getAliasedQuery();
        }

        @Override
        protected Query getWildcardQuery(String field, String val) throws ParseException {
            if (val.equals("*")) {
                if (field.equals("*")) {
                    return new MatchAllDocsQuery();
                }
                return this.getPrefixQuery(field, "");
            }
            this.type = QType.WILDCARD;
            this.field = field;
            this.val = val;
            return this.getAliasedQuery();
        }

        protected Query getFuzzyQuery(String field, String val, float minSimilarity) throws ParseException {
            this.type = QType.FUZZY;
            this.field = field;
            this.val = val;
            this.flt = minSimilarity;
            return this.getAliasedQuery();
        }

        protected Query getAliasedQuery() throws ParseException {
            FieldType ft;
            Alias a = this.aliases.get(this.field);
            this.validateCyclicAliasing(this.field);
            if (a != null) {
                List<Query> lst = this.getQueries(a);
                if (lst == null || lst.size() == 0) {
                    return this.getQuery();
                }
                if (this.makeDismax) {
                    DisjunctionMaxQuery q = new DisjunctionMaxQuery(lst, a.tie);
                    return q;
                }
                BooleanQuery q = new BooleanQuery(this.disableCoord);
                for (Query sub : lst) {
                    q.add(sub, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            if (this.exceptions && (ft = this.schema.getFieldTypeNoEx(this.field)) == null && null == SolrQueryParser.MagicFieldName.get(this.field)) {
                throw unknownField;
            }
            return this.getQuery();
        }

        private void validateCyclicAliasing(String field) throws ParseException {
            HashSet<String> set = new HashSet<String>();
            set.add(field);
            if (this.validateField(field, set)) {
                throw new ParseException("Field aliases lead to a cycle");
            }
        }

        private boolean validateField(String field, Set<String> set) {
            if (this.getAlias(field) == null) {
                return false;
            }
            boolean hascycle = false;
            for (String referencedField : this.getAlias((String)field).fields.keySet()) {
                if (!set.add(referencedField)) {
                    hascycle = true;
                    continue;
                }
                if (this.validateField(referencedField, set)) {
                    hascycle = true;
                }
                set.remove(referencedField);
            }
            return hascycle;
        }

        protected List<Query> getQueries(Alias a) throws ParseException {
            if (a == null) {
                return null;
            }
            if (a.fields.size() == 0) {
                return null;
            }
            ArrayList<Query> lst = new ArrayList<Query>(4);
            Iterator<String> i$ = a.fields.keySet().iterator();
            while (i$.hasNext()) {
                String f;
                this.field = f = i$.next();
                Query sub = this.getAliasedQuery();
                if (sub == null) continue;
                Float boost = a.fields.get(f);
                if (boost != null) {
                    sub.setBoost(boost.floatValue());
                }
                lst.add(sub);
            }
            return lst;
        }

        private Query getQuery() {
            try {
                switch (this.type) {
                    case FIELD: 
                    case PHRASE: {
                        Query query = super.getFieldQuery(this.field, this.val, this.type == QType.PHRASE);
                        if (query instanceof PhraseQuery) {
                            PhraseQuery pq = (PhraseQuery)query;
                            if (this.minClauseSize > 1 && pq.getTerms().length < this.minClauseSize) {
                                return null;
                            }
                            ((PhraseQuery)query).setSlop(this.slop);
                        } else if (query instanceof MultiPhraseQuery) {
                            MultiPhraseQuery pq = (MultiPhraseQuery)query;
                            if (this.minClauseSize > 1 && pq.getTermArrays().size() < this.minClauseSize) {
                                return null;
                            }
                            ((MultiPhraseQuery)query).setSlop(this.slop);
                        } else if (this.minClauseSize > 1) {
                            return null;
                        }
                        return query;
                    }
                    case PREFIX: {
                        return super.getPrefixQuery(this.field, this.val);
                    }
                    case WILDCARD: {
                        return super.getWildcardQuery(this.field, this.val);
                    }
                    case FUZZY: {
                        return super.getFuzzyQuery(this.field, this.val, this.flt);
                    }
                    case RANGE: {
                        return super.getRangeQuery(this.field, this.val, this.val2, this.bool, this.bool2);
                    }
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        private Analyzer noStopwordFilterAnalyzer(String fieldName) {
            FieldType ft = this.parser.getReq().getSchema().getFieldType(fieldName);
            Analyzer qa = ft.getQueryAnalyzer();
            if (!(qa instanceof TokenizerChain)) {
                return qa;
            }
            TokenizerChain tcq = (TokenizerChain)qa;
            Analyzer ia = ft.getAnalyzer();
            if (ia == qa || !(ia instanceof TokenizerChain)) {
                return qa;
            }
            TokenizerChain tci = (TokenizerChain)ia;
            for (TokenFilterFactory tf : tci.getTokenFilterFactories()) {
                if (!(tf instanceof StopFilterFactory)) continue;
                return qa;
            }
            int stopIdx = -1;
            TokenFilterFactory[] facs = tcq.getTokenFilterFactories();
            for (int i = 0; i < facs.length; ++i) {
                TokenFilterFactory tf;
                tf = facs[i];
                if (!(tf instanceof StopFilterFactory)) continue;
                stopIdx = i;
                break;
            }
            if (stopIdx == -1) {
                return qa;
            }
            TokenFilterFactory[] newtf = new TokenFilterFactory[facs.length - 1];
            int j = 0;
            for (int i = 0; i < facs.length; ++i) {
                if (i == stopIdx) continue;
                newtf[j++] = facs[i];
            }
            TokenizerChain newa = new TokenizerChain(tcq.getTokenizerFactory(), newtf);
            newa.setPositionIncrementGap(tcq.getPositionIncrementGap(fieldName));
            return newa;
        }

        protected class Alias {
            public float tie;
            public Map<String, Float> fields;

            protected Alias() {
            }
        }
    }

    static enum QType {
        FIELD,
        PHRASE,
        PREFIX,
        WILDCARD,
        FUZZY,
        RANGE;

    }

    static class Clause {
        String field;
        String rawField;
        boolean isPhrase;
        boolean hasWhitespace;
        boolean hasSpecialSyntax;
        boolean syntaxError;
        char must;
        String val;
        String raw;

        Clause() {
        }

        boolean isBareWord() {
            return this.must == '\u0000' && !this.isPhrase;
        }
    }

    private static interface DMP
    extends DisMaxParams {
        public static final String UF = "uf";
    }

    private static class U
    extends SolrPluginUtils {
        private U() {
        }
    }
}

