/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.spatial4j.core.context.ParseUtils;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.simple.SimpleSpatialContext;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.util.GeohashUtils;
import java.io.IOException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.LiteralValueSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.search.function.distance.GeohashHaversineFunction;

public class GeoHashField
extends FieldType
implements SpatialQueryable {
    private final SpatialContext ctx = SimpleSpatialContext.GEO_KM;

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        double[] point = new double[]{};
        try {
            point = ParseUtils.parsePointDouble(null, (String)options.pointStr, (int)2);
        }
        catch (InvalidShapeException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        String geohash = GeohashUtils.encodeLatLon((double)point[0], (double)point[1]);
        return new SolrConstantScoreQuery(new ValueSourceRangeFilter(new GeohashHaversineFunction(this.getValueSource(options.field, parser), (ValueSource)new LiteralValueSource(geohash), options.radius), "0", String.valueOf(options.distance), true, true));
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, this.toExternal(f), false);
    }

    @Override
    public String toExternal(IndexableField f) {
        Point p = GeohashUtils.decode((String)f.stringValue(), (SpatialContext)this.ctx);
        return p.getY() + "," + p.getX();
    }

    @Override
    public String toInternal(String val) {
        double[] latLon = new double[]{};
        try {
            latLon = ParseUtils.parseLatitudeLongitude(null, (String)val);
        }
        catch (InvalidShapeException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        return GeohashUtils.encodeLatLon((double)latLon[0], (double)latLon[1]);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new StrFieldSource(field.name);
    }
}

