/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.Map;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardLeaderElectionContext
extends ShardLeaderElectionContextBase {
    private static Logger log = LoggerFactory.getLogger(ShardLeaderElectionContext.class);
    private ZkController zkController;
    private CoreContainer cc;
    private SyncStrategy syncStrategy = new SyncStrategy();

    public ShardLeaderElectionContext(LeaderElector leaderElector, String shardId, String collection, String shardZkNodeName, ZkNodeProps props, ZkController zkController, CoreContainer cc) {
        super(leaderElector, shardId, collection, shardZkNodeName, props, zkController.getZkStateReader());
        this.zkController = zkController;
        this.cc = cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runLeaderProcess(boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        if (this.cc != null) {
            String coreName = this.leaderProps.get("core");
            SolrCore core = null;
            try {
                core = this.cc.getCore(coreName);
                if (core == null) {
                    this.cancelElection();
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fatal Error, SolrCore not found:" + coreName + " in " + this.cc.getCoreNames());
                }
                if (weAreReplacement && !this.shouldIBeLeader(this.leaderProps)) {
                    this.rejoinLeaderElection(this.leaderSeqPath, core);
                    return;
                }
                if (weAreReplacement) {
                    boolean success;
                    if (this.zkClient.exists(this.leaderPath, true).booleanValue()) {
                        this.zkClient.delete(this.leaderPath, -1, true);
                    }
                    if (!(success = this.syncStrategy.sync(this.zkController, core, this.leaderProps)) && this.anyoneElseActive()) {
                        this.rejoinLeaderElection(this.leaderSeqPath, core);
                        return;
                    }
                }
                core.getUpdateHandler().getSolrCoreState().cancelRecovery();
                this.zkController.publish(core.getCoreDescriptor(), "active");
            }
            finally {
                if (core != null) {
                    core.close();
                }
            }
        }
        super.runLeaderProcess(weAreReplacement);
    }

    private void rejoinLeaderElection(String leaderSeqPath, SolrCore core) throws InterruptedException, KeeperException, IOException {
        log.info("There is a better leader candidate than us - going back into recovery");
        this.zkController.publish(core.getCoreDescriptor(), "down");
        this.cancelElection();
        core.getUpdateHandler().getSolrCoreState().doRecovery(this.cc, core.getName());
        this.leaderElector.joinElection(this);
    }

    private boolean shouldIBeLeader(ZkNodeProps leaderProps) {
        ClusterState clusterState = this.zkController.getZkStateReader().getClusterState();
        Map slices = clusterState.getSlices(this.collection);
        Slice slice = (Slice)slices.get(this.shardId);
        Map shards = slice.getShards();
        boolean foundSomeoneElseActive = false;
        for (Map.Entry shard : shards.entrySet()) {
            String state = ((ZkNodeProps)shard.getValue()).get("state");
            if (new ZkCoreNodeProps((ZkNodeProps)shard.getValue()).getCoreUrl().equals(new ZkCoreNodeProps(leaderProps).getCoreUrl()) && state.equals("active") && clusterState.liveNodesContain(((ZkNodeProps)shard.getValue()).get("node_name"))) {
                return true;
            }
            if (!state.equals("active") || !clusterState.liveNodesContain(((ZkNodeProps)shard.getValue()).get("node_name")) || new ZkCoreNodeProps((ZkNodeProps)shard.getValue()).getCoreUrl().equals(new ZkCoreNodeProps(leaderProps).getCoreUrl())) continue;
            foundSomeoneElseActive = true;
        }
        return !foundSomeoneElseActive;
    }

    private boolean anyoneElseActive() {
        ClusterState clusterState = this.zkController.getZkStateReader().getClusterState();
        Map slices = clusterState.getSlices(this.collection);
        Slice slice = (Slice)slices.get(this.shardId);
        Map shards = slice.getShards();
        for (Map.Entry shard : shards.entrySet()) {
            String state = ((ZkNodeProps)shard.getValue()).get("state");
            if (!state.equals("active") || !clusterState.liveNodesContain(((ZkNodeProps)shard.getValue()).get("node_name"))) continue;
            return true;
        }
        return false;
    }
}

