/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.cloud.AssignShard;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.OverseerCollectionProcessor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overseer {
    public static final String QUEUE_OPERATION = "operation";
    private static final int STATE_UPDATE_DELAY = 500;
    private static Logger log = LoggerFactory.getLogger(Overseer.class);
    private Thread ccThread;
    private Thread updaterThread;
    private volatile boolean isClosed;
    private ZkStateReader reader;
    private ShardHandler shardHandler;
    private String adminPath;

    public Overseer(ShardHandler shardHandler, String adminPath, ZkStateReader reader) throws KeeperException, InterruptedException {
        this.reader = reader;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
    }

    public void start(String id) {
        log.info("Overseer (id=" + id + ") starting");
        Overseer.createOverseerNode(this.reader.getZkClient());
        ThreadGroup tg = new ThreadGroup("Overseer state updater.");
        this.updaterThread = new Thread(tg, new ClusterStateUpdater(this.reader, id));
        this.updaterThread.setDaemon(true);
        ThreadGroup ccTg = new ThreadGroup("Overseer collection creation process.");
        this.ccThread = new Thread(ccTg, new OverseerCollectionProcessor(this.reader, id, this.shardHandler, this.adminPath), "Overseer-" + id);
        this.ccThread.setDaemon(true);
        this.updaterThread.start();
        this.ccThread.start();
    }

    public void close() {
        this.isClosed = true;
    }

    public static DistributedQueue getInQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue", null);
    }

    static DistributedQueue getInternalQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue-work", null);
    }

    static DistributedQueue getCollectionQueue(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/collection-queue-work", null);
    }

    private static void createOverseerNode(SolrZkClient zkClient) {
        try {
            zkClient.create("/overseer", new byte[0], CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
        }
        catch (InterruptedException e) {
            log.error("Could not create Overseer node: " + e.getClass() + ":" + e.getMessage());
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("Could not create Overseer node: " + ((Object)((Object)e)).getClass() + ":" + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private class ClusterStateUpdater
    implements Runnable {
        private static final String DELETECORE = "deletecore";
        private final ZkStateReader reader;
        private final SolrZkClient zkClient;
        private final String myId;
        private final DistributedQueue stateUpdateQueue;
        private final DistributedQueue workQueue;

        public ClusterStateUpdater(ZkStateReader reader, String myId) {
            this.zkClient = reader.getZkClient();
            this.stateUpdateQueue = Overseer.getInQueue(this.zkClient);
            this.workQueue = Overseer.getInternalQueue(this.zkClient);
            this.myId = myId;
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String operation;
            ZkNodeProps message;
            ClusterState clusterState;
            byte[] head;
            Object object;
            if (this.amILeader() && !Overseer.this.isClosed) {
                object = this.reader.getUpdateLock();
                synchronized (object) {
                    try {
                        head = this.workQueue.peek();
                        if (head != null) {
                            this.reader.updateClusterState(true);
                            clusterState = this.reader.getClusterState();
                            log.info("Replaying operations from work queue.");
                            while (head != null && this.amILeader()) {
                                message = ZkNodeProps.load((byte[])head);
                                operation = message.get(Overseer.QUEUE_OPERATION);
                                clusterState = this.processMessage(clusterState, message, operation);
                                this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON((Object)clusterState), true);
                                this.workQueue.remove();
                                head = this.workQueue.peek();
                            }
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("Solr cannot talk to ZK");
                            return;
                        }
                        SolrException.log((Logger)log, (String)"", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            log.info("Starting to work on the main queue");
            while (this.amILeader() && !Overseer.this.isClosed) {
                object = this.reader.getUpdateLock();
                synchronized (object) {
                    try {
                        head = this.stateUpdateQueue.peek();
                        if (head != null) {
                            this.reader.updateClusterState(true);
                            clusterState = this.reader.getClusterState();
                            while (head != null) {
                                message = ZkNodeProps.load((byte[])head);
                                operation = message.get(Overseer.QUEUE_OPERATION);
                                clusterState = this.processMessage(clusterState, message, operation);
                                byte[] processed = this.stateUpdateQueue.remove();
                                this.workQueue.offer(processed);
                                head = this.stateUpdateQueue.peek();
                            }
                            this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON((Object)clusterState), true);
                        }
                        while (this.workQueue.poll() != null) {
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                            log.warn("Overseer cannot talk to ZK");
                            return;
                        }
                        SolrException.log((Logger)log, (String)"", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private ClusterState processMessage(ClusterState clusterState, ZkNodeProps message, String operation) {
            if ("state".equals(operation)) {
                clusterState = this.updateState(clusterState, message);
            } else if (DELETECORE.equals(operation)) {
                clusterState = this.removeCore(clusterState, message);
            } else if ("leader".equals(operation)) {
                StringBuilder sb = new StringBuilder();
                String baseUrl = message.get("base_url");
                String coreName = message.get("core");
                sb.append(baseUrl);
                if (!baseUrl.endsWith("/")) {
                    sb.append("/");
                }
                sb.append(coreName == null ? "" : coreName);
                if (!sb.substring(sb.length() - 1).equals("/")) {
                    sb.append("/");
                }
                clusterState = this.setShardLeader(clusterState, message.get("collection"), message.get("shard"), sb.toString());
            } else {
                throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
            }
            return clusterState;
        }

        private boolean amILeader() {
            try {
                ZkNodeProps props = ZkNodeProps.load((byte[])this.zkClient.getData("/overseer_elect/leader", null, null, true));
                if (this.myId.equals(props.get("id"))) {
                    return true;
                }
            }
            catch (KeeperException e) {
                log.warn("", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
            return false;
        }

        private ClusterState updateState(ClusterState state, ZkNodeProps message) {
            String shardId;
            Integer numShards;
            String collection = message.get("collection");
            String zkCoreNodeName = message.get("node_name") + "_" + message.get("core");
            Integer n = numShards = message.get("numShards") != null ? Integer.valueOf(Integer.parseInt(message.get("numShards"))) : null;
            if (!state.getCollections().contains(collection) && numShards != null) {
                state = this.createCollection(state, collection, numShards);
            }
            if ((shardId = message.get("shard")) == null) {
                String nodeName = message.get("node_name");
                shardId = this.getAssignedId(state, nodeName, message);
            }
            if (shardId == null) {
                shardId = AssignShard.assignShard(collection, state, numShards);
            }
            HashMap props = new HashMap();
            HashMap coreProps = new HashMap(message.getProperties().size());
            coreProps.putAll(message.getProperties());
            coreProps.remove("numShards");
            coreProps.remove(Overseer.QUEUE_OPERATION);
            for (Map.Entry entry : coreProps.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
            ZkNodeProps zkProps = new ZkNodeProps(props);
            Slice slice = state.getSlice(collection, shardId);
            Map<String, Object> shardProps = slice == null ? new HashMap<String, ZkNodeProps>() : state.getSlice(collection, shardId).getShardsCopy();
            shardProps.put(zkCoreNodeName, zkProps);
            slice = new Slice(shardId, shardProps);
            ClusterState newClusterState = this.updateSlice(state, collection, slice);
            return newClusterState;
        }

        private ClusterState createCollection(ClusterState state, String collectionName, int numShards) {
            LinkedHashMap newStates = new LinkedHashMap();
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
            newStates.putAll(state.getCollectionStates());
            for (int i = 0; i < numShards; ++i) {
                String sliceName = "shard" + (i + 1);
                newSlices.put(sliceName, new Slice(sliceName, Collections.EMPTY_MAP));
            }
            newStates.put(collectionName, newSlices);
            ClusterState newClusterState = new ClusterState(state.getLiveNodes(), newStates);
            return newClusterState;
        }

        private String getAssignedId(ClusterState state, String nodeName, ZkNodeProps coreState) {
            String key = coreState.get("node_name") + "_" + coreState.get("core");
            Map slices = state.getSlices(coreState.get("collection"));
            if (slices != null) {
                for (Slice slice : slices.values()) {
                    if (slice.getShards().get(key) == null) continue;
                    return slice.getName();
                }
            }
            return null;
        }

        private ClusterState updateSlice(ClusterState state, String collection, Slice slice) {
            Map slices;
            LinkedHashMap newStates = new LinkedHashMap();
            newStates.putAll(state.getCollectionStates());
            if (!newStates.containsKey(collection)) {
                newStates.put(collection, new LinkedHashMap());
            }
            if (!(slices = (Map)newStates.get(collection)).containsKey(slice.getName())) {
                slices.put(slice.getName(), slice);
            } else {
                LinkedHashMap shards = new LinkedHashMap();
                Slice existingSlice = (Slice)slices.get(slice.getName());
                shards.putAll(existingSlice.getShards());
                for (Map.Entry edit : slice.getShards().entrySet()) {
                    if (existingSlice.getShards().get(edit.getKey()) != null && ((ZkNodeProps)existingSlice.getShards().get(edit.getKey())).containsKey("leader")) {
                        HashMap<String, String> newProps = new HashMap<String, String>();
                        newProps.putAll(((ZkNodeProps)edit.getValue()).getProperties());
                        newProps.put("leader", ((ZkNodeProps)existingSlice.getShards().get(edit.getKey())).get("leader"));
                        shards.put(edit.getKey(), new ZkNodeProps(newProps));
                        continue;
                    }
                    shards.put(edit.getKey(), edit.getValue());
                }
                Slice updatedSlice = new Slice(slice.getName(), shards);
                slices.put(slice.getName(), updatedSlice);
            }
            return new ClusterState(state.getLiveNodes(), newStates);
        }

        private ClusterState setShardLeader(ClusterState state, String collection, String sliceName, String leaderUrl) {
            LinkedHashMap newStates = new LinkedHashMap();
            newStates.putAll(state.getCollectionStates());
            Map slices = (Map)newStates.get(collection);
            if (slices == null) {
                log.error("Could not mark shard leader for non existing collection:" + collection);
                return state;
            }
            if (!slices.containsKey(sliceName)) {
                log.error("Could not mark leader for non existing slice:" + sliceName);
                return state;
            }
            LinkedHashMap newShards = new LinkedHashMap();
            for (Map.Entry shard : ((Slice)slices.get(sliceName)).getShards().entrySet()) {
                LinkedHashMap<String, String> newShardProps = new LinkedHashMap<String, String>();
                newShardProps.putAll(((ZkNodeProps)shard.getValue()).getProperties());
                newShardProps.remove("leader");
                ZkCoreNodeProps zkCoreNodeProps = new ZkCoreNodeProps(new ZkNodeProps(newShardProps));
                if (leaderUrl != null && leaderUrl.equals(zkCoreNodeProps.getCoreUrl())) {
                    newShardProps.put("leader", "true");
                }
                newShards.put(shard.getKey(), new ZkNodeProps(newShardProps));
            }
            Slice slice = new Slice(sliceName, newShards);
            slices.put(sliceName, slice);
            return new ClusterState(state.getLiveNodes(), newStates);
        }

        private ClusterState removeCore(ClusterState clusterState, ZkNodeProps message) {
            String coreNodeName = message.get("node_name") + "_" + message.get("core");
            String collection = message.get("collection");
            LinkedHashMap<String, Map> newStates = new LinkedHashMap<String, Map>();
            for (String collectionName : clusterState.getCollections()) {
                if (collection.equals(collectionName)) {
                    Map slices = clusterState.getSlices(collection);
                    LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
                    for (Slice slice : slices.values()) {
                        if (slice.getShards().containsKey(coreNodeName)) {
                            LinkedHashMap newShards = new LinkedHashMap();
                            newShards.putAll(slice.getShards());
                            newShards.remove(coreNodeName);
                            Slice newSlice = new Slice(slice.getName(), newShards);
                            newSlices.put(slice.getName(), newSlice);
                            continue;
                        }
                        newSlices.put(slice.getName(), slice);
                    }
                    int cnt = 0;
                    for (Slice slice : newSlices.values()) {
                        cnt += slice.getShards().size();
                    }
                    if (cnt > 0) {
                        newStates.put(collectionName, newSlices);
                        continue;
                    }
                    try {
                        this.zkClient.clean("/collections/" + collectionName);
                    }
                    catch (InterruptedException e) {
                        SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collectionName), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (KeeperException e) {
                        SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collectionName), (Throwable)e);
                    }
                    continue;
                }
                newStates.put(collectionName, clusterState.getSlices(collectionName));
            }
            ClusterState newState = new ClusterState(clusterState.getLiveNodes(), newStates);
            return newState;
        }
    }
}

