/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElector {
    private static Logger log = LoggerFactory.getLogger(LeaderElector.class);
    private static final String ELECTION_NODE = "/election";
    private static final Pattern LEADER_SEQ = Pattern.compile(".*?/?.*?-n_(\\d+)");
    private static final Pattern SESSION_ID = Pattern.compile(".*?/?(.*?-.*?)-n_\\d+");
    protected SolrZkClient zkClient;
    private ZkCmdExecutor zkCmdExecutor = new ZkCmdExecutor();

    public LeaderElector(SolrZkClient zkClient) {
        this.zkClient = zkClient;
    }

    private void checkIfIamLeader(final int seq, final ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        String holdElectionPath = context.electionPath + ELECTION_NODE;
        List seqs = this.zkClient.getChildren(holdElectionPath, null, true);
        this.sortSeqs(seqs);
        List<Integer> intSeqs = this.getSeqs(seqs);
        if (seq <= intSeqs.get(0)) {
            this.runIamLeaderProcess(context, replacement);
        } else {
            int s;
            int i;
            for (i = 1; i < intSeqs.size() && seq >= (s = intSeqs.get(i).intValue()); ++i) {
            }
            int index = i - 2;
            if (index < 0) {
                log.warn("Our node is no longer in line to be leader");
                return;
            }
            try {
                this.zkClient.getData(holdElectionPath + "/" + (String)seqs.get(index), new Watcher(){

                    public void process(WatchedEvent event) {
                        if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                            return;
                        }
                        try {
                            LeaderElector.this.checkIfIamLeader(seq, context, true);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.warn("", (Throwable)e);
                        }
                        catch (IOException e) {
                            log.warn("", (Throwable)e);
                        }
                        catch (Exception e) {
                            log.warn("", (Throwable)e);
                        }
                    }
                }, null, true);
            }
            catch (KeeperException.SessionExpiredException e) {
                throw e;
            }
            catch (KeeperException e) {
                this.checkIfIamLeader(seq, context, true);
            }
        }
    }

    protected void runIamLeaderProcess(ElectionContext context, boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        context.runLeaderProcess(weAreReplacement);
    }

    private int getSeq(String nStringSequence) {
        int seq = 0;
        Matcher m = LEADER_SEQ.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        seq = Integer.parseInt(m.group(1));
        return seq;
    }

    private String getNodeId(String nStringSequence) {
        Matcher m = SESSION_ID.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String id = m.group(1);
        return id;
    }

    private List<Integer> getSeqs(List<String> seqs) {
        ArrayList<Integer> intSeqs = new ArrayList<Integer>(seqs.size());
        for (String seq : seqs) {
            intSeqs.add(this.getSeq(seq));
        }
        return intSeqs;
    }

    public int joinElection(ElectionContext context) throws KeeperException, InterruptedException, IOException {
        String shardsElectZkPath = context.electionPath + ELECTION_NODE;
        long sessionId = this.zkClient.getSolrZooKeeper().getSessionId();
        String id = sessionId + "-" + context.id;
        String leaderSeqPath = null;
        boolean cont = true;
        int tries = 0;
        while (cont) {
            try {
                context.leaderSeqPath = leaderSeqPath = this.zkClient.create(shardsElectZkPath + "/" + id + "-n_", null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
                cont = false;
            }
            catch (KeeperException.ConnectionLossException e) {
                List entries = this.zkClient.getChildren(shardsElectZkPath, null, true);
                boolean foundId = false;
                for (String entry : entries) {
                    String nodeId = this.getNodeId(entry);
                    if (!id.equals(nodeId)) continue;
                    foundId = true;
                    break;
                }
                if (foundId) continue;
                throw e;
            }
            catch (KeeperException.NoNodeException e) {
                if (tries++ > 9) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                cont = true;
                Thread.sleep(50L);
            }
        }
        int seq = this.getSeq(leaderSeqPath);
        this.checkIfIamLeader(seq, context, false);
        return seq;
    }

    public void setup(ElectionContext context) throws InterruptedException, KeeperException {
        String electZKPath = context.electionPath + ELECTION_NODE;
        this.zkCmdExecutor.ensureExists(electZKPath, this.zkClient);
    }

    private void sortSeqs(List<String> seqs) {
        Collections.sort(seqs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(LeaderElector.this.getSeq(o1)).compareTo(LeaderElector.this.getSeq(o2));
            }
        });
    }
}

