/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.TrieField;

final class TrieTokenizer
extends Tokenizer {
    protected static final DateField dateField = new DateField();
    protected final int precisionStep;
    protected final TrieField.TrieTypes type;
    protected final NumericTokenStream ts;
    protected final OffsetAttribute ofsAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    protected int startOfs;
    protected int endOfs;

    static NumericTokenStream getNumericTokenStream(int precisionStep) {
        return new NumericTokenStream(precisionStep);
    }

    public TrieTokenizer(Reader input, TrieField.TrieTypes type, int precisionStep, NumericTokenStream ts) {
        super((AttributeSource)ts, input);
        this.type = type;
        this.precisionStep = precisionStep;
        this.ts = ts;
        this.setReader(input);
    }

    public void setReader(Reader input) {
        try {
            super.setReader(input);
            input = this.input;
            char[] buf = new char[32];
            int len = input.read(buf);
            this.startOfs = this.correctOffset(0);
            this.endOfs = this.correctOffset(len);
            String v = new String(buf, 0, len);
            try {
                switch (this.type) {
                    case INTEGER: {
                        this.ts.setIntValue(Integer.parseInt(v));
                        break;
                    }
                    case FLOAT: {
                        this.ts.setFloatValue(Float.parseFloat(v));
                        break;
                    }
                    case LONG: {
                        this.ts.setLongValue(Long.parseLong(v));
                        break;
                    }
                    case DOUBLE: {
                        this.ts.setDoubleValue(Double.parseDouble(v));
                        break;
                    }
                    case DATE: {
                        this.ts.setLongValue(dateField.parseMath(null, v).getTime());
                        break;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field");
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Number: " + v);
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create TrieIndexTokenizer", (Throwable)e);
        }
    }

    public void close() throws IOException {
        super.close();
        this.ts.close();
    }

    public void reset() throws IOException {
        super.reset();
        this.ts.reset();
    }

    public boolean incrementToken() {
        if (this.ts.incrementToken()) {
            this.ofsAtt.setOffset(this.startOfs, this.endOfs);
            return true;
        }
        return false;
    }

    public void end() throws IOException {
        this.ts.end();
        this.ofsAtt.setOffset(this.endOfs, this.endOfs);
    }
}

