/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.List;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexConfig {
    public static final Logger log = LoggerFactory.getLogger(SolrIndexConfig.class);
    final String defaultMergePolicyClassName;
    public static final String DEFAULT_MERGE_SCHEDULER_CLASSNAME = ConcurrentMergeScheduler.class.getName();
    public final Version luceneVersion;
    public final boolean useCompoundFile;
    public final int maxBufferedDocs;
    public final int maxMergeDocs;
    public final int mergeFactor;
    public final double ramBufferSizeMB;
    public final int writeLockTimeout;
    public final String lockType;
    public final PluginInfo mergePolicyInfo;
    public final PluginInfo mergeSchedulerInfo;
    public final int termIndexInterval;
    public String infoStreamFile = null;
    public static final String LOCK_TYPE_SIMPLE = "simple";
    public static final String LOCK_TYPE_NATIVE = "native";
    public static final String LOCK_TYPE_SINGLE = "single";
    public static final String LOCK_TYPE_NONE = "none";

    private SolrIndexConfig(SolrConfig solrConfig) {
        this.luceneVersion = solrConfig.luceneMatchVersion;
        this.useCompoundFile = !this.luceneVersion.onOrAfter(Version.LUCENE_36);
        this.maxBufferedDocs = -1;
        this.maxMergeDocs = -1;
        this.mergeFactor = -1;
        this.ramBufferSizeMB = this.luceneVersion.onOrAfter(Version.LUCENE_36) ? 32.0 : 16.0;
        this.writeLockTimeout = -1;
        this.lockType = this.luceneVersion.onOrAfter(Version.LUCENE_36) ? LOCK_TYPE_NATIVE : LOCK_TYPE_SIMPLE;
        this.termIndexInterval = 32;
        this.mergePolicyInfo = null;
        this.mergeSchedulerInfo = null;
        this.defaultMergePolicyClassName = this.luceneVersion.onOrAfter(Version.LUCENE_33) ? TieredMergePolicy.class.getName() : LogByteSizeMergePolicy.class.getName();
    }

    public SolrIndexConfig(SolrConfig solrConfig, String prefix, SolrIndexConfig def) {
        if (prefix == null) {
            prefix = "indexConfig";
            log.debug("Defaulting to prefix \"" + prefix + "\" for index configuration");
        }
        if (def == null) {
            def = new SolrIndexConfig(solrConfig);
        }
        this.luceneVersion = solrConfig.luceneMatchVersion;
        this.assertWarnOrFail("The <mergeScheduler>myclass</mergeScheduler> syntax is no longer supported in solrconfig.xml. Please use syntax <mergeScheduler class=\"myclass\"/> instead.", solrConfig.get(prefix + "/mergeScheduler/text()", null) == null || solrConfig.get(prefix + "/mergeScheduler/@class", null) != null, this.luceneVersion.onOrAfter(Version.LUCENE_36));
        this.assertWarnOrFail("The <mergePolicy>myclass</mergePolicy> syntax is no longer supported in solrconfig.xml. Please use syntax <mergePolicy class=\"myclass\"/> instead.", solrConfig.get(prefix + "/mergePolicy/text()", null) == null || solrConfig.get(prefix + "/mergePolicy/@class", null) != null, this.luceneVersion.onOrAfter(Version.LUCENE_36));
        this.assertWarnOrFail("The <luceneAutoCommit>true|false</luceneAutoCommit> parameter is no longer valid in solrconfig.xml.", solrConfig.get(prefix + "/luceneAutoCommit", null) == null, this.luceneVersion.onOrAfter(Version.LUCENE_36));
        this.defaultMergePolicyClassName = def.defaultMergePolicyClassName;
        this.useCompoundFile = solrConfig.getBool(prefix + "/useCompoundFile", def.useCompoundFile);
        this.maxBufferedDocs = solrConfig.getInt(prefix + "/maxBufferedDocs", def.maxBufferedDocs);
        this.maxMergeDocs = solrConfig.getInt(prefix + "/maxMergeDocs", def.maxMergeDocs);
        this.mergeFactor = solrConfig.getInt(prefix + "/mergeFactor", def.mergeFactor);
        this.ramBufferSizeMB = solrConfig.getDouble(prefix + "/ramBufferSizeMB", def.ramBufferSizeMB);
        this.writeLockTimeout = solrConfig.getInt(prefix + "/writeLockTimeout", def.writeLockTimeout);
        this.lockType = solrConfig.get(prefix + "/lockType", def.lockType);
        this.mergeSchedulerInfo = this.getPluginInfo(prefix + "/mergeScheduler", solrConfig, def.mergeSchedulerInfo);
        this.mergePolicyInfo = this.getPluginInfo(prefix + "/mergePolicy", solrConfig, def.mergePolicyInfo);
        this.termIndexInterval = solrConfig.getInt(prefix + "/termIndexInterval", def.termIndexInterval);
        boolean infoStreamEnabled = solrConfig.getBool(prefix + "/infoStream", false);
        if (infoStreamEnabled) {
            this.infoStreamFile = solrConfig.get(prefix + "/infoStream/@file", null);
            log.info("IndexWriter infoStream debug log is enabled: " + this.infoStreamFile);
        }
    }

    private void assertWarnOrFail(String reason, boolean assertCondition, boolean failCondition) {
        if (assertCondition) {
            return;
        }
        if (failCondition) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, reason);
        }
        log.warn(reason);
    }

    private PluginInfo getPluginInfo(String path, SolrConfig solrConfig, PluginInfo def) {
        List<PluginInfo> l = solrConfig.readPluginInfos(path, false, true);
        return l.isEmpty() ? def : l.get(0);
    }

    public IndexWriterConfig toIndexWriterConfig(IndexSchema schema) {
        IndexWriterConfig iwc = new IndexWriterConfig(this.luceneVersion, schema.getAnalyzer());
        if (this.maxBufferedDocs != -1) {
            iwc.setMaxBufferedDocs(this.maxBufferedDocs);
        }
        if (this.ramBufferSizeMB != -1.0) {
            iwc.setRAMBufferSizeMB(this.ramBufferSizeMB);
        }
        if (this.termIndexInterval != -1) {
            iwc.setTermIndexInterval(this.termIndexInterval);
        }
        if (this.writeLockTimeout != -1) {
            iwc.setWriteLockTimeout((long)this.writeLockTimeout);
        }
        iwc.setSimilarity(schema.getSimilarity());
        iwc.setMergePolicy(this.buildMergePolicy(schema));
        iwc.setMergeScheduler(this.buildMergeScheduler(schema));
        return iwc;
    }

    private MergePolicy buildMergePolicy(IndexSchema schema) {
        String mpClassName = this.mergePolicyInfo == null ? this.defaultMergePolicyClassName : this.mergePolicyInfo.className;
        MergePolicy policy = schema.getResourceLoader().newInstance(mpClassName, MergePolicy.class, new String[0]);
        if (policy instanceof LogMergePolicy) {
            LogMergePolicy logMergePolicy = (LogMergePolicy)policy;
            if (this.maxMergeDocs != -1) {
                logMergePolicy.setMaxMergeDocs(this.maxMergeDocs);
            }
            logMergePolicy.setUseCompoundFile(this.useCompoundFile);
            if (this.mergeFactor != -1) {
                logMergePolicy.setMergeFactor(this.mergeFactor);
            }
        } else if (policy instanceof TieredMergePolicy) {
            TieredMergePolicy tieredMergePolicy = (TieredMergePolicy)policy;
            tieredMergePolicy.setUseCompoundFile(this.useCompoundFile);
            if (this.mergeFactor != -1) {
                tieredMergePolicy.setMaxMergeAtOnce(this.mergeFactor);
                tieredMergePolicy.setSegmentsPerTier((double)this.mergeFactor);
            }
        } else {
            log.warn("Use of compound file format or mergefactor cannot be configured if merge policy is not an instance of LogMergePolicy or TieredMergePolicy. The configured policy's defaults will be used.");
        }
        if (this.mergePolicyInfo != null) {
            SolrPluginUtils.invokeSetters(policy, this.mergePolicyInfo.initArgs);
        }
        return policy;
    }

    private MergeScheduler buildMergeScheduler(IndexSchema schema) {
        String msClassName = this.mergeSchedulerInfo == null ? DEFAULT_MERGE_SCHEDULER_CLASSNAME : this.mergeSchedulerInfo.className;
        MergeScheduler scheduler = schema.getResourceLoader().newInstance(msClassName, MergeScheduler.class, new String[0]);
        if (this.mergeSchedulerInfo != null) {
            SolrPluginUtils.invokeSetters(scheduler, this.mergeSchedulerInfo.initArgs);
        }
        return scheduler;
    }
}

